/*
 * Decompiled with CFR 0.152.
 */
package org.jagatoo.loaders.models.tds.chunks.processors;

import java.io.IOException;
import org.jagatoo.loaders.models._util.AnimationFactory;
import org.jagatoo.loaders.models._util.AppearanceFactory;
import org.jagatoo.loaders.models._util.GeometryFactory;
import org.jagatoo.loaders.models._util.NodeFactory;
import org.jagatoo.loaders.models._util.SpecialItemsHandler;
import org.jagatoo.loaders.models.tds.TDSFile;
import org.jagatoo.loaders.models.tds.chunks.processors.TransformTrackProcessor;
import org.jagatoo.loaders.models.tds.internal.ModelContext;
import org.jagatoo.loaders.models.tds.internal.PosTransform;
import org.jagatoo.logging.JAGTLog;
import org.openmali.vecmath2.Point3f;
import org.openmali.vecmath2.Vector3f;

public class PosTrackProcessor
extends TransformTrackProcessor {
    public static final int ANIM_TYPE_SINGLE = 0;
    public static final int ANIM_TYPE_REPEAT = 2;
    public static final int ANIM_TYPE_LOOP = 3;

    private void getSplineTerms(int accelerationData, TDSFile file) throws IOException {
        if (accelerationData == 0) {
            return;
        }
        int bits = accelerationData;
        int i = 0;
        while (i < 5) {
            if (((bits >>>= i) & 1) == 1) {
                file.readFloat();
            }
            ++i;
        }
    }

    public void process(TDSFile file, AppearanceFactory appFactory, GeometryFactory geomFactory, NodeFactory nodeFactory, AnimationFactory animFactory, SpecialItemsHandler siHandler, ModelContext context, int length) throws IOException {
        file.readUnsignedShort();
        file.skipBytes(8);
        int numKeys = file.readUnsignedInt();
        context.translation = new PosTransform();
        JAGTLog.debug("Translation key frames: ", numKeys);
        int i = 0;
        while (i < numKeys) {
            int frameNumber = file.readUnsignedInt();
            int accelerationData = file.readUnsignedShort();
            this.getSplineTerms(accelerationData, file);
            float x = file.readFloat();
            float y = file.readFloat();
            float z = file.readFloat();
            Object translation = numKeys == 1 && x == 0.0f && y == 0.0f && z == 0.0f ? null : new Vector3f(x, y, z);
            if (context.pivot == null) {
                context.pivot = new Point3f(0.0f, 0.0f, 0.0f);
            }
            JAGTLog.debug("\tTranslation key frame: ", String.valueOf(frameNumber) + " : ", translation);
            context.translation.addKeyFrame(frameNumber, (float)frameNumber / (float)context.framesCount, (Vector3f)translation);
            ++i;
        }
        PosTrackProcessor.checkAndApplyTransform(context, false, nodeFactory, animFactory, siHandler, file.convertZup2Yup());
    }
}

