/*
 * Decompiled with CFR 0.152.
 */
package org.jagatoo.loaders.models.tds.internal;

import java.util.ArrayList;
import org.openmali.vecmath2.TupleNf;
import org.openmali.vecmath2.Vector3f;

public class PosTransform {
    final ArrayList<PosFrame> frames = new ArrayList();

    public void addKeyFrame(int frameIndex, float time, Vector3f pos) {
        this.frames.add(new PosFrame(frameIndex, time, pos));
    }

    public int getFrameByFrameNumber(int frameNumber) {
        int i = 0;
        while (i < this.frames.size()) {
            if (this.frames.get((int)i).frameIndex == frameNumber) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void getTranslationAtTime(float time, Vector3f translation) {
        if (this.frames.size() == 1) {
            if (this.frames.get((int)0).offset == null) {
                translation.setZero();
            } else {
                translation.set((TupleNf)this.frames.get((int)0).offset);
            }
            return;
        }
        PosFrame prevFrame = null;
        PosFrame nextFrame = null;
        int i = 0;
        while (i < this.frames.size()) {
            prevFrame = this.frames.get(i);
            if (i < this.frames.size() - 1) {
                nextFrame = this.frames.get(i + 1);
                if (time >= prevFrame.time && time < nextFrame.time) {
                    break;
                }
            } else {
                nextFrame = this.frames.get(0);
            }
            ++i;
        }
        float deltaTime = nextFrame.time - prevFrame.time;
        if (i == this.frames.size() - 1) {
            deltaTime = 1.0f - prevFrame.time;
        }
        float delta = (time - prevFrame.time) / deltaTime;
        translation.set(nextFrame.offset.getX() * delta + prevFrame.offset.getX() * (1.0f - delta), nextFrame.offset.getY() * delta + prevFrame.offset.getY() * (1.0f - delta), nextFrame.offset.getZ() * delta + prevFrame.offset.getZ() * (1.0f - delta));
    }

    public String toString() {
        String s = String.valueOf(this.getClass().getSimpleName()) + " ( ";
        int i = 0;
        while (i < this.frames.size()) {
            if (i > 0) {
                s = String.valueOf(s) + ", ";
            }
            s = String.valueOf(s) + this.frames.get((int)i).time + ": " + this.frames.get((int)i).offset;
            ++i;
        }
        s = String.valueOf(s) + " )";
        return s;
    }

    class PosFrame {
        public final int frameIndex;
        public final float time;
        public final Vector3f offset;

        public PosFrame(int frameIndex, float time, Vector3f pos) {
            this.frameIndex = frameIndex;
            this.time = time;
            this.offset = pos;
        }
    }
}

