/*
 * Decompiled with CFR 0.152.
 */
package org.jagatoo.loaders.textures;

import org.jagatoo.loaders.textures.AbstractTexture;
import org.jagatoo.loaders.textures.AbstractTextureImage;
import org.jagatoo.opengl.enums.TextureFormat;
import org.jagatoo.opengl.enums.TextureImageFormat;
import org.jagatoo.opengl.enums.TextureImageInternalFormat;
import org.jagatoo.opengl.enums.TextureType;

public abstract class TextureFactory {
    protected abstract AbstractTextureImage createTextureImageImpl(int var1, int var2, int var3, int var4, int var5, int var6, TextureImageInternalFormat var7, TextureImageFormat var8);

    public final AbstractTextureImage createTextureImage(int width, int height, int orgWidth, int orgHeight, int pixelSize, int dataSizeHint, TextureImageInternalFormat internalFormat, TextureImageFormat format) {
        if (width < 1 || height < 1 || orgWidth < 1 || orgHeight < 1) {
            throw new IllegalArgumentException("Illegal size " + width + "x" + height + ", " + orgWidth + "x" + orgHeight);
        }
        if (pixelSize >= 8) {
            pixelSize /= 8;
        }
        int dataSize = dataSizeHint;
        if (dataSizeHint < 0) {
            if (pixelSize < 0) {
                throw new IllegalArgumentException("You cannot set both pixelSize AND dataSizeHint to -1.");
            }
            dataSize = width * height * pixelSize;
        }
        return this.createTextureImageImpl(width, height, orgWidth, orgHeight, pixelSize, dataSize, internalFormat, format);
    }

    public final AbstractTextureImage createTextureImage(int width, int height, int orgWidth, int orgHeight, int pixelSize, TextureImageInternalFormat internalFormat, TextureImageFormat format) {
        return this.createTextureImage(width, height, orgWidth, orgHeight, pixelSize, -1, internalFormat, format);
    }

    public final AbstractTextureImage createTextureImage(int width, int height, int orgWidth, int orgHeight, int pixelSize, TextureImageFormat format) {
        return this.createTextureImage(width, height, orgWidth, orgHeight, pixelSize, TextureImageInternalFormat.getFallbackInternalFormat(format), format);
    }

    public final AbstractTextureImage createTextureImage(int width, int height, int orgWidth, int orgHeight, int pixelSize, boolean withAlphaChannel) {
        TextureImageFormat format = withAlphaChannel ? TextureImageFormat.RGBA : TextureImageFormat.RGB;
        return this.createTextureImage(width, height, orgWidth, orgHeight, pixelSize, TextureImageInternalFormat.getFallbackInternalFormat(format), format);
    }

    public final AbstractTextureImage createTextureImage(int width, int height, int orgWidth, int orgHeight, int pixelSize) {
        TextureImageFormat format;
        if (pixelSize >= 8) {
            pixelSize /= 8;
        }
        switch (pixelSize) {
            case 1: {
                format = TextureImageFormat.DEPTH;
                break;
            }
            case 2: {
                format = TextureImageFormat.LUMINANCE_ALPHA;
                break;
            }
            case 3: {
                format = TextureImageFormat.RGB;
                break;
            }
            case 4: {
                format = TextureImageFormat.RGBA;
                break;
            }
            default: {
                throw new Error("Unsupported pixel-size: " + pixelSize);
            }
        }
        return this.createTextureImage(width, height, orgWidth, orgHeight, pixelSize, format);
    }

    protected abstract AbstractTexture createTextureImpl(TextureType var1, TextureFormat var2);

    public final AbstractTexture createTexture(TextureType type, TextureFormat format) {
        return this.createTextureImpl(type, format);
    }

    public final AbstractTexture createTexture(TextureFormat format) {
        return this.createTexture(TextureType.TEXTURE_2D, format);
    }

    public final AbstractTexture createTexture(TextureImageFormat imageFormat) {
        return this.createTexture(TextureType.TEXTURE_2D, TextureFormat.getFormat(imageFormat));
    }

    public final AbstractTexture createTexture(boolean withAlphaChannel) {
        return this.createTexture(TextureType.TEXTURE_2D, withAlphaChannel ? TextureFormat.RGBA : TextureFormat.RGB);
    }
}

