/*
 * Decompiled with CFR 0.152.
 */
package org.jagatoo.loaders.textures.cache;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Stack;
import org.jagatoo.loaders.textures.AbstractTexture;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TextureCache {
    private final Stack<Boolean> enabledStack = new Stack();
    private boolean enabled = true;
    private final ArrayList<String> cacheKeys = new ArrayList();

    public synchronized void setEnabled(boolean enabled) {
        this.enabledStack.set(this.enabledStack.size() - 1, enabled);
        this.enabled = enabled;
    }

    public synchronized void pushEnabled(boolean enabled) {
        this.enabledStack.push(enabled);
        this.enabled = enabled;
    }

    public synchronized void popEnabled() {
        if (this.enabledStack.size() <= 1) {
            return;
        }
        this.enabledStack.pop();
        this.enabled = this.enabledStack.peek();
    }

    public final boolean isEnabled() {
        return this.enabled;
    }

    protected abstract void addImpl(String var1, AbstractTexture var2);

    public final synchronized void add(String key, AbstractTexture texture) {
        this.cacheKeys.add(key);
        this.addImpl(key, texture);
    }

    protected abstract void removeImpl(AbstractTexture var1);

    public final synchronized void remove(AbstractTexture texture) {
        this.cacheKeys.remove(texture.getCacheKey());
    }

    public abstract AbstractTexture get(String var1);

    public final synchronized String[] getCachedKeys() {
        String[] keys = new String[this.cacheKeys.size()];
        keys = this.cacheKeys.toArray(keys);
        return keys;
    }

    public abstract Collection<AbstractTexture> getCachedTextures();

    public abstract void clear();

    protected TextureCache() {
        this.enabledStack.push(Boolean.TRUE);
    }
}

