/*
 * Decompiled with CFR 0.152.
 */
package org.jagatoo.loaders.textures.formats;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.jagatoo.loaders.textures.AbstractTextureImage;
import org.jagatoo.loaders.textures.TextureFactory;
import org.jagatoo.loaders.textures.formats.TextureImageFormatLoader;
import org.jagatoo.util.streams.StreamUtils;

public class TextureImageFormatLoaderPCX
implements TextureImageFormatLoader {
    public AbstractTextureImage loadTextureImage(BufferedInputStream in, boolean acceptAlpha, boolean flipVertically, boolean allowStreching, TextureFactory texFactory) throws IOException {
        PCXHeader header;
        int headerSize = 128;
        if (in.available() < 128) {
            return null;
        }
        byte[] first4Bytes = new byte[4];
        in.read(first4Bytes, 0, 4);
        byte[] headerData = new byte[128];
        System.arraycopy(first4Bytes, 0, headerData, 0, 4);
        if (!PCXHeader.checkFirstFourBytes(headerData)) {
            return null;
        }
        in.read(headerData, 4, 124);
        try {
            header = new PCXHeader(headerData);
        }
        catch (Throwable t) {
            return null;
        }
        byte[] data = StreamUtils.buildByteArray(in);
        PCXPalette pal = new PCXPalette(data);
        int width = header.getWidth();
        int height = header.getHeight();
        int bytesPerPixel = 3;
        int xp = 0;
        int yp = 0;
        AbstractTextureImage image = texFactory.createTextureImage(width, height, width, height, 3);
        ByteBuffer bb = image.getDataBuffer();
        bb.limit(bb.capacity());
        int byteOffset0 = bb.position();
        int dstBytesPerPixel = image.getFormat().getPixelSize();
        int trgLineSize = width * dstBytesPerPixel;
        int dstByteOffset = 0;
        byte[] pixel = new byte[3];
        int i = 0;
        block2: while (yp < height) {
            int count;
            int colorIndex;
            if ((colorIndex = data[i++] & 0xFF) >= 192) {
                count = colorIndex - 192;
                colorIndex = data[i++] & 0xFF;
            } else {
                count = 1;
            }
            int j = 0;
            while (j < count) {
                if (xp < width) {
                    pal.getColor(colorIndex, pixel);
                    int actualByteOffset = dstByteOffset;
                    if (flipVertically) {
                        actualByteOffset = (height - yp - 1) * trgLineSize + xp * dstBytesPerPixel;
                    }
                    bb.put(byteOffset0 + actualByteOffset + 0, pixel[0]);
                    bb.put(byteOffset0 + actualByteOffset + 1, pixel[1]);
                    bb.put(byteOffset0 + actualByteOffset + 2, pixel[2]);
                    dstByteOffset += 3;
                }
                if (++xp == header.bytesPerLine) {
                    xp = 0;
                    ++yp;
                    continue block2;
                }
                ++j;
            }
        }
        bb.position(0);
        bb.limit(byteOffset0 + width * height * dstBytesPerPixel);
        return image;
    }

    private static class PCXHeader {
        public byte manufacturer;
        public byte version;
        public byte encoding;
        public byte bitsPerPixel;
        public int xMin;
        public int yMin;
        public int xMax;
        public int yMax;
        public int hDPI;
        public int vDPI;
        public byte[] colorMap = new byte[48];
        public byte reserved;
        public byte colorPanes;
        public int bytesPerLine;
        public int colorInterpretation;
        public int horizScreenSize;
        public int vertScreenSize;

        public int getWidth() {
            return this.xMax - this.xMin + 1;
        }

        public int getHeight() {
            return this.yMax - this.yMin + 1;
        }

        public static boolean checkFirstFourBytes(byte[] data) {
            if (data[0] != 10) {
                return false;
            }
            switch (data[1]) {
                case 0: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
                default: {
                    return false;
                }
            }
            if (data[2] != 1) {
                return false;
            }
            switch (data[3]) {
                case 1: 
                case 2: 
                case 4: 
                case 8: {
                    break;
                }
                default: {
                    return false;
                }
            }
            return true;
        }

        private int readUnsignedShort(byte[] data, int i) throws IOException {
            byte low = data[i + 0];
            byte high = data[i + 1];
            return (high & 0xFF) << 8 | low & 0xFF;
        }

        public PCXHeader(byte[] data) throws IOException {
            int i = 0;
            this.manufacturer = data[i++];
            this.version = data[i++];
            this.encoding = data[i++];
            this.bitsPerPixel = data[i++];
            this.xMin = this.readUnsignedShort(data, i);
            this.yMin = this.readUnsignedShort(data, i += 2);
            this.xMax = this.readUnsignedShort(data, i += 2);
            this.yMax = this.readUnsignedShort(data, i += 2);
            this.hDPI = this.readUnsignedShort(data, i += 2);
            this.vDPI = this.readUnsignedShort(data, i += 2);
            System.arraycopy(data, i += 2, this.colorMap, 0, this.colorMap.length);
            i += this.colorMap.length;
            this.reserved = data[i++];
            this.colorPanes = data[i++];
            this.bytesPerLine = this.readUnsignedShort(data, i);
            this.colorInterpretation = this.readUnsignedShort(data, i += 2);
            this.horizScreenSize = this.readUnsignedShort(data, i += 2);
            this.vertScreenSize = this.readUnsignedShort(data, i += 2);
            i += 2;
        }
    }

    public static class PCXPalette {
        private byte[][] cols = new byte[256][3];

        public PCXPalette(byte[] data) throws IOException {
            int palSize = 768;
            int offset = data.length - 768;
            int i = 0;
            while (i < 256) {
                this.cols[i][0] = data[offset + i * 3 + 0];
                this.cols[i][1] = data[offset + i * 3 + 1];
                this.cols[i][2] = data[offset + i * 3 + 2];
                ++i;
            }
        }

        public final void getColor(int index, byte[] pixel) {
            if (index < 0) {
                index += 255;
            }
            pixel[0] = this.cols[index][0];
            pixel[1] = this.cols[index][1];
            pixel[2] = this.cols[index][2];
        }
    }
}

