/*
 * Decompiled with CFR 0.152.
 */
package org.jagatoo.logging;

import org.jagatoo.logging.LogChannel;
import org.jagatoo.logging.LogManager;

public final class Log {
    private static final LogManager logMgr = LogManager.getInstance();

    public static final LogManager getLogManager() {
        return logMgr;
    }

    public static final void setIndentationString(String indentationString) {
        logMgr.setIndentationString(indentationString);
    }

    public static final String getIndentationString() {
        return logMgr.getIndentationString();
    }

    public static final void setIndentation(int indentation) {
        logMgr.setIndentation(indentation);
    }

    public static final int getIndentation() {
        return logMgr.getIndentation();
    }

    public static final void increaseIndentation() {
        logMgr.setIndentation(logMgr.getIndentation() + 1);
    }

    public static final void decreaseIndentation() {
        logMgr.setIndentation(logMgr.getIndentation() - 1);
    }

    public static final void print(LogChannel channel, int logLevel, Object ... message) {
        if (logMgr.isAnyLogInterfaceRegistered(channel, logLevel)) {
            logMgr.print(channel, logLevel, message);
        }
    }

    public static final void println(LogChannel channel, int logLevel, Object ... message) {
        if (logMgr.isAnyLogInterfaceRegistered(channel, logLevel)) {
            logMgr.println(channel, logLevel, message);
        }
    }

    public static final void print(LogChannel channel, Throwable exception) {
        if (logMgr.isAnyLogInterfaceRegistered(channel, -1)) {
            logMgr.print(channel, exception);
        }
    }

    public static final void println(LogChannel channel, Object ... message) {
        if (logMgr.isAnyLogInterfaceRegistered(channel, 0)) {
            logMgr.println(channel, 0, message);
        }
    }

    public static final void printlnEx(LogChannel channel, Object ... message) {
        if (logMgr.isAnyLogInterfaceRegistered(channel, 1)) {
            logMgr.println(channel, 1, message);
        }
    }

    public static final void error(LogChannel channel, Object ... message) {
        if (logMgr.isAnyLogInterfaceRegistered(channel, -2)) {
            logMgr.println(channel, -2, message);
        }
    }

    public static final void exception(LogChannel channel, Object ... message) {
        if (logMgr.isAnyLogInterfaceRegistered(channel, -1)) {
            logMgr.println(channel, -1, message);
        }
    }

    public static final void debug(LogChannel channel, Object ... message) {
        if (logMgr.isAnyLogInterfaceRegistered(channel, 2)) {
            logMgr.println(channel, 2, message);
        }
    }

    public static final void profile(LogChannel channel, Object ... message) {
        if (logMgr.isAnyLogInterfaceRegistered(channel, 3)) {
            logMgr.println(channel, 3, message);
        }
    }

    public static final void flush() {
        logMgr.flush();
    }

    public static final void close() {
        logMgr.close();
    }

    private Log() {
    }
}

