/*
 * Decompiled with CFR 0.152.
 */
package org.jagatoo.logging;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashSet;
import org.jagatoo.logging.LogChannel;
import org.jagatoo.logging.LogFormatter;
import org.jagatoo.logging.LogInterface;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LogManager {
    private final ArrayList<LogInterface> logs;
    private int minRegisteredLogLevel = -2147483647;
    private int registeredChannels = 0;
    private long startTime;
    private boolean timestampsEnabled = false;
    private boolean channelsVisible = false;
    private boolean lastNewLine = true;
    private final HashSet<String> debugPackageFilter = new HashSet();
    private String indentationString = "    ";
    private int indentation = 0;
    private final StringBuilder strBuff = new StringBuilder();
    private static LogManager instance = null;

    public final void setIndentationString(String indentationString) {
        this.indentationString = indentationString;
    }

    public final String getIndentationString() {
        return this.indentationString;
    }

    public final void setIndentation(int indentation) {
        this.indentation = Math.max(0, indentation);
    }

    public final int getIndentation() {
        return this.indentation;
    }

    public final void setTimestampingEnabled(boolean enabled) {
        this.timestampsEnabled = enabled;
    }

    public final boolean isTimestampingEnabled() {
        return this.timestampsEnabled;
    }

    public final void setChannelsVisible(boolean visible) {
        this.channelsVisible = visible;
    }

    public final boolean areChannelsVisible() {
        return this.channelsVisible;
    }

    public final void addDebuggingPackage(String pkg) {
        this.debugPackageFilter.add(pkg);
    }

    public final void removeDebuggingPackage(String pkg) {
        this.debugPackageFilter.remove(pkg);
    }

    public final HashSet<String> getDebuggingPackageFiler() {
        return this.debugPackageFilter;
    }

    private String getTimeString() {
        long delta = System.currentTimeMillis() - this.startTime;
        return LogFormatter.formatTime(delta);
    }

    private static String getMemory() {
        Runtime runtime = Runtime.getRuntime();
        long mem = runtime.totalMemory();
        long free = runtime.freeMemory();
        return String.valueOf(LogFormatter.formatMemory(mem - free)) + "/" + LogFormatter.formatMemory(mem);
    }

    public final void refreshLogInterfaces() {
        this.minRegisteredLogLevel = -2147483647;
        this.registeredChannels = 0;
        int i = 0;
        while (i < this.logs.size()) {
            LogInterface log = this.logs.get(i);
            this.minRegisteredLogLevel = Math.max(this.minRegisteredLogLevel, log.getLogLevel());
            this.registeredChannels |= log.getChannelFilter();
            ++i;
        }
    }

    public final void registerLog(LogInterface log) {
        this.logs.add(log);
        this.refreshLogInterfaces();
    }

    public final void deregisterLog(LogInterface log) {
        this.logs.remove(log);
        this.refreshLogInterfaces();
    }

    public final boolean isAnyLogInterfaceRegistered(LogChannel channel, int logLevel) {
        if (this.logs.size() == 0) {
            return false;
        }
        if (this.minRegisteredLogLevel < logLevel) {
            return false;
        }
        return (this.registeredChannels & channel.getID()) != 0;
    }

    private static final String getCallerPackage() {
        StackTraceElement[] stes = Thread.currentThread().getStackTrace();
        String callerClass = null;
        int i = 3;
        while (i < stes.length) {
            if (!stes[i].getClassName().startsWith(LogManager.class.getPackage().getName())) {
                callerClass = stes[i].getClassName();
                break;
            }
            ++i;
        }
        if (callerClass == null || callerClass.length() == 0) {
            return "";
        }
        int lastDot = callerClass.lastIndexOf(46);
        String callerPackage = lastDot >= 0 ? callerClass.substring(0, lastDot) : "";
        return callerPackage;
    }

    private final String composeMessage(String prefix1, String prefix2, Object[] message) {
        this.strBuff.setLength(0);
        int i = 0;
        while (i < this.indentation) {
            this.strBuff.append(this.getIndentationString());
            ++i;
        }
        i = 0;
        while (i < message.length) {
            this.strBuff.append(String.valueOf(message[i]));
            ++i;
        }
        if (prefix1 != null && prefix2 != null) {
            return String.valueOf(prefix1) + prefix2 + this.strBuff.toString();
        }
        if (prefix1 != null) {
            return String.valueOf(prefix1) + this.strBuff.toString();
        }
        if (prefix2 != null) {
            return String.valueOf(prefix2) + this.strBuff.toString();
        }
        return this.strBuff.toString();
    }

    private final synchronized void internalPrint(LogChannel channel, int logLevel, Object[] message, boolean appendNL) {
        String callerPackage;
        if (message == null || message.length == 0) {
            return;
        }
        if (!this.isAnyLogInterfaceRegistered(channel, logLevel)) {
            return;
        }
        if (logLevel >= 2 && !this.debugPackageFilter.isEmpty() && !this.debugPackageFilter.contains(callerPackage = LogManager.getCallerPackage())) {
            return;
        }
        String prefix1 = this.lastNewLine && this.areChannelsVisible() ? String.valueOf(channel.getLogString()) + " " : null;
        String prefix2 = this.lastNewLine && this.isTimestampingEnabled() ? "[" + this.getTimeString() + ", " + LogManager.getMemory() + "] " : null;
        int i = 0;
        while (i < this.logs.size()) {
            LogInterface log = this.logs.get(i);
            if (appendNL) {
                log.println(channel, logLevel, this.composeMessage(prefix1, prefix2, message));
            } else {
                log.print(channel, logLevel, this.composeMessage(prefix1, prefix2, message));
            }
            ++i;
        }
        this.lastNewLine = true;
    }

    final synchronized void print(LogChannel channel, int logLevel, Object[] message) {
        this.internalPrint(channel, logLevel, message, false);
    }

    final synchronized void println(LogChannel channel, int logLevel, Object[] message) {
        this.internalPrint(channel, logLevel, message, true);
    }

    final void print(LogChannel channel, Throwable e) {
        PrintWriter p = e instanceof Error ? new PrintWriter((Writer)new LogWriter(channel, -2), true) : new PrintWriter((Writer)new LogWriter(channel, -1), true);
        this.lastNewLine = true;
        e.printStackTrace(p);
    }

    final void flush() {
        int i = 0;
        while (i < this.logs.size()) {
            this.logs.get(i).flush();
            ++i;
        }
    }

    final void close() {
        int i = 0;
        while (i < this.logs.size()) {
            this.logs.get(i).close();
            ++i;
        }
    }

    private LogManager() {
        this.logs = new ArrayList(2);
        this.startTime = System.currentTimeMillis();
    }

    public static final LogManager getInstance() {
        if (instance == null) {
            instance = new LogManager();
        }
        return instance;
    }

    private class LogWriter
    extends Writer {
        private final LogChannel channel;
        private final int type;
        private final StringBuilder sb = new StringBuilder();

        public LogWriter(LogChannel channel, int type) {
            this.channel = channel;
            this.type = type;
        }

        public void close() throws IOException {
        }

        public void flush() throws IOException {
        }

        public void write(char[] cbuf, int off, int len) throws IOException {
            int i = off;
            while (i < off + len) {
                char ch = cbuf[i];
                if (ch == '\r') {
                    LogManager.this.internalPrint(this.channel, this.type, new String[]{this.sb.toString()}, true);
                    this.sb.setLength(0);
                } else if (ch >= ' ') {
                    this.sb.append(ch);
                }
                ++i;
            }
        }
    }
}

