/*
 * Decompiled with CFR 0.152.
 */
package org.jagatoo.opengl.enums;

import org.jagatoo.opengl.enums.TextureMagFilter;
import org.jagatoo.opengl.enums.TextureMinFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum TextureFilter {
    POINT(9728, 9728, 9984, 1),
    BILINEAR(9729, 9729, 9985, 1),
    TRILINEAR(9729, 9729, 9987, 1),
    ANISOTROPIC_2(9729, 9729, 9987, 2),
    ANISOTROPIC_4(9729, 9729, 9987, 4),
    ANISOTROPIC_8(9729, 9729, 9987, 8),
    ANISOTROPIC_16(9729, 9729, 9987, 16);

    public static final TextureFilter FASTEST;
    public static final TextureFilter NICER;
    public static final TextureFilter NICEST;
    private final int glValueMagFilter;
    private final int glValueMinFilter_no_mipmapping;
    private final int glValueMinFilter_mipmapping;
    private final int anisotropicLevel;

    static {
        FASTEST = POINT;
        NICER = TRILINEAR;
        NICEST = ANISOTROPIC_16;
    }

    public final int getOpenGLMagFilter() {
        return this.glValueMagFilter;
    }

    public final int getOpenGLMinFilter(boolean mipmapping) {
        if (mipmapping) {
            return this.glValueMinFilter_mipmapping;
        }
        return this.glValueMinFilter_no_mipmapping;
    }

    public final int getAnisotropicLevel() {
        return this.anisotropicLevel;
    }

    public final TextureMagFilter deriveMagFilter() {
        switch (this) {
            case POINT: {
                return TextureMagFilter.POINT;
            }
            case BILINEAR: {
                return TextureMagFilter.BILINEAR;
            }
            case TRILINEAR: {
                return TextureMagFilter.BILINEAR;
            }
            case ANISOTROPIC_2: {
                return TextureMagFilter.BILINEAR;
            }
            case ANISOTROPIC_4: {
                return TextureMagFilter.BILINEAR;
            }
            case ANISOTROPIC_8: {
                return TextureMagFilter.BILINEAR;
            }
            case ANISOTROPIC_16: {
                return TextureMagFilter.BILINEAR;
            }
        }
        throw new Error("Should not happen!");
    }

    public final TextureMinFilter deriveMinFilter() {
        switch (this) {
            case POINT: {
                return TextureMinFilter.POINT;
            }
            case BILINEAR: {
                return TextureMinFilter.BILINEAR;
            }
            case TRILINEAR: {
                return TextureMinFilter.TRILINEAR;
            }
            case ANISOTROPIC_2: {
                return TextureMinFilter.ANISOTROPIC_2;
            }
            case ANISOTROPIC_4: {
                return TextureMinFilter.ANISOTROPIC_4;
            }
            case ANISOTROPIC_8: {
                return TextureMinFilter.ANISOTROPIC_8;
            }
            case ANISOTROPIC_16: {
                return TextureMinFilter.ANISOTROPIC_16;
            }
        }
        throw new Error("Should not happen!");
    }

    private TextureFilter(int glValueMagFilter, int glValueMinFilter_no_mipmapping, int glValueMinFilter_mipmapping, int anisotropicLevel) {
        this.glValueMagFilter = glValueMagFilter;
        this.glValueMinFilter_no_mipmapping = glValueMinFilter_no_mipmapping;
        this.glValueMinFilter_mipmapping = glValueMinFilter_mipmapping;
        this.anisotropicLevel = anisotropicLevel;
    }
}

