/*
 * Decompiled with CFR 0.152.
 */
package org.jagatoo.util.arrays;

import java.lang.reflect.Array;
import java.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ArrayUtils {
    public static final boolean equals(float[] a, float[] b) {
        if (a == b) {
            return true;
        }
        if (a == null) {
            return false;
        }
        if (b == null) {
            return false;
        }
        if (a.length != b.length) {
            return false;
        }
        int i = 0;
        while (i < a.length) {
            if (a[i] != b[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static final void dumpArray(float[] array, int maxElemsPerLine) {
        if (array == null) {
            System.out.println((String)null);
            return;
        }
        int line = 0;
        System.out.print("[ ");
        int i = 0;
        while (i < array.length) {
            if (i > 0 && i % maxElemsPerLine == 0) {
                System.out.println();
                System.out.print("  ");
                ++line;
            }
            System.out.print(array[i]);
            if (i < array.length - 1) {
                System.out.print(", ");
            }
            ++i;
        }
        if (line > 0) {
            System.out.println();
            System.out.println("]");
        } else {
            System.out.println(" ]");
        }
    }

    public static final void dumpArray(float[] array) {
        ArrayUtils.dumpArray(array, Integer.MAX_VALUE);
    }

    public static final void dumpArray(double[] array, int maxElemsPerLine) {
        if (array == null) {
            System.out.println((String)null);
            return;
        }
        int line = 0;
        System.out.print("[ ");
        int i = 0;
        while (i < array.length) {
            if (i > 0 && i % maxElemsPerLine == 0) {
                System.out.println();
                System.out.print("  ");
                ++line;
            }
            System.out.print(array[i]);
            if (i < array.length - 1) {
                System.out.print(", ");
            }
            ++i;
        }
        if (line > 0) {
            System.out.println();
            System.out.println("]");
        } else {
            System.out.println(" ]");
        }
    }

    public static final void dumpArray(double[] array) {
        ArrayUtils.dumpArray(array, Integer.MAX_VALUE);
    }

    public static final void dumpArray(int[] array, int maxElemsPerLine) {
        if (array == null) {
            System.out.println((String)null);
            return;
        }
        int line = 0;
        System.out.print("[ ");
        int i = 0;
        while (i < array.length) {
            if (i > 0 && i % maxElemsPerLine == 0) {
                System.out.println();
                System.out.print("  ");
                ++line;
            }
            System.out.print(array[i]);
            if (i < array.length - 1) {
                System.out.print(", ");
            }
            ++i;
        }
        if (line > 0) {
            System.out.println();
            System.out.println("]");
        } else {
            System.out.println(" ]");
        }
    }

    public static final void dumpArray(int[] array) {
        ArrayUtils.dumpArray(array, Integer.MAX_VALUE);
    }

    public static final void dumpArray(short[] array, int maxElemsPerLine) {
        if (array == null) {
            System.out.println((String)null);
            return;
        }
        int line = 0;
        System.out.print("[ ");
        int i = 0;
        while (i < array.length) {
            if (i > 0 && i % maxElemsPerLine == 0) {
                System.out.println();
                System.out.print("  ");
                ++line;
            }
            System.out.print(array[i]);
            if (i < array.length - 1) {
                System.out.print(", ");
            }
            ++i;
        }
        if (line > 0) {
            System.out.println();
            System.out.println("]");
        } else {
            System.out.println(" ]");
        }
    }

    public static final void dumpArray(short[] array) {
        ArrayUtils.dumpArray(array, Integer.MAX_VALUE);
    }

    public static final void dumpArray(byte[] array, boolean handleLikeUnsigned, int maxElemsPerLine) {
        if (array == null) {
            System.out.println((String)null);
            return;
        }
        int line = 0;
        System.out.print("[ ");
        int i = 0;
        while (i < array.length) {
            if (i > 0 && i % maxElemsPerLine == 0) {
                System.out.println();
                System.out.print("  ");
                ++line;
            }
            if (handleLikeUnsigned) {
                System.out.print(array[i] & 0xFF);
            } else {
                System.out.print(array[i]);
            }
            if (i < array.length - 1) {
                System.out.print(", ");
            }
            ++i;
        }
        if (line > 0) {
            System.out.println();
            System.out.println("]");
        } else {
            System.out.println(" ]");
        }
    }

    public static final void dumpArray(byte[] array, boolean handleLikeUnsigned) {
        ArrayUtils.dumpArray(array, handleLikeUnsigned, Integer.MAX_VALUE);
    }

    public static final int[] ensureCapacity(int[] array, int minCapacity) {
        int oldCapacity = array.length;
        if (minCapacity > oldCapacity) {
            int[] oldArray = array;
            int newCapacity = oldCapacity * 3 / 2 + 1;
            if (newCapacity < minCapacity) {
                newCapacity = minCapacity * 3 / 2 + 1;
            }
            array = new int[newCapacity];
            System.arraycopy(oldArray, 0, array, 0, oldCapacity);
        }
        return array;
    }

    public static final Integer[] ensureCapacity(Integer[] array, int minCapacity) {
        int oldCapacity = array.length;
        if (minCapacity > oldCapacity) {
            Integer[] oldArray = array;
            int newCapacity = oldCapacity * 3 / 2 + 1;
            if (newCapacity < minCapacity) {
                newCapacity = minCapacity * 3 / 2 + 1;
            }
            array = new Integer[newCapacity];
            System.arraycopy(oldArray, 0, array, 0, oldCapacity);
        }
        return array;
    }

    public static final int[] ensureCapacity(int[] array, int minCapacity, int paddValue) {
        int oldCapacity = array.length;
        if (minCapacity > oldCapacity) {
            int[] oldArray = array;
            int newCapacity = oldCapacity * 3 / 2 + 1;
            if (newCapacity < minCapacity) {
                newCapacity = minCapacity * 3 / 2 + 1;
            }
            array = new int[newCapacity];
            System.arraycopy(oldArray, 0, array, 0, oldCapacity);
            Arrays.fill(array, oldCapacity, newCapacity - 1, paddValue);
        }
        return array;
    }

    public static final long[] ensureCapacity(long[] array, int minCapacity) {
        int oldCapacity = array.length;
        if (minCapacity > oldCapacity) {
            long[] oldArray = array;
            int newCapacity = oldCapacity * 3 / 2 + 1;
            if (newCapacity < minCapacity) {
                newCapacity = minCapacity * 3 / 2 + 1;
            }
            array = new long[newCapacity];
            System.arraycopy(oldArray, 0, array, 0, oldCapacity);
        }
        return array;
    }

    public static final long[] ensureCapacity(long[] array, int minCapacity, int paddValue) {
        int oldCapacity = array.length;
        if (minCapacity > oldCapacity) {
            long[] oldArray = array;
            int newCapacity = oldCapacity * 3 / 2 + 1;
            if (newCapacity < minCapacity) {
                newCapacity = minCapacity * 3 / 2 + 1;
            }
            array = new long[newCapacity];
            System.arraycopy(oldArray, 0, array, 0, oldCapacity);
            Arrays.fill(array, oldCapacity, newCapacity - 1, (long)paddValue);
        }
        return array;
    }

    public static final float[] ensureCapacity(float[] array, int minCapacity) {
        int oldCapacity = array.length;
        if (minCapacity > oldCapacity) {
            float[] oldArray = array;
            int newCapacity = oldCapacity * 3 / 2 + 1;
            if (newCapacity < minCapacity) {
                newCapacity = minCapacity * 3 / 2 + 1;
            }
            array = new float[newCapacity];
            System.arraycopy(oldArray, 0, array, 0, oldCapacity);
        }
        return array;
    }

    public static final float[] ensureCapacity(float[] array, int minCapacity, int paddValue) {
        int oldCapacity = array.length;
        if (minCapacity > oldCapacity) {
            float[] oldArray = array;
            int newCapacity = oldCapacity * 3 / 2 + 1;
            if (newCapacity < minCapacity) {
                newCapacity = minCapacity * 3 / 2 + 1;
            }
            array = new float[newCapacity];
            System.arraycopy(oldArray, 0, array, 0, oldCapacity);
            Arrays.fill(array, oldCapacity, newCapacity - 1, (float)paddValue);
        }
        return array;
    }

    public static final <E> E[] ensureCapacity(E[] array, Class<?> elementType, int minCapacity) {
        int oldCapacity = array.length;
        if (minCapacity > oldCapacity) {
            E[] oldArray = array;
            int newCapacity = oldCapacity * 3 / 2 + 1;
            if (newCapacity < minCapacity) {
                newCapacity = minCapacity * 3 / 2 + 1;
            }
            array = (Object[])Array.newInstance(elementType, newCapacity);
            System.arraycopy(oldArray, 0, array, 0, oldCapacity);
        }
        return array;
    }

    public static final boolean contains(byte[] array, int start, int limit, byte element) {
        int i = start;
        while (i <= limit) {
            if (array[i] == element) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static final boolean contains(byte[] array, byte element) {
        int i = 0;
        while (i < array.length) {
            if (array[i] == element) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static final boolean contains(short[] array, int start, int limit, short element) {
        int i = start;
        while (i <= limit) {
            if (array[i] == element) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static final boolean contains(short[] array, short element) {
        int i = 0;
        while (i < array.length) {
            if (array[i] == element) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static final boolean contains(int[] array, int start, int limit, int element) {
        int i = start;
        while (i <= limit) {
            if (array[i] == element) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static final boolean contains(int[] array, int element) {
        int i = 0;
        while (i < array.length) {
            if (array[i] == element) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static final boolean contains(long[] array, int start, int limit, long element) {
        int i = start;
        while (i <= limit) {
            if (array[i] == element) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static final boolean contains(long[] array, long element) {
        int i = 0;
        while (i < array.length) {
            if (array[i] == element) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static final boolean contains(float[] array, int start, int limit, float element) {
        int i = start;
        while (i <= limit) {
            if (array[i] == element) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static final boolean contains(float[] array, float element) {
        int i = 0;
        while (i < array.length) {
            if (array[i] == element) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static final boolean contains(double[] array, int start, int limit, double element) {
        int i = start;
        while (i <= limit) {
            if (array[i] == element) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static final boolean contains(double[] array, double element) {
        int i = 0;
        while (i < array.length) {
            if (array[i] == element) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static final boolean contains(Object[] array, int start, int limit, Object element, boolean strict) {
        int i = start;
        while (i <= limit) {
            if (strict || array[i] == null ? array[i] == element : array[i].equals(element)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static final boolean contains(Object[] array, Object element, boolean strict) {
        int i = 0;
        while (i < array.length) {
            if (strict || array[i] == null ? array[i] == element : array[i].equals(element)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static final int indexOf(byte[] array, int start, int limit, byte element) {
        int i = start;
        while (i <= limit) {
            if (array[i] == element) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static final int indexOf(byte[] array, byte element) {
        return ArrayUtils.indexOf(array, 0, array.length - 1, element);
    }

    public static final int indexOf(short[] array, int start, int limit, short element) {
        int i = start;
        while (i <= limit) {
            if (array[i] == element) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static final int indexOf(short[] array, short element) {
        return ArrayUtils.indexOf(array, 0, array.length - 1, element);
    }

    public static final int indexOf(int[] array, int start, int limit, int element) {
        int i = start;
        while (i <= limit) {
            if (array[i] == element) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static final int indexOf(int[] array, int element) {
        return ArrayUtils.indexOf(array, 0, array.length - 1, element);
    }

    public static final int indexOf(long[] array, int start, int limit, long element) {
        int i = start;
        while (i <= limit) {
            if (array[i] == element) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static final int indexOf(long[] array, long element) {
        return ArrayUtils.indexOf(array, 0, array.length - 1, element);
    }

    public static final int indexOf(float[] array, int start, int limit, float element) {
        int i = start;
        while (i <= limit) {
            if (array[i] == element) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static final int indexOf(float[] array, float element) {
        return ArrayUtils.indexOf(array, 0, array.length - 1, element);
    }

    public static final int indexOf(double[] array, int start, int limit, double element) {
        int i = start;
        while (i <= limit) {
            if (array[i] == element) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static final int indexOf(double[] array, double element) {
        return ArrayUtils.indexOf(array, 0, array.length - 1, element);
    }

    public static final int indexOf(Object[] array, int start, int limit, Object element, boolean strict) {
        int i = start;
        while (i <= limit) {
            if (strict || array[i] == null ? array[i] == element : array[i].equals(element)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static final int indexOf(Object[] array, Object element, boolean strict) {
        return ArrayUtils.indexOf(array, 0, array.length - 1, element, strict);
    }

    private ArrayUtils() {
    }
}

