/*
 * Decompiled with CFR 0.152.
 */
package org.jagatoo.util.image;

import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGEncodeParam;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import org.jagatoo.image.DirectBufferedImage;
import org.jagatoo.image.SharedBufferedImage;
import org.jagatoo.logging.JAGTLog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImageUtility {
    private static Map<Integer, List<int[]>> intArrays = new HashMap<Integer, List<int[]>>();
    private static Map<String, BufferedImage> images = new HashMap<String, BufferedImage>();

    private static synchronized int[] getArray(int size) {
        Integer key = new Integer(size);
        List<int[]> list = intArrays.get(key);
        if (list == null || list.size() == 0) {
            return new int[size];
        }
        return list.remove(0);
    }

    private static synchronized void putArray(int[] a) {
        Integer key = new Integer(a.length);
        List<int[]> list = intArrays.get(key);
        if (list == null) {
            list = new ArrayList<int[]>();
            intArrays.put(key, list);
        }
        list.add(a);
    }

    public static BufferedImage downSampleRGB(BufferedImage source) {
        int sourceWidth = source.getWidth();
        int sourceHeight = source.getHeight();
        int destWidth = sourceWidth > 1 ? sourceWidth / 2 : 1;
        int destHeight = sourceHeight > 1 ? sourceHeight / 2 : 1;
        BufferedImage dest = new BufferedImage(destWidth, destHeight, 1);
        int[] spix = ImageUtility.getArray(sourceWidth * sourceHeight);
        int[] dpix = ImageUtility.getArray(destWidth * destHeight);
        source.getRGB(0, 0, sourceWidth, sourceHeight, spix, 0, sourceWidth);
        int j = 0;
        while (j < destHeight) {
            int i = 0;
            while (i < destWidth) {
                int s0 = ImageUtility.getIndex(i * 2, j * 2, sourceWidth, sourceHeight);
                int s1 = ImageUtility.getIndex(i * 2 + 1, j * 2, sourceWidth, sourceHeight);
                int s2 = ImageUtility.getIndex(i * 2, j * 2 + 1, sourceWidth, sourceHeight);
                int s3 = ImageUtility.getIndex(i * 2 + 1, j * 2 + 1, sourceWidth, sourceHeight);
                int red = (spix[s0] >> 16 & 0xFF) + (spix[s1] >> 16 & 0xFF) + (spix[s2] >> 16 & 0xFF) + (spix[s3] >> 16 & 0xFF);
                int green = (spix[s0] >> 8 & 0xFF) + (spix[s1] >> 8 & 0xFF) + (spix[s2] >> 8 & 0xFF) + (spix[s3] >> 8 & 0xFF);
                int blue = (spix[s0] & 0xFF) + (spix[s1] & 0xFF) + (spix[s2] & 0xFF) + (spix[s3] & 0xFF);
                dpix[i + destWidth * j] = (red /= 4) << 16 | (green /= 4) << 8 | (blue /= 4);
                ++i;
            }
            ++j;
        }
        dest.setRGB(0, 0, destWidth, destHeight, dpix, 0, destWidth);
        ImageUtility.putArray(dpix);
        ImageUtility.putArray(spix);
        return dest;
    }

    public static BufferedImage downSampleRGBA(BufferedImage source) {
        int sourceWidth = source.getWidth();
        int sourceHeight = source.getHeight();
        int destWidth = sourceWidth > 1 ? sourceWidth / 2 : 1;
        int destHeight = sourceHeight > 1 ? sourceHeight / 2 : 1;
        BufferedImage dest = new BufferedImage(destWidth, destHeight, 2);
        int[] spix = ImageUtility.getArray(sourceWidth * sourceHeight);
        int[] dpix = ImageUtility.getArray(destWidth * destHeight);
        source.getRGB(0, 0, sourceWidth, sourceHeight, spix, 0, sourceWidth);
        int j = 0;
        while (j < destHeight) {
            int i = 0;
            while (i < destWidth) {
                int s0 = ImageUtility.getIndex(i * 2, j * 2, sourceWidth, sourceHeight);
                int s1 = ImageUtility.getIndex(i * 2 + 1, j * 2, sourceWidth, sourceHeight);
                int s2 = ImageUtility.getIndex(i * 2, j * 2 + 1, sourceWidth, sourceHeight);
                int s3 = ImageUtility.getIndex(i * 2 + 1, j * 2 + 1, sourceWidth, sourceHeight);
                int alpha = (spix[s0] >> 24 & 0xFF) + (spix[s1] >> 24 & 0xFF) + (spix[s2] >> 24 & 0xFF) + (spix[s3] >> 24 & 0xFF);
                int red = (spix[s0] >> 16 & 0xFF) + (spix[s1] >> 16 & 0xFF) + (spix[s2] >> 16 & 0xFF) + (spix[s3] >> 16 & 0xFF);
                int green = (spix[s0] >> 8 & 0xFF) + (spix[s1] >> 8 & 0xFF) + (spix[s2] >> 8 & 0xFF) + (spix[s3] >> 8 & 0xFF);
                int blue = (spix[s0] & 0xFF) + (spix[s1] & 0xFF) + (spix[s2] & 0xFF) + (spix[s3] & 0xFF);
                dpix[i + destWidth * j] = (alpha /= 4) << 24 | (red /= 4) << 16 | (green /= 4) << 8 | (blue /= 4);
                ++i;
            }
            ++j;
        }
        dest.setRGB(0, 0, destWidth, destHeight, dpix, 0, destWidth);
        ImageUtility.putArray(dpix);
        ImageUtility.putArray(spix);
        return dest;
    }

    public static Rectangle alphaBounds(BufferedImage image) {
        Rectangle r = new Rectangle();
        int width = image.getWidth();
        int height = image.getHeight();
        int lx = 0;
        int ly = 0;
        int ux = width - 1;
        int uy = height - 1;
        boolean left = false;
        boolean top = false;
        boolean bottom = false;
        boolean right = false;
        int[] pixels = new int[width * height];
        image.getRGB(0, 0, width, height, pixels, 0, width);
        int x = 0;
        while (x < width) {
            int y = 0;
            while (y < height) {
                int alphaleft = pixels[y * width + x] >> 24;
                int alpharight = pixels[y * width + (width - x - 1)] >> 24;
                if (!left && alphaleft != 0) {
                    lx = x;
                    left = true;
                }
                if (!right && alpharight != 0) {
                    ux = width - x - 1;
                    right = true;
                }
                ++y;
            }
            ++x;
        }
        int y = 0;
        while (y < height) {
            int x2 = 0;
            while (x2 < width) {
                int alphatop = pixels[y * width + x2] >> 24;
                int alphabottom = pixels[(height - y - 1) * width + x2] >> 24;
                if (!top && alphatop != 0) {
                    ly = y;
                    top = true;
                }
                if (!bottom && alphabottom != 0) {
                    uy = height - y - 1;
                    bottom = true;
                }
                ++x2;
            }
            ++y;
        }
        JAGTLog.debug("Image alpha bounds : ", lx, ",", ly, " -> ", ux, ",", uy);
        r.setBounds(lx, ly, ux - lx + 1, uy - ly + 1);
        return r;
    }

    private static int getIndex(int x, int y, int maxX, int maxY) {
        if (x < 0) {
            x = 0;
        }
        if (x >= maxX) {
            x = maxX - 1;
        }
        if (y < 0) {
            y = 0;
        }
        if (y >= maxY) {
            y = maxY - 1;
        }
        return y * maxX + x;
    }

    public static BufferedImage centerAndScale(BufferedImage image, int width, int height, int margin) {
        int w;
        int h;
        double scale;
        Rectangle r = ImageUtility.alphaBounds(image);
        JAGTLog.debug("   Alpha bounds : ", (int)r.getWidth(), "+", (int)r.getHeight());
        JAGTLog.debug("      min : ", (int)r.getMinX(), ",", (int)r.getMinY());
        JAGTLog.debug("      max : ", (int)r.getMaxX(), ",", (int)r.getMaxY());
        if (r.getWidth() < r.getHeight()) {
            scale = r.getWidth() / r.getHeight();
            h = height - margin * 2;
            w = (int)((double)h * scale);
        } else {
            scale = r.getHeight() / r.getWidth();
            w = width - margin * 2;
            h = (int)((double)w * scale);
        }
        JAGTLog.debug("   New width ", w);
        JAGTLog.debug("   New height ", h);
        int lx = width / 2 - w / 2;
        int ly = height / 2 - h / 2;
        BufferedImage bi = new BufferedImage(width, height, 2);
        Graphics2D g = (Graphics2D)bi.getGraphics();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        g.drawImage(image, lx, ly, lx + w - 1, ly + h - 1, (int)r.getMinX(), (int)r.getMinY(), (int)r.getMaxX(), (int)r.getMaxY(), null);
        return bi;
    }

    public static void writeImage(BufferedImage image, String filename) {
        try {
            FileOutputStream out = new FileOutputStream(filename);
            JPEGImageEncoder encoder = JPEGCodec.createJPEGEncoder((OutputStream)out);
            JPEGEncodeParam param = encoder.getDefaultJPEGEncodeParam(image);
            param.setQuality(0.9f, false);
            encoder.setJPEGEncodeParam(param);
            encoder.encode(image);
            out.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void writeImage(BufferedImage image, String filename, float compression) {
        try {
            FileOutputStream out = new FileOutputStream(filename);
            JPEGImageEncoder encoder = JPEGCodec.createJPEGEncoder((OutputStream)out);
            JPEGEncodeParam param = encoder.getDefaultJPEGEncodeParam(image);
            param.setQuality(compression, false);
            encoder.setJPEGEncodeParam(param);
            encoder.encode(image);
            out.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void writeAlphaImage(BufferedImage image, String filename) {
        try {
            File f = new File(filename);
            ImageIO.write((RenderedImage)image, "png", f);
        }
        catch (Exception e) {
            JAGTLog.print(e);
        }
    }

    public static BufferedImage readImage(String filename) throws IOException {
        File f = new File(filename);
        return ImageIO.read(f);
    }

    public static BufferedImage readImage(String name, Object c) throws IOException {
        BufferedImage image = images.get(name);
        if (image != null) {
            return image;
        }
        ClassLoader classloader = c.getClass().getClassLoader();
        URL url = classloader.getResource(name);
        if (url == null) {
            throw new IOException("Cannot find file " + name + " on classpath");
        }
        BufferedImage i = ImageIO.read(url);
        images.put(name, i);
        return i;
    }

    public static DirectBufferedImage flipImageVertical(BufferedImage bi) {
        AffineTransform tx = AffineTransform.getScaleInstance(1.0, -1.0);
        tx.translate(0.0, -bi.getHeight(null));
        AffineTransformOp op = new AffineTransformOp(tx, 1);
        DirectBufferedImage bi2 = bi.getColorModel().hasAlpha() ? DirectBufferedImage.makeDirectImageRGBA(bi.getWidth(), bi.getHeight()) : DirectBufferedImage.makeDirectImageRGB(bi.getWidth(), bi.getHeight());
        op.filter(bi, bi2);
        return bi2;
    }

    public static byte[] toByteArray(BufferedImage img) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)img, "pnm", baos);
        return baos.toByteArray();
    }

    public static ByteBuffer[] toByteBuffer(BufferedImage img) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)img, "pnm", baos);
        ByteBuffer bb = ByteBuffer.allocateDirect(1);
        bb.put(baos.toByteArray());
        bb.rewind();
        return new ByteBuffer[]{bb};
    }

    public static <BufferedImage_ extends BufferedImage> BufferedImage_ scaleImage(Image srcImage, BufferedImage_ trgImage) {
        Graphics2D g2 = trgImage.createGraphics();
        g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        try {
            g2.drawImage(srcImage, 0, 0, trgImage.getWidth(), trgImage.getHeight(), null);
        }
        finally {
            g2.dispose();
        }
        return trgImage;
    }

    public static SharedBufferedImage scaleImage(Image image, int width, int height, boolean alpha) {
        SharedBufferedImage newImg = SharedBufferedImage.create(width, height, alpha ? 4 : 3, alpha, null, null);
        return ImageUtility.scaleImage(image, newImg);
    }

    public static final int roundUpPower2(int v) {
        switch (Integer.bitCount(v)) {
            case 0: {
                return 1;
            }
            case 1: {
                return v;
            }
        }
        return Integer.highestOneBit(v) << 1;
    }
}

