/*
 * Decompiled with CFR 0.152.
 */
package org.jagatoo.commandline;

import org.jagatoo.commandline.CommandlineParsingException;

public class Argument {
    private final char shortName;
    private final String longName;
    private final String description;
    private final boolean needsValue;

    public final char getShortName() {
        return this.shortName;
    }

    public final String getLongName() {
        return this.longName;
    }

    public final String getDecription() {
        return this.description;
    }

    public final boolean needsValue() {
        return this.needsValue;
    }

    protected Object parseValueImpl(String rawValue) throws CommandlineParsingException {
        return rawValue;
    }

    public final Object parseValue(String rawValue) throws CommandlineParsingException {
        try {
            return this.parseValueImpl(rawValue);
        }
        catch (CommandlineParsingException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new CommandlineParsingException("Invalid value for " + this + ": " + rawValue, t);
        }
    }

    public boolean equals(Object o) {
        if (!(o instanceof Argument)) {
            return false;
        }
        Argument a = (Argument)o;
        if (a.shortName == '\u0000') {
            if (this.shortName != '\u0000') {
                return false;
            }
            return a.longName.equals(this.longName);
        }
        if (this.shortName == '\u0000') {
            return false;
        }
        return a.shortName == this.shortName;
    }

    public int hashCode() {
        if (this.shortName != '\u0000') {
            return this.shortName;
        }
        return this.longName.hashCode();
    }

    public String toString() {
        if (this.shortName == '\u0000') {
            return this.longName;
        }
        if (this.longName == null) {
            return String.valueOf(this.shortName);
        }
        return String.valueOf(this.longName) + " (" + this.shortName + ")";
    }

    public Argument(char shortName, String longName, String description, boolean needsValue) {
        if ("".equals(longName)) {
            longName = null;
        }
        if ("".equals(description)) {
            description = null;
        }
        if (shortName == '\u0000' && longName == null) {
            throw new IllegalArgumentException("shortName and longName cannot be both null.");
        }
        this.shortName = shortName;
        this.longName = longName;
        this.description = description;
        this.needsValue = needsValue;
    }
}

