/*
 * Decompiled with CFR 0.152.
 */
package org.jagatoo.commandline;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import org.jagatoo.commandline.Argument;
import org.jagatoo.util.strings.SimpleStringTokenizer;

public class ArgumentsRegistry {
    private static final Comparator<Argument> ARGUMENT_COMPARATOR = new Comparator<Argument>(){

        @Override
        public int compare(Argument a1, Argument a2) {
            int result = 0;
            if (a1.getLongName() == null) {
                if (a2.getLongName() != null) {
                    return -1;
                }
            } else if (a2.getLongName() == null) {
                return 1;
            }
            if ((result = a1.getLongName().compareTo(a2.getLongName())) != 0) {
                return result;
            }
            if (a1.getShortName() < a2.getShortName()) {
                return -1;
            }
            if (a1.getShortName() > a2.getShortName()) {
                return 1;
            }
            return 0;
        }
    };
    private final String headLine;
    private final String name;
    private final HashMap<Character, Argument> arguments_by_short_name = new HashMap();
    private final HashMap<String, Argument> arguments_by_long_name = new HashMap();
    private final ArrayList<Argument> arguments = new ArrayList();

    public final String getName() {
        return this.name;
    }

    public void addArgument(Argument arg) {
        if (arg.getShortName() != '\u0000' && this.arguments_by_short_name.containsKey(Character.valueOf(arg.getShortName()))) {
            throw new Error("duplicate Argument " + arg);
        }
        if (arg.getLongName() != null && this.arguments_by_long_name.containsKey(arg.getLongName())) {
            throw new Error("duplicate Argument " + arg);
        }
        if (arg.getShortName() != '\u0000') {
            this.arguments_by_short_name.put(Character.valueOf(arg.getShortName()), arg);
        }
        if (arg.getLongName() != null) {
            this.arguments_by_long_name.put(arg.getLongName(), arg);
        }
        this.arguments.add(arg);
    }

    public void removeArgument(Argument arg) {
        if (arg.getShortName() != '\u0000') {
            this.arguments_by_short_name.remove(Character.valueOf(arg.getShortName()));
        }
        if (arg.getLongName() != null) {
            this.arguments_by_long_name.remove(arg.getLongName());
        }
        this.arguments.remove(arg);
    }

    public final boolean contains(char shortName) {
        return this.arguments_by_short_name.containsKey(Character.valueOf(shortName));
    }

    public final boolean contains(String longName) {
        return this.arguments_by_long_name.containsKey(longName);
    }

    public final Argument getArgument(char shortName) {
        return this.arguments_by_short_name.get(Character.valueOf(shortName));
    }

    public final Argument getArgument(String longName) {
        return this.arguments_by_long_name.get(longName);
    }

    public void dump(int maxLineWidth, PrintStream out) {
        if (this.headLine == null) {
            out.println("Argument list for " + this.getName());
        } else {
            out.println(this.headLine);
        }
        Collections.sort(this.arguments, ARGUMENT_COMPARATOR);
        int indent = 0;
        for (Argument arg : this.arguments) {
            int length = 0;
            if (arg.getShortName() != '\u0000') {
                length += 2;
                if (arg.getLongName() != null) {
                    length += 4 + arg.getLongName().length();
                }
            } else if (arg.getLongName() != null) {
                length += 2 + arg.getLongName().length();
            }
            if ((length += 2) <= indent) continue;
            indent = length;
        }
        int descWidth = maxLineWidth - indent;
        for (Argument arg : this.arguments) {
            out.println();
            int length = 0;
            if (arg.getShortName() != '\u0000') {
                length += 2;
                out.print('-');
                out.print(arg.getShortName());
                if (arg.getLongName() != null) {
                    length += 4 + arg.getLongName().length();
                    out.print(", --");
                    out.print(arg.getLongName());
                }
            } else if (arg.getLongName() != null) {
                length += 2 + arg.getLongName().length();
                out.print("--");
                out.print(arg.getLongName());
            }
            int i = indent - (length += 2) + 1;
            while (i >= 0) {
                out.print(' ');
                --i;
            }
            String desc = arg.getDecription();
            if (desc != null) {
                String[] descParts = desc.split("\n");
                int j = 0;
                String[] stringArray = descParts;
                int n = descParts.length;
                int n2 = 0;
                while (n2 < n) {
                    String part = stringArray[n2];
                    if (j++ > 0) {
                        int i2 = 0;
                        while (i2 < indent) {
                            out.print(' ');
                            ++i2;
                        }
                    }
                    if (part.length() > 0) {
                        int offset = 0;
                        int nextOffset = 0;
                        while (offset < part.length()) {
                            int end = Math.min(offset + descWidth, part.length());
                            if (end < part.length() && !SimpleStringTokenizer.isWhitespace(part.charAt(end))) {
                                while (!SimpleStringTokenizer.isWhitespace(part.charAt(end))) {
                                    --end;
                                }
                            }
                            nextOffset = end;
                            if (offset > 0) {
                                int i3 = 0;
                                while (i3 < indent) {
                                    out.print(' ');
                                    ++i3;
                                }
                            }
                            while (SimpleStringTokenizer.isWhitespace(part.charAt(offset))) {
                                ++offset;
                            }
                            while (SimpleStringTokenizer.isWhitespace(part.charAt(end - 1))) {
                                --end;
                            }
                            out.println(part.substring(offset, end));
                            offset = nextOffset;
                        }
                    } else {
                        out.println();
                    }
                    ++n2;
                }
                continue;
            }
            out.println("(No description available)");
        }
    }

    public final void dump(int maxLineWidth) {
        this.dump(maxLineWidth, System.out);
    }

    public final void dump(PrintStream out) {
        this.dump(80, out);
    }

    public final void dump() {
        this.dump(80, System.out);
    }

    public ArgumentsRegistry(String name, String headLine) {
        this.name = name;
        this.headLine = headLine;
    }

    public ArgumentsRegistry(String name) {
        this(name, null);
    }
}

