/*
 * Decompiled with CFR 0.152.
 */
package org.jagatoo.geometry;

import java.util.List;
import org.jagatoo.geometry.GeomNioFloatData;
import org.jagatoo.geometry.GeomNioIntData;
import org.jagatoo.opengl.enums.GeometryArrayType;
import org.openmali.spatial.VertexContainer;
import org.openmali.spatial.polygons.Triangle;
import org.openmali.vecmath2.Tuple3f;
import org.openmali.vecmath2.TupleNf;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleGeometryDataContainer
implements VertexContainer {
    public static final int COORDINATES = 1;
    public static final int BY_REFERENCE = 512;
    public static final int INTERLEAVED = 1024;
    protected GeomNioFloatData coords = null;
    protected GeomNioIntData indexData = null;
    protected GeomNioFloatData interleavedData = null;
    private int[] stripCounts = null;
    private final int coordsSize;
    protected boolean isInterleaved = false;
    private final GeometryArrayType type;
    private final boolean isStrip;
    private final boolean hasIndex;
    private final int faceSize;
    protected final int maxVertices;
    protected int numVertices;
    protected int numIndices;
    private int initialVertexIndex = 0;
    protected long coordsOffset = 0L;
    protected static final boolean reversed = false;

    public final GeometryArrayType getType() {
        return this.type;
    }

    public final boolean isStrip() {
        return this.isStrip;
    }

    public final int getFaceSize() {
        return this.faceSize;
    }

    public final int getVertexCount() {
        return this.maxVertices;
    }

    public final boolean isInterleaved() {
        return this.isInterleaved;
    }

    public final boolean hasIndex() {
        return this.hasIndex;
    }

    public void setCoordinateData(GeomNioFloatData data) {
        if (this.isInterleaved()) {
            throw new Error("This method cannot be used for interleaved data.");
        }
        if (data == null) {
            throw new Error("coordinate data must not be null");
        }
        this.coords = data;
    }

    public final GeomNioFloatData getCoordinatesData() {
        return this.coords;
    }

    public final int getCoordinatesSize() {
        return this.coordsSize;
    }

    public final long getCoordinatesOffset() {
        return this.coordsOffset;
    }

    public final GeomNioFloatData getInterleavedData() {
        if (!this.isInterleaved()) {
            throw new Error("This data is not interleaved.");
        }
        return this.interleavedData;
    }

    public void setInitialIndex(int initialIndex) {
        this.initialVertexIndex = initialIndex;
    }

    public final int getInitialIndex() {
        return this.initialVertexIndex;
    }

    public void setValidVertexCount(int count) {
        if (count == this.numVertices) {
            return;
        }
        this.numVertices = count;
    }

    public final int getValidVertexCount() {
        return this.numVertices;
    }

    public final int getMaxVertexCount() {
        return this.maxVertices;
    }

    protected GeomNioFloatData newNioFloatData(int maxElements, int elemSize, int stride, boolean reversed) {
        return new GeomNioFloatData(maxElements, elemSize, reversed);
    }

    protected void createCoordinates() {
        this.coords = this.newNioFloatData(this.maxVertices, this.coordsSize, 0, false);
    }

    protected final void checkCoordsExistence(int coordsSize) {
        if (coordsSize != this.coordsSize) {
            throw new IllegalArgumentException("given coordinate has wrong size. Found " + coordsSize + ", expected " + this.coordsSize + ".");
        }
        if (!this.isInterleaved && this.coords == null) {
            this.createCoordinates();
        }
    }

    public void setCoordinate(int vertexIndex, float[] floatArray) {
        this.checkCoordsExistence(3);
        assert (floatArray.length >= 3);
        this.coords.set(vertexIndex, this.coordsSize, this.coordsOffset / 4L, floatArray, 0, this.coordsSize);
    }

    public void setCoordinate(int vertexIndex, Tuple3f point3f) {
        this.checkCoordsExistence(3);
        this.coords.set(vertexIndex, this.coordsOffset / 4L, (TupleNf<?>)point3f);
    }

    public void setCoordinates(int vertexIndex, float[] floatArray, int startIndex, int length) {
        this.checkCoordsExistence(3);
        this.coords.set(vertexIndex, this.coordsSize, this.coordsOffset / 4L, floatArray, startIndex * this.coordsSize, length * this.coordsSize);
    }

    public void setCoordinates(int vertexIndex, Tuple3f[] point3fArray, int startIndex, int length) {
        this.checkCoordsExistence(3);
        int i = startIndex;
        while (i < startIndex + length) {
            this.coords.set(vertexIndex++, this.coordsOffset / 4L, (TupleNf<?>)point3fArray[i]);
            ++i;
        }
    }

    public void setCoordinates(int vertexIndex, float[] floatArray) {
        this.checkCoordsExistence(3);
        if (floatArray.length % this.coordsSize != 0) {
            throw new IllegalArgumentException("the size of the coordinate array must be a multiple of 3");
        }
        this.coords.set(vertexIndex, this.coordsSize, this.coordsOffset / 4L, floatArray);
    }

    public void setCoordinates(int vertexIndex, Tuple3f[] point3fArray) {
        this.checkCoordsExistence(3);
        int i = 0;
        while (i < point3fArray.length) {
            this.coords.set(vertexIndex + i, this.coordsOffset / 4L, (TupleNf<?>)point3fArray[i]);
            ++i;
        }
    }

    public void setCoordinates(int vertexIndex, List<Tuple3f> point3fList) {
        this.checkCoordsExistence(3);
        int i = 0;
        while (i < point3fList.size()) {
            this.coords.set(vertexIndex + i, this.coordsOffset / 4L, (TupleNf)point3fList.get(i));
            ++i;
        }
    }

    public void setCoordinate(int vertexIndex, float x, float y, float z) {
        this.checkCoordsExistence(3);
        this.coords.set(vertexIndex, this.coordsOffset / 4L, x, y, z);
    }

    public void getCoordinate(int vertexIndex, float[] floatArray) {
        this.checkCoordsExistence(this.coordsSize);
        this.coords.get(vertexIndex, this.coordsSize, this.coordsOffset / 4L, floatArray, 0, this.coordsSize);
    }

    public <T extends Tuple3f> T getCoordinate(int index, T point) {
        this.checkCoordsExistence(3);
        this.coords.get(index, this.coordsOffset / 4L, (TupleNf<?>)point);
        return point;
    }

    public boolean getVertex(int i, Tuple3f pos) {
        if (i >= this.getVertexCount()) {
            return false;
        }
        this.getCoordinate(i, pos);
        return true;
    }

    public void getCoordinates(int vertexIndex, float[] floatArray) {
        this.checkCoordsExistence(this.coordsSize);
        int numReqVerts = floatArray.length / this.coordsSize;
        int i = 0;
        while (i < numReqVerts) {
            this.coords.get(vertexIndex + i, this.coordsSize, this.coordsOffset / 4L, floatArray, i * this.coordsSize, this.coordsSize);
            ++i;
        }
    }

    public void getCoordinates(int vertexIndex, Tuple3f[] point3fArray) {
        this.checkCoordsExistence(3);
        int i = point3fArray.length - 1;
        while (i > -1) {
            this.coords.get(i - vertexIndex, this.coordsOffset / 4L, (TupleNf<?>)point3fArray[i]);
            --i;
        }
    }

    public boolean setTriangle(int i0, int i1, int i2, Triangle triangle) {
        if (triangle.hasFeature(1)) {
            this.setCoordinate(i0, (Tuple3f)triangle.getVertexCoordA());
            this.setCoordinate(i1, (Tuple3f)triangle.getVertexCoordB());
            this.setCoordinate(i2, (Tuple3f)triangle.getVertexCoordC());
        }
        return true;
    }

    public final boolean setTriangle(Triangle triangle) {
        return this.setTriangle(triangle.getVertexIndexA(), triangle.getVertexIndexB(), triangle.getVertexIndexC(), triangle);
    }

    public boolean getTriangle(int i0, int i1, int i2, Triangle triangle) {
        this.getVertex(i0, (Tuple3f)triangle.getVertexCoordA());
        this.getVertex(i1, (Tuple3f)triangle.getVertexCoordB());
        this.getVertex(i2, (Tuple3f)triangle.getVertexCoordC());
        triangle.setVertexIndices(i0, i1, i2);
        return true;
    }

    public final int getIndexCount() {
        return this.indexData.getMaxElements();
    }

    public void setIndex(int[] indices) {
        this.indexData.set(0, indices);
    }

    public void setIndex(int i, int idx) {
        this.indexData.set(i, idx);
    }

    public final void getIndex(int[] index) {
        this.indexData.get(0, index);
    }

    public final int getIndex(int i) {
        return this.indexData.get(i);
    }

    public final GeomNioIntData getIndexData() {
        return this.indexData;
    }

    public final int getNumStrips() {
        return this.stripCounts.length;
    }

    public void setStripCounts(int[] stripCounts) {
        this.stripCounts = stripCounts;
    }

    public final int[] getStripCounts() {
        return this.stripCounts;
    }

    public void getStripCounts(int[] sCounts) {
        System.arraycopy(this.stripCounts, 0, sCounts, 0, this.stripCounts.length);
    }

    public float[] getCoordRefFloat() {
        return this.coords == null ? null : this.coords.getData();
    }

    protected void setNioBuffers() {
        this.coords = this.newNioFloatData(this.maxVertices, 3, 0, false);
    }

    protected void copyFrom(SimpleGeometryDataContainer o, boolean forceDuplicate) {
        this.numVertices = o.numVertices;
        this.coordsOffset = o.coordsOffset;
        this.numIndices = o.numIndices;
        this.initialVertexIndex = o.initialVertexIndex;
        if (this.hasIndex()) {
            this.indexData = o.indexData.duplicateGeomData(true);
        }
        this.isInterleaved = o.isInterleaved;
        if (o.isInterleaved) {
            this.interleavedData = o.interleavedData.duplicateGeomData(true);
        } else if (o.coords != null) {
            this.coords = o.coords.duplicateGeomData(true);
        }
        this.stripCounts = (int[])(o.stripCounts != null ? (int[])o.stripCounts.clone() : null);
    }

    protected GeomNioIntData newNioIntData(int maxElems, int elemSize, boolean reversed) {
        return new GeomNioIntData(maxElems, elemSize, reversed);
    }

    protected SimpleGeometryDataContainer(GeometryArrayType type, boolean hasIndex, int coordsSize, int vertexCount, int[] stripCounts, int indexCount) {
        this.type = type;
        this.faceSize = type.getFaceSize();
        this.coordsSize = coordsSize;
        this.maxVertices = vertexCount;
        this.isStrip = type.isStrip();
        this.hasIndex = hasIndex;
        if (hasIndex) {
            this.indexData = this.newNioIntData(indexCount, 1, false);
            this.numVertices = indexCount;
        } else {
            this.numVertices = vertexCount;
        }
        this.stripCounts = (int[])(this.isStrip ? (stripCounts == null ? new int[]{vertexCount} : stripCounts) : null);
        this.setNioBuffers();
    }

    public SimpleGeometryDataContainer(GeometryArrayType type, int coordsSize, int vertexCount) {
        this(type, false, coordsSize, vertexCount, null, 0);
    }

    public SimpleGeometryDataContainer(GeometryArrayType type, int coordsSize, int vertexCount, int indexCount) {
        this(type, true, coordsSize, vertexCount, null, indexCount);
    }

    public SimpleGeometryDataContainer(GeometryArrayType type, int coordsSize, int vertexCount, int[] stripCounts) {
        this(type, false, coordsSize, vertexCount, stripCounts, 0);
    }

    public SimpleGeometryDataContainer(GeometryArrayType type, int coordsSize, int vertexCount, int[] stripCounts, int indexCount) {
        this(type, true, coordsSize, vertexCount, stripCounts, indexCount);
    }
}

