/*
 * Decompiled with CFR 0.152.
 */
package org.jagatoo.input.devices;

import java.util.ArrayList;
import org.jagatoo.datatypes.Enableable;
import org.jagatoo.input.InputSystem;
import org.jagatoo.input.InputSystemException;
import org.jagatoo.input.InputSystemRuntimeException;
import org.jagatoo.input.devices.components.DeviceComponent;
import org.jagatoo.input.events.EventQueue;
import org.jagatoo.input.events.InputEvent;
import org.jagatoo.input.listeners.InputStateListener;
import org.jagatoo.input.render.InputSourceWindow;

public abstract class InputDevice
implements Enableable {
    private final InputSourceWindow sourceWindow;
    private final EventQueue eventQueue;
    private final String name;
    private boolean enabled = true;
    private final ArrayList<InputStateListener> stateListeners = new ArrayList();

    public final InputSourceWindow getSourceWindow() {
        return this.sourceWindow;
    }

    protected final EventQueue getEventQueue() {
        return this.eventQueue;
    }

    public final String getName() {
        return this.name;
    }

    public void onDeviceRegistered(InputSystem inputSystem) throws InputSystemException {
    }

    public void onDeviceUnregistered(InputSystem inputSystem) throws InputSystemException {
    }

    public abstract int getState(DeviceComponent var1) throws InputSystemRuntimeException;

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o.getClass() != this.getClass() || !((InputDevice)o).getName().equals(this.getName())) {
            return false;
        }
        InputDevice idO = (InputDevice)o;
        return idO.getSourceWindow() == this.getSourceWindow();
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public final boolean isEnabled() {
        return this.enabled;
    }

    public final boolean hasInputStateListener() {
        return this.stateListeners.size() > 0;
    }

    public void addInputStateListener(InputStateListener l) {
        if (this.stateListeners.contains(l)) {
            return;
        }
        this.stateListeners.add(l);
    }

    public void removeInputStateListener(InputStateListener l) {
        this.stateListeners.remove(l);
    }

    public void fireStateEventsAndDoActions(InputEvent e, int delta, int state) {
        if (!this.isEnabled()) {
            return;
        }
        int n = this.stateListeners.size();
        int i = 0;
        while (i < this.stateListeners.size()) {
            this.stateListeners.get(i).onInputStateChanged(e, e.getComponent(), delta, state);
            if (n > this.stateListeners.size()) {
                n = this.stateListeners.size();
                --i;
            }
            ++i;
        }
        if (e.getComponent() != null) {
            e.getComponent().notifyBoundActions(this, delta, state, e.getWhen());
        }
    }

    public abstract void consumePendingEvents(InputSystem var1, EventQueue var2, long var3) throws InputSystemException;

    public abstract void collectEvents(InputSystem var1, EventQueue var2, long var3) throws InputSystemException;

    public abstract void update(InputSystem var1, EventQueue var2, long var3) throws InputSystemException;

    public abstract void destroy() throws InputSystemException;

    public InputDevice(InputSourceWindow sourceWindow, EventQueue eventQueue, String name) throws InputSystemException {
        if (sourceWindow == null) {
            throw new InputSystemException("The InputSourceWindow must not be null.");
        }
        this.sourceWindow = sourceWindow;
        this.eventQueue = eventQueue;
        this.name = name;
        if (name == null) {
            throw new InputSystemException("The name must not be null.");
        }
    }
}

