/*
 * Decompiled with CFR 0.152.
 */
package org.jagatoo.input.events;

import java.util.ArrayList;
import org.jagatoo.input.devices.Keyboard;
import org.jagatoo.input.devices.components.Key;
import org.jagatoo.input.events.KeyPressedEvent;
import org.jagatoo.input.events.KeyReleasedEvent;
import org.jagatoo.input.events.KeyTypedEvent;
import org.jagatoo.input.render.InputSourceWindow;

public final class KeyboardEventPool {
    private static ArrayList<KeyPressedEvent> instances_pressed = new ArrayList(64);
    private static ArrayList<KeyReleasedEvent> instances_released = new ArrayList(64);
    private static ArrayList<KeyTypedEvent> instances_typed = new ArrayList(64);
    private static int n_pressed = 0;
    private static int n_released = 0;
    private static int n_typed = 0;
    private static final Object LOCK_pressed = new Object();
    private static final Object LOCK_released = new Object();
    private static final Object LOCK_typed = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static KeyPressedEvent allocPressed() {
        Object object = LOCK_pressed;
        synchronized (object) {
            if (n_pressed > 0) {
                KeyPressedEvent e = instances_pressed.remove(--n_pressed);
                return e;
            }
            return new KeyPressedEvent();
        }
    }

    public static KeyPressedEvent allocPressed(Keyboard keyboard, Key key, int modifierMask, long when, long lastWhen) {
        KeyPressedEvent e = KeyboardEventPool.allocPressed();
        e.set(keyboard, key, modifierMask, when, lastWhen);
        return e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void freePressed(KeyPressedEvent e) {
        if (e == null) {
            return;
        }
        Object object = LOCK_pressed;
        synchronized (object) {
            instances_pressed.add(e);
            ++n_pressed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static KeyReleasedEvent allocReleased() {
        Object object = LOCK_released;
        synchronized (object) {
            if (n_released > 0) {
                KeyReleasedEvent e = instances_released.remove(--n_released);
                return e;
            }
            return new KeyReleasedEvent();
        }
    }

    public static KeyReleasedEvent allocReleased(Keyboard keyboard, Key key, int modifierMask, long when, long lastWhen) {
        KeyReleasedEvent e = KeyboardEventPool.allocReleased();
        e.set(keyboard, key, modifierMask, when, lastWhen);
        return e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void freeReleased(KeyReleasedEvent e) {
        if (e == null) {
            return;
        }
        Object object = LOCK_released;
        synchronized (object) {
            instances_released.add(e);
            ++n_released;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static KeyTypedEvent allocTyped() {
        Object object = LOCK_typed;
        synchronized (object) {
            if (n_typed > 0) {
                KeyTypedEvent e = instances_typed.remove(--n_typed);
                return e;
            }
            return new KeyTypedEvent();
        }
    }

    public static KeyTypedEvent allocTyped(Keyboard keyboard, char keyChar, int modifierMask, long when, long lastWhen) {
        KeyTypedEvent e = KeyboardEventPool.allocTyped();
        e.set(keyboard, keyChar, modifierMask, when, lastWhen);
        return e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void freeTyped(KeyTypedEvent e) {
        if (e == null) {
            return;
        }
        Object object = LOCK_typed;
        synchronized (object) {
            instances_typed.add(e);
            ++n_typed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cleanup(InputSourceWindow sourceWindow) {
        int i;
        if (sourceWindow == null) {
            Object object = LOCK_pressed;
            synchronized (object) {
                instances_pressed.clear();
                n_pressed = 0;
            }
            object = LOCK_released;
            synchronized (object) {
                instances_released.clear();
                n_released = 0;
            }
            object = LOCK_typed;
            synchronized (object) {
                instances_typed.clear();
                n_typed = 0;
            }
        }
        Object object = LOCK_pressed;
        synchronized (object) {
            i = instances_pressed.size() - 1;
            while (i >= 0) {
                if (instances_pressed.get(i).getKeyboard().getSourceWindow() == sourceWindow) {
                    instances_pressed.remove(i);
                    --n_pressed;
                }
                --i;
            }
        }
        object = LOCK_released;
        synchronized (object) {
            i = instances_released.size() - 1;
            while (i >= 0) {
                if (instances_released.get(i).getKeyboard().getSourceWindow() == sourceWindow) {
                    instances_released.remove(i);
                    --n_released;
                }
                --i;
            }
        }
        object = LOCK_typed;
        synchronized (object) {
            i = instances_typed.size() - 1;
            while (i >= 0) {
                if (instances_typed.get(i).getKeyboard().getSourceWindow() == sourceWindow) {
                    instances_typed.remove(i);
                    --n_typed;
                }
                --i;
            }
        }
    }

    private KeyboardEventPool() {
    }
}

