/*
 * Decompiled with CFR 0.152.
 */
package org.jagatoo.input.handlers;

import org.jagatoo.input.InputSystem;
import org.jagatoo.input.InputSystemException;
import org.jagatoo.input.actions.InputAction;
import org.jagatoo.input.managers.InputBindingsManager;
import org.jagatoo.input.managers.InputStatesManager;
import org.jagatoo.input.render.InputSourceWindow;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class InputHandler<A extends InputAction> {
    public static final int MOUSE_MOVEMENT_SUSPENDED = 1;
    public static final int MOUSE_BUTTONS_SUSPENDED = 2;
    public static final int MOUSE_WHEEL_SUSPENDED = 4;
    public static final int KEYBOARD_SUSPENDED = 8;
    public static final int CONTROLLERS_SUSPENDED = 16;
    public static final int FIRST_USER_SUSPEND_FLAG = 32;
    private InputSystem inputSystem = null;
    protected int suspendMask = 0;
    private InputSourceWindow attachedISW = null;
    private boolean mouseSmoothingEnabled = false;
    private final InputBindingsManager<A> bindingsManager;
    private final InputStatesManager statesManager;
    private long oldNanoTime = -1L;

    public InputBindingsManager<A> getBindingsManager() {
        return this.bindingsManager;
    }

    public InputStatesManager getStatesManager() {
        return this.statesManager;
    }

    public void setMouseSmoothingEnabled(boolean enabled) {
        this.mouseSmoothingEnabled = enabled;
    }

    public final boolean isMouseSmoothingEnabled() {
        return this.mouseSmoothingEnabled;
    }

    public boolean setSuspendMask(int suspendMask) {
        if (suspendMask == this.suspendMask) {
            return false;
        }
        this.suspendMask = suspendMask;
        if (this.getStatesManager() != null) {
            this.getStatesManager().setSuspendMask(suspendMask);
        }
        return true;
    }

    public final int getSuspendMask() {
        return this.suspendMask;
    }

    public final void setMouseMovementSuspended(boolean suspended) {
        if (suspended) {
            this.setSuspendMask(this.suspendMask | 1);
        } else {
            this.setSuspendMask(this.suspendMask & 0xFFFFFFFE);
        }
    }

    public final boolean isMouseMovementSuspended() {
        return (this.suspendMask & 1) > 0;
    }

    public final void setMouseButtonsSuspended(boolean suspended) {
        if (suspended) {
            this.setSuspendMask(this.suspendMask | 2);
        } else {
            this.setSuspendMask(this.suspendMask & 0xFFFFFFFD);
        }
    }

    public final boolean isMouseButtonsSuspended() {
        return (this.suspendMask & 2) > 0;
    }

    public final void setMouseWheelSuspended(boolean suspended) {
        if (suspended) {
            this.setSuspendMask(this.suspendMask | 4);
        } else {
            this.setSuspendMask(this.suspendMask & 0xFFFFFFFB);
        }
    }

    public final boolean isMouseWheelSuspended() {
        return (this.suspendMask & 4) > 0;
    }

    public final void setMouseSuspended(boolean suspended) {
        this.setMouseMovementSuspended(suspended);
        this.setMouseButtonsSuspended(suspended);
        this.setMouseWheelSuspended(suspended);
    }

    public final boolean isMouseSuspended() {
        return this.isMouseMovementSuspended() || this.isMouseButtonsSuspended() || this.isMouseWheelSuspended();
    }

    public final void setKeyboardSuspended(boolean suspended) {
        if (suspended) {
            this.setSuspendMask(this.suspendMask | 8);
        } else {
            this.setSuspendMask(this.suspendMask & 0xFFFFFFF7);
        }
    }

    public final boolean isKeyboardSuspended() {
        return (this.suspendMask & 8) > 0;
    }

    public final void setControllersSuspended(boolean suspended) {
        if (suspended) {
            this.setSuspendMask(this.suspendMask | 0x10);
        } else {
            this.setSuspendMask(this.suspendMask & 0xFFFFFFEF);
        }
    }

    public final boolean areControllersSuspended() {
        return (this.suspendMask & 0x10) > 0;
    }

    public void attachToSourceWindow(InputSourceWindow inputSourceWindow) {
        this.attachedISW = inputSourceWindow;
    }

    public final InputSourceWindow getAttachedSourceWindow() {
        return this.attachedISW;
    }

    public void setSuspended(boolean suspended) {
        if (suspended) {
            this.setSuspendMask(-1);
        } else {
            this.setSuspendMask(0);
        }
    }

    public final boolean isSuspended() {
        return this.isKeyboardSuspended() || this.isMouseMovementSuspended() || this.isMouseButtonsSuspended() || this.isMouseWheelSuspended();
    }

    protected void updateInputStates(long nanoTime) {
        if (this.getAttachedSourceWindow() != null && !this.getAttachedSourceWindow().receivesInputEvents()) {
            return;
        }
        if (this.statesManager != null) {
            this.statesManager.update(nanoTime);
        }
    }

    public abstract void update(long var1, float var3, long var4, float var6) throws InputSystemException;

    public final void update(long nanoTime) throws InputSystemException {
        if (this.oldNanoTime == -1L) {
            this.oldNanoTime = nanoTime;
        }
        long nanoFrame = nanoTime - this.oldNanoTime;
        this.oldNanoTime = nanoTime;
        if (this.getAttachedSourceWindow() != null && !this.getAttachedSourceWindow().receivesInputEvents()) {
            return;
        }
        this.updateInputStates(nanoTime);
        this.update(nanoTime, (float)nanoTime / 1.0E9f, nanoFrame, (float)nanoFrame / 1.0E9f);
    }

    public void setInputSystem(InputSystem inputSystem) {
        if (inputSystem == this.inputSystem) {
            return;
        }
        if (this.inputSystem != null && this.statesManager != null) {
            this.inputSystem.deregisterInputStatesManager(this.statesManager);
        }
        this.inputSystem = inputSystem;
        if (inputSystem != null && this.statesManager != null) {
            inputSystem.registerInputStatesManager(this.statesManager);
        }
    }

    public final InputSystem getInputSystem() {
        return this.inputSystem;
    }

    protected InputStatesManager createInputStatesManager(InputBindingsManager<A> bindingsManager) {
        return new InputStatesManager(bindingsManager);
    }

    public InputHandler(InputBindingsManager<A> bindingsManager) {
        this.bindingsManager = bindingsManager;
        this.statesManager = bindingsManager == null ? null : this.createInputStatesManager(bindingsManager);
    }
}

