/*
 * Decompiled with CFR 0.152.
 */
package org.jagatoo.input.impl.awt;

import java.awt.AWTEvent;
import java.awt.AWTException;
import java.awt.Component;
import java.awt.Point;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelListener;
import org.jagatoo.input.InputSystem;
import org.jagatoo.input.InputSystemException;
import org.jagatoo.input.devices.Mouse;
import org.jagatoo.input.devices.MouseFactory;
import org.jagatoo.input.devices.components.MouseButton;
import org.jagatoo.input.devices.components.MouseButtons;
import org.jagatoo.input.devices.components.MouseWheel;
import org.jagatoo.input.events.EventQueue;
import org.jagatoo.input.events.InputEvent;
import org.jagatoo.input.events.MouseButtonPressedEvent;
import org.jagatoo.input.events.MouseButtonReleasedEvent;
import org.jagatoo.input.events.MouseEventPool;
import org.jagatoo.input.events.MouseMovedEvent;
import org.jagatoo.input.events.MouseWheelEvent;
import org.jagatoo.input.render.InputSourceWindow;

public class AWTMouse
extends Mouse {
    private static final MouseButton[] buttonMap = new MouseButton[12];
    private Component usedComponent;
    private final Point centerComponent = new Point();
    private Point los = null;
    private Robot robot = null;
    private boolean needsRecenter = false;
    private int lastAbsoluteX = 0;
    private int lastAbsoluteY = 0;
    private int lastRelX = -1;
    private int lastRelY = -1;
    private int nextIgnoredX = -1;
    private int nextIgnoredY = -1;
    private long lastKnownNanoTime = -1L;
    private final AWTEventListener eventListener = new AWTEventListener(){

        public void eventDispatched(AWTEvent event) {
            if (event instanceof MouseEvent) {
                AWTMouse.this.processMouseEvent((MouseEvent)event);
            }
        }
    };

    static {
        AWTMouse.buttonMap[1] = MouseButtons.LEFT_BUTTON;
        AWTMouse.buttonMap[3] = MouseButtons.RIGHT_BUTTON;
        AWTMouse.buttonMap[2] = MouseButtons.MIDDLE_BUTTON;
        AWTMouse.buttonMap[0] = MouseButtons.EXT_BUTTON_1;
        AWTMouse.buttonMap[4] = MouseButtons.EXT_BUTTON_2;
        AWTMouse.buttonMap[5] = MouseButtons.EXT_BUTTON_3;
        AWTMouse.buttonMap[6] = MouseButtons.EXT_BUTTON_4;
        AWTMouse.buttonMap[7] = MouseButtons.EXT_BUTTON_5;
        AWTMouse.buttonMap[8] = MouseButtons.EXT_BUTTON_6;
        AWTMouse.buttonMap[9] = MouseButtons.EXT_BUTTON_7;
        AWTMouse.buttonMap[10] = MouseButtons.EXT_BUTTON_8;
        AWTMouse.buttonMap[11] = MouseButtons.EXT_BUTTON_9;
    }

    public static final MouseButton convertButton(int awtButton) {
        return buttonMap[awtButton];
    }

    private final void ensureRobot() throws InputSystemException {
        if (this.robot == null) {
            try {
                this.robot = new Robot();
            }
            catch (AWTException e) {
                throw new InputSystemException(e);
            }
        }
    }

    public void setPosition(int x, int y) throws InputSystemException {
        super.setPosition(x, y);
        try {
            if (this.isAbsolute()) {
                this.ensureRobot();
                this.robot.mouseMove(this.los.x + x, this.los.y + y);
            } else {
                this.lastAbsoluteX = x;
                this.lastAbsoluteY = y;
            }
        }
        catch (Throwable t) {
            if (t instanceof InputSystemException) {
                throw (InputSystemException)t;
            }
            if (t instanceof Error) {
                throw (Error)t;
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new InputSystemException(t);
        }
    }

    public void centerMouse() throws InputSystemException {
        int centerX = 0;
        int centerY = 0;
        try {
            centerX = this.getSourceWindow().getWidth() / 2;
            centerY = this.getSourceWindow().getHeight() / 2;
        }
        catch (Throwable t) {
            throw new InputSystemException(t);
        }
        this.setPosition(centerX, centerY);
    }

    private void updateCenters() {
        this.los = this.usedComponent.getLocationOnScreen();
        int centerX = this.los.x + this.usedComponent.getWidth() / 2 + 1;
        int centerY = this.los.y + this.usedComponent.getHeight() / 2 + 1;
        this.centerComponent.setLocation(centerX, centerY);
    }

    private void recenter() throws InputSystemException {
        this.ensureRobot();
        this.nextIgnoredX = this.centerComponent.x - this.los.x;
        this.nextIgnoredY = this.centerComponent.y - this.los.y;
        this.lastRelX = this.nextIgnoredX;
        this.lastRelY = this.nextIgnoredY;
        this.needsRecenter = false;
        this.robot.mouseMove(this.centerComponent.x, this.centerComponent.y);
    }

    public void consumePendingEvents(InputSystem is, EventQueue eventQueue, long nanoTime) throws InputSystemException {
    }

    public void collectEvents(InputSystem is, EventQueue eventQueue, long nanoTime) throws InputSystemException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void notifyStatesManagersFromQueue(InputSystem is, EventQueue eventQueue, long nanoTime) {
        if (eventQueue.getNumEvents() == 0) {
            return;
        }
        Object object = EventQueue.LOCK;
        synchronized (object) {
            int i = 0;
            while (i < eventQueue.getNumEvents()) {
                InputEvent event = eventQueue.getEvent(i);
                if (event.getType() == InputEvent.Type.MOUSE_EVENT) {
                    org.jagatoo.input.events.MouseEvent moEvent = (org.jagatoo.input.events.MouseEvent)event;
                    switch (moEvent.getSubType()) {
                        case BUTTON_PRESSED: {
                            is.notifyInputStatesManagers(this, moEvent.getComponent(), 1, 1, nanoTime);
                            break;
                        }
                        case BUTTON_RELEASED: {
                            is.notifyInputStatesManagers(this, moEvent.getComponent(), 0, -1, nanoTime);
                            break;
                        }
                        case WHEEL_MOVED: {
                            MouseWheelEvent mwEvent = (MouseWheelEvent)moEvent;
                            MouseWheel wheel = (MouseWheel)mwEvent.getComponent();
                            is.notifyInputStatesManagers(this, wheel, wheel.getIntValue(), mwEvent.getWheelDelta(), nanoTime);
                            break;
                        }
                        case MOVED: {
                            MouseMovedEvent mmEvent = (MouseMovedEvent)moEvent;
                            if (mmEvent.getDX() != 0) {
                                is.notifyInputStatesManagers(this, mmEvent.getMouse().getXAxis(), mmEvent.getX(), mmEvent.getDX(), nanoTime);
                            }
                            if (mmEvent.getDY() == 0) break;
                            is.notifyInputStatesManagers(this, mmEvent.getMouse().getYAxis(), mmEvent.getY(), mmEvent.getDY(), nanoTime);
                        }
                    }
                }
                ++i;
            }
        }
    }

    public void updateMouse(InputSystem is, EventQueue eventQueue, long nanoTime) throws InputSystemException {
        this.lastKnownNanoTime = nanoTime;
        try {
            this.notifyStatesManagersFromQueue(is, eventQueue, nanoTime);
            this.getEventQueue().dequeueAndFire(is, InputEvent.Type.MOUSE_EVENT);
            this.handleClickedEvents(nanoTime, is.getMouseButtonClickThreshold());
            if (!this.isAbsolute()) {
                // empty if block
            }
        }
        catch (Throwable t) {
            if (t instanceof InputSystemException) {
                throw (InputSystemException)t;
            }
            if (t instanceof Error) {
                throw (Error)t;
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new InputSystemException(t);
        }
    }

    protected void setAbsoluteImpl(boolean absolute) throws InputSystemException {
        try {
            this.updateCenters();
            if (absolute) {
                this.setPosition(this.getCurrentX(), this.getCurrentY());
            } else {
                this.recenter();
            }
        }
        catch (Throwable t) {
            if (t instanceof InputSystemException) {
                throw (InputSystemException)t;
            }
            if (t instanceof Error) {
                throw (Error)t;
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new InputSystemException(t);
        }
    }

    private void processMouseEvent(MouseEvent _e) {
        if (!this.isEnabled() || !this.getSourceWindow().receivesInputEvents()) {
            return;
        }
        switch (_e.getID()) {
            case 501: {
                MouseButton button = AWTMouse.convertButton(_e.getButton());
                if (button == null) break;
                MouseButtonPressedEvent e = this.prepareMouseButtonPressedEvent(button, this.lastKnownNanoTime);
                if (e == null) {
                    return;
                }
                this.getEventQueue().enqueue(e);
                break;
            }
            case 502: {
                MouseButton button = AWTMouse.convertButton(_e.getButton());
                if (button == null) break;
                MouseButtonReleasedEvent e = this.prepareMouseButtonReleasedEvent(button, this.lastKnownNanoTime);
                if (e == null) {
                    return;
                }
                this.getEventQueue().enqueue(e);
                break;
            }
            case 503: 
            case 506: {
                if (this.isAbsolute()) {
                    int x = _e.getX();
                    int y = _e.getY();
                    int dx = x - this.getCurrentX();
                    int dy = y - this.getCurrentY();
                    this.storePosition(x, y);
                    MouseMovedEvent e = this.prepareMouseMovedEvent(x, y, dx, dy, this.lastKnownNanoTime);
                    if (e == null) {
                        return;
                    }
                    this.getEventQueue().enqueue(e);
                    this.lastAbsoluteX = x;
                    this.lastAbsoluteY = y;
                    break;
                }
                int dx = _e.getX() - this.centerComponent.x + this.los.x;
                int dy = _e.getY() - this.centerComponent.y + this.los.y;
                if (dx == 0 && dy == 0) break;
                this.lastRelX = _e.getX();
                this.lastRelY = _e.getY();
                this.nextIgnoredX = -1;
                this.nextIgnoredY = -1;
                MouseMovedEvent e = this.prepareMouseMovedEvent(this.lastAbsoluteX, this.lastAbsoluteY, dx, dy, this.lastKnownNanoTime);
                if (e == null) {
                    return;
                }
                this.getEventQueue().enqueue(e);
                this.needsRecenter = true;
                try {
                    this.recenter();
                    break;
                }
                catch (InputSystemException ise) {
                    ise.printStackTrace();
                }
            }
        }
    }

    private void processMouseEvent(java.awt.event.MouseWheelEvent _e) {
        if (!this.isEnabled()) {
            return;
        }
        java.awt.event.MouseWheelEvent __e = _e;
        boolean isPageMove = __e.getScrollType() == 1;
        MouseWheelEvent e = MouseEventPool.allocWheel(this, this.getWheel(), -__e.getWheelRotation(), isPageMove, this.lastKnownNanoTime, 0L);
        if (e != null) {
            this.getEventQueue().enqueue(e);
        }
    }

    public void destroyImpl() throws InputSystemException {
        try {
            Toolkit.getDefaultToolkit().removeAWTEventListener(this.eventListener);
        }
        catch (Throwable t) {
            throw new InputSystemException(t);
        }
    }

    private final void trapInitialLocationOnScreen(final Component component) {
        if (component.isDisplayable()) {
            this.los = component.getLocationOnScreen();
        } else {
            component.addComponentListener(new ComponentAdapter(){

                public void componentShown(ComponentEvent e) {
                    AWTMouse.this.los = component.getLocationOnScreen();
                    component.removeComponentListener(this);
                }
            });
        }
    }

    protected AWTMouse(MouseFactory factory, InputSourceWindow sourceWindow, EventQueue eventQueue) throws InputSystemException {
        super(factory, sourceWindow, eventQueue, "Primary Mouse", 12, true);
        try {
            Toolkit.getDefaultToolkit().addAWTEventListener(this.eventListener, 48L);
            Component component = (Component)sourceWindow.getDrawable();
            component.addMouseWheelListener(new MouseWheelListener(){

                public void mouseWheelMoved(java.awt.event.MouseWheelEvent e) {
                    AWTMouse.this.processMouseEvent(e);
                }
            });
            this.usedComponent = component;
            this.trapInitialLocationOnScreen(component);
        }
        catch (Throwable e) {
            throw new InputSystemException(e);
        }
    }
}

