/*
 * Decompiled with CFR 0.152.
 */
package org.jagatoo.input.impl.lwjgl;

import java.util.Arrays;
import org.jagatoo.input.InputSystem;
import org.jagatoo.input.InputSystemException;
import org.jagatoo.input.devices.Controller;
import org.jagatoo.input.devices.ControllerFactory;
import org.jagatoo.input.devices.components.ControllerAxis;
import org.jagatoo.input.devices.components.ControllerButton;
import org.jagatoo.input.devices.components.InputState;
import org.jagatoo.input.events.ControllerAxisChangedEvent;
import org.jagatoo.input.events.ControllerButtonPressedEvent;
import org.jagatoo.input.events.ControllerButtonReleasedEvent;
import org.jagatoo.input.events.EventQueue;
import org.jagatoo.input.events.InputEvent;
import org.jagatoo.input.impl.lwjgl.LWJGLControllerAxis;
import org.jagatoo.input.render.InputSourceWindow;
import org.lwjgl.input.Controllers;

public class LWJGLController
extends Controller {
    private final org.lwjgl.input.Controller implController;
    private static int[] indexMap = null;
    private static long lastUpdateTime = -1L;

    public void onDeviceRegistered(InputSystem inputSystem) throws InputSystemException {
        if (indexMap == null) {
            indexMap = new int[Controllers.getControllerCount()];
            Arrays.fill(indexMap, -1);
        }
        LWJGLController.indexMap[this.getIndex()] = inputSystem.getControllersCount() - 1;
        this.consumePendingEvents(inputSystem, null, -1L);
    }

    public void onDeviceUnregistered(InputSystem inputSystem) throws InputSystemException {
        LWJGLController.indexMap[this.getIndex()] = -1;
    }

    protected final org.lwjgl.input.Controller getController() {
        return this.implController;
    }

    protected final int getIndex() {
        return this.implController.getIndex();
    }

    protected final void collectOrFireEvents(InputSystem is, EventQueue eventQueue, long nanoTime) throws InputSystemException {
        if (!this.getSourceWindow().receivesInputEvents()) {
            return;
        }
        boolean isQueued = eventQueue != null;
        try {
            int i = 0;
            while (i < this.getAxesCount()) {
                ControllerAxis axis = this.getAxis(i);
                float oldValue = axis.getFloatValue();
                float newValue = this.implController.getAxisValue(i);
                if (newValue != oldValue) {
                    int oldIntValue = axis.getIntValue();
                    axis.setValue(newValue);
                    ControllerAxisChangedEvent axisEv = this.prepareControllerAxisChanged(axis, newValue - oldValue, nanoTime);
                    is.notifyInputStatesManagers(this, axis, axis.getIntValue(), axis.getIntValue() - oldIntValue, nanoTime);
                    if (axisEv != null) {
                        if (isQueued) {
                            eventQueue.enqueue(axisEv);
                        } else {
                            this.fireOnControllerAxisChanged(axisEv, true);
                        }
                    }
                }
                ++i;
            }
            i = 0;
            while (i < this.getButtonsCount()) {
                ControllerButton button = this.getButton(i);
                boolean oldState = button.getBooleanState();
                boolean newState = this.implController.isButtonPressed(i);
                if (newState != oldState) {
                    if (newState) {
                        button.setState(InputState.POSITIVE);
                        ControllerButtonPressedEvent pressedEv = this.prepareControllerButtonPressed(button, nanoTime);
                        is.notifyInputStatesManagers(this, button, 1, 1, nanoTime);
                        if (pressedEv != null) {
                            if (isQueued) {
                                eventQueue.enqueue(pressedEv);
                            } else {
                                this.fireOnControllerButtonPressed(pressedEv, true);
                            }
                        }
                    } else {
                        button.setState(InputState.NEGATIVE);
                        ControllerButtonReleasedEvent releasedEv = this.prepareControllerButtonReleased(button, nanoTime);
                        is.notifyInputStatesManagers(this, button, 0, -1, nanoTime);
                        if (releasedEv != null) {
                            if (isQueued) {
                                eventQueue.enqueue(releasedEv);
                            } else {
                                this.fireOnControllerButtonReleased(releasedEv, true);
                            }
                        }
                    }
                }
                ++i;
            }
        }
        catch (Throwable t) {
            if (t instanceof InputSystemException) {
                throw (InputSystemException)t;
            }
            if (t instanceof Error) {
                throw (Error)t;
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new InputSystemException(t);
        }
    }

    public void consumePendingEvents(InputSystem is, EventQueue eventQueue, long nanoTime) throws InputSystemException {
    }

    public void collectEvents(InputSystem is, EventQueue eventQueue, long nanoTime) throws InputSystemException {
        if (eventQueue == null) {
            throw new InputSystemException("EventQueue must not be null here!");
        }
        this.collectOrFireEvents(is, eventQueue, nanoTime);
    }

    public void update(InputSystem is, EventQueue eventQueue, long nanoTime) throws InputSystemException {
        if (nanoTime > lastUpdateTime) {
            try {
                Controllers.poll();
                while (Controllers.next()) {
                    int controllerIndex = Controllers.getEventSource().getIndex();
                    int realIndex = indexMap[controllerIndex];
                    if (realIndex == -1) continue;
                    LWJGLController ctrl = (LWJGLController)is.getController(realIndex);
                    ctrl.collectOrFireEvents(is, null, nanoTime);
                }
            }
            catch (Throwable t) {
                if (t instanceof InputSystemException) {
                    throw (InputSystemException)t;
                }
                if (t instanceof Error) {
                    throw (Error)t;
                }
                if (t instanceof RuntimeException) {
                    throw (RuntimeException)t;
                }
                throw new InputSystemException(t);
            }
            lastUpdateTime = nanoTime;
        }
        this.getEventQueue().dequeueAndFire(is, InputEvent.Type.CONTROLLER_EVENT);
    }

    public void destroyImpl() throws InputSystemException {
    }

    protected final LWJGLControllerAxis[] createAxesArray(Object implObj) {
        org.lwjgl.input.Controller controller = (org.lwjgl.input.Controller)implObj;
        LWJGLControllerAxis[] axes = new LWJGLControllerAxis[controller.getAxisCount()];
        int i = 0;
        while (i < controller.getAxisCount()) {
            axes[i] = new LWJGLControllerAxis(this, controller, i);
            ++i;
        }
        return axes;
    }

    protected final ControllerButton[] createButtonsArray(Object implObj) {
        org.lwjgl.input.Controller controller = (org.lwjgl.input.Controller)implObj;
        ControllerButton[] buttons = new ControllerButton[controller.getButtonCount()];
        int i = 0;
        while (i < controller.getButtonCount()) {
            buttons[i] = new ControllerButton(this, i, controller.getButtonName(i));
            ++i;
        }
        return buttons;
    }

    protected LWJGLController(ControllerFactory factory, InputSourceWindow sourceWindow, EventQueue eventQueue, org.lwjgl.input.Controller implController) throws InputSystemException {
        super(factory, sourceWindow, eventQueue, implController.getName(), implController);
        this.implController = implController;
    }
}

