/*
 * Decompiled with CFR 0.152.
 */
package org.jagatoo.input.impl.lwjgl;

import org.jagatoo.input.InputSystem;
import org.jagatoo.input.InputSystemException;
import org.jagatoo.input.devices.KeyboardFactory;
import org.jagatoo.input.devices.components.Key;
import org.jagatoo.input.devices.components.Keys;
import org.jagatoo.input.events.EventQueue;
import org.jagatoo.input.events.InputEvent;
import org.jagatoo.input.events.KeyPressedEvent;
import org.jagatoo.input.events.KeyReleasedEvent;
import org.jagatoo.input.events.KeyTypedEvent;
import org.jagatoo.input.impl.lwjgl.LWJGLMessageProcessor;
import org.jagatoo.input.localization.KeyboardLocalizer;
import org.jagatoo.input.render.InputSourceWindow;
import org.lwjgl.LWJGLException;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.Display;

public class LWJGLKeyboard
extends org.jagatoo.input.devices.Keyboard {
    private static final Key[] keyMap = new Key[256];
    private Key lastPressedKey = null;
    private char typedChar = '\u0000';
    private long nextContTypedTime = -1L;
    private static final long CONTINUOUS_TYPED_GAP = 200000000L;
    private static final long CONTINUOUS_TYPED_DELTA = 50000000L;

    static {
        LWJGLKeyboard.keyMap[1] = Keys.ESCAPE;
        LWJGLKeyboard.keyMap[59] = Keys.F1;
        LWJGLKeyboard.keyMap[60] = Keys.F2;
        LWJGLKeyboard.keyMap[61] = Keys.F3;
        LWJGLKeyboard.keyMap[62] = Keys.F4;
        LWJGLKeyboard.keyMap[63] = Keys.F5;
        LWJGLKeyboard.keyMap[64] = Keys.F6;
        LWJGLKeyboard.keyMap[65] = Keys.F7;
        LWJGLKeyboard.keyMap[66] = Keys.F8;
        LWJGLKeyboard.keyMap[67] = Keys.F9;
        LWJGLKeyboard.keyMap[68] = Keys.F10;
        LWJGLKeyboard.keyMap[87] = Keys.F11;
        LWJGLKeyboard.keyMap[88] = Keys.F12;
        LWJGLKeyboard.keyMap[197] = Keys.PAUSE;
        LWJGLKeyboard.keyMap[70] = Keys.SCROLL_LOCK;
        LWJGLKeyboard.keyMap[144] = Keys.CIRCUMFLEX;
        LWJGLKeyboard.keyMap[11] = Keys._0;
        LWJGLKeyboard.keyMap[2] = Keys._1;
        LWJGLKeyboard.keyMap[3] = Keys._2;
        LWJGLKeyboard.keyMap[4] = Keys._3;
        LWJGLKeyboard.keyMap[5] = Keys._4;
        LWJGLKeyboard.keyMap[6] = Keys._5;
        LWJGLKeyboard.keyMap[7] = Keys._6;
        LWJGLKeyboard.keyMap[8] = Keys._7;
        LWJGLKeyboard.keyMap[9] = Keys._8;
        LWJGLKeyboard.keyMap[10] = Keys._9;
        LWJGLKeyboard.keyMap[30] = Keys.A;
        LWJGLKeyboard.keyMap[48] = Keys.B;
        LWJGLKeyboard.keyMap[46] = Keys.C;
        LWJGLKeyboard.keyMap[32] = Keys.D;
        LWJGLKeyboard.keyMap[18] = Keys.E;
        LWJGLKeyboard.keyMap[33] = Keys.F;
        LWJGLKeyboard.keyMap[34] = Keys.G;
        LWJGLKeyboard.keyMap[35] = Keys.H;
        LWJGLKeyboard.keyMap[23] = Keys.I;
        LWJGLKeyboard.keyMap[36] = Keys.J;
        LWJGLKeyboard.keyMap[37] = Keys.K;
        LWJGLKeyboard.keyMap[38] = Keys.L;
        LWJGLKeyboard.keyMap[50] = Keys.M;
        LWJGLKeyboard.keyMap[49] = Keys.N;
        LWJGLKeyboard.keyMap[24] = Keys.O;
        LWJGLKeyboard.keyMap[25] = Keys.P;
        LWJGLKeyboard.keyMap[16] = Keys.Q;
        LWJGLKeyboard.keyMap[19] = Keys.R;
        LWJGLKeyboard.keyMap[31] = Keys.S;
        LWJGLKeyboard.keyMap[20] = Keys.T;
        LWJGLKeyboard.keyMap[22] = Keys.U;
        LWJGLKeyboard.keyMap[47] = Keys.V;
        LWJGLKeyboard.keyMap[17] = Keys.W;
        LWJGLKeyboard.keyMap[45] = Keys.X;
        LWJGLKeyboard.keyMap[21] = Keys.Y;
        LWJGLKeyboard.keyMap[44] = Keys.Z;
        LWJGLKeyboard.keyMap[15] = Keys.TAB;
        LWJGLKeyboard.keyMap[57] = Keys.SPACE;
        LWJGLKeyboard.keyMap[14] = Keys.BACK_SPACE;
        LWJGLKeyboard.keyMap[28] = Keys.ENTER;
        LWJGLKeyboard.keyMap[42] = Keys.LEFT_SHIFT;
        LWJGLKeyboard.keyMap[54] = Keys.RIGHT_SHIFT;
        LWJGLKeyboard.keyMap[29] = Keys.LEFT_CONTROL;
        LWJGLKeyboard.keyMap[157] = Keys.RIGHT_CONTROL;
        LWJGLKeyboard.keyMap[56] = Keys.ALT;
        LWJGLKeyboard.keyMap[184] = Keys.ALT_GRAPH;
        LWJGLKeyboard.keyMap[219] = Keys.LEFT_META;
        LWJGLKeyboard.keyMap[220] = Keys.RIGHT_META;
        LWJGLKeyboard.keyMap[58] = Keys.CAPS_LOCK;
        LWJGLKeyboard.keyMap[211] = Keys.DELETE;
        LWJGLKeyboard.keyMap[210] = Keys.INSERT;
        LWJGLKeyboard.keyMap[207] = Keys.END;
        LWJGLKeyboard.keyMap[199] = Keys.HOME;
        LWJGLKeyboard.keyMap[201] = Keys.PAGE_UP;
        LWJGLKeyboard.keyMap[209] = Keys.PAGE_DOWN;
        LWJGLKeyboard.keyMap[205] = Keys.RIGHT;
        LWJGLKeyboard.keyMap[203] = Keys.LEFT;
        LWJGLKeyboard.keyMap[200] = Keys.UP;
        LWJGLKeyboard.keyMap[208] = Keys.DOWN;
        LWJGLKeyboard.keyMap[69] = Keys.NUM_LOCK;
        LWJGLKeyboard.keyMap[181] = Keys.NUMPAD_DIVIDE;
        LWJGLKeyboard.keyMap[55] = Keys.NUMPAD_MULTIPLY;
        LWJGLKeyboard.keyMap[74] = Keys.NUMPAD_SUBTRACT;
        LWJGLKeyboard.keyMap[78] = Keys.NUMPAD_ADD;
        LWJGLKeyboard.keyMap[156] = Keys.NUMPAD_ENTER;
        LWJGLKeyboard.keyMap[179] = Keys.NUMPAD_DECIMAL;
        LWJGLKeyboard.keyMap[82] = Keys.NUMPAD0;
        LWJGLKeyboard.keyMap[79] = Keys.NUMPAD1;
        LWJGLKeyboard.keyMap[80] = Keys.NUMPAD2;
        LWJGLKeyboard.keyMap[81] = Keys.NUMPAD3;
        LWJGLKeyboard.keyMap[75] = Keys.NUMPAD4;
        LWJGLKeyboard.keyMap[76] = Keys.NUMPAD5;
        LWJGLKeyboard.keyMap[77] = Keys.NUMPAD6;
        LWJGLKeyboard.keyMap[71] = Keys.NUMPAD7;
        LWJGLKeyboard.keyMap[72] = Keys.NUMPAD8;
        LWJGLKeyboard.keyMap[73] = Keys.NUMPAD9;
    }

    public static final Key convertKey(int lwjglKey, char keyChar) {
        Key key = keyMap[lwjglKey];
        if (key == null) {
            key = KeyboardLocalizer.getMapping().getLocalizedKey(keyChar);
        }
        if (key == Keys.DELETE && keyChar != '\u0000') {
            key = Keys.NUMPAD_DECIMAL;
        }
        return key;
    }

    protected boolean hasKeyStateChanged(Key key, boolean keyState) {
        return true;
    }

    private boolean triggerTyped(char keyChar, int modifierMask, long nanoTime, long lastNanoTime, EventQueue eventQueue) {
        KeyTypedEvent typedEv = this.prepareKeyTypedEvent(keyChar, modifierMask, nanoTime, lastNanoTime);
        if (typedEv == null) {
            return false;
        }
        if (eventQueue != null) {
            eventQueue.enqueue(typedEv);
        } else {
            this.fireOnKeyTyped(typedEv, true);
        }
        return true;
    }

    protected final void collectOrFireEvents(InputSystem is, EventQueue eventQueue, long nanoTime, boolean acceptsEvents) throws InputSystemException {
        boolean isQueued;
        boolean bl = isQueued = eventQueue != null;
        if (!Display.isCreated()) {
            throw new InputSystemException("Display is not created.");
        }
        if (!Keyboard.isCreated()) {
            throw new InputSystemException("Mouse is not created.");
        }
        try {
            LWJGLMessageProcessor.processMessages(nanoTime);
            Keyboard.poll();
            while (Keyboard.next()) {
                if (!acceptsEvents) continue;
                int keyCode = Keyboard.getEventKey();
                char keyChar = Keyboard.getEventCharacter();
                boolean keyState = Keyboard.getEventKeyState();
                Key key = LWJGLKeyboard.convertKey(keyCode, keyChar);
                int modifierMask = this.applyModifier(key, keyState);
                if (keyState) {
                    KeyPressedEvent pressedEv = this.prepareKeyPressedEvent(key, modifierMask, nanoTime, 0L);
                    is.notifyInputStatesManagers(this, key, 1, 1, nanoTime);
                    if (pressedEv == null) continue;
                    this.lastPressedKey = key;
                    this.nextContTypedTime = nanoTime + 200000000L;
                    if (isQueued) {
                        eventQueue.enqueue(pressedEv);
                    } else {
                        this.fireOnKeyPressed(pressedEv, true);
                    }
                    if (key == Keys.DELETE) {
                        keyChar = '\u007f';
                    }
                    this.typedChar = keyChar;
                    if (keyChar != '\u0000') {
                        this.triggerTyped(keyChar, modifierMask, nanoTime, 0L, eventQueue);
                        continue;
                    }
                    this.lastPressedKey = null;
                    continue;
                }
                KeyReleasedEvent releasedEv = this.prepareKeyReleasedEvent(key, modifierMask, nanoTime, 0L);
                is.notifyInputStatesManagers(this, key, 0, -1, nanoTime);
                if (releasedEv == null) continue;
                this.lastPressedKey = null;
                this.typedChar = '\u0000';
                if (isQueued) {
                    eventQueue.enqueue(releasedEv);
                    continue;
                }
                this.fireOnKeyReleased(releasedEv, true);
            }
            if (this.lastPressedKey != null && nanoTime >= this.nextContTypedTime) {
                this.triggerTyped(this.typedChar, this.getModifierMask(), nanoTime, 0L, eventQueue);
                this.nextContTypedTime += 50000000L;
            }
        }
        catch (Throwable t) {
            if (t instanceof InputSystemException) {
                throw (InputSystemException)t;
            }
            if (t instanceof Error) {
                throw (Error)t;
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new InputSystemException(t);
        }
    }

    public void consumePendingEvents(InputSystem is, EventQueue eventQueue, long nanoTime) throws InputSystemException {
        this.collectOrFireEvents(is, null, nanoTime, false);
    }

    public void collectEvents(InputSystem is, EventQueue eventQueue, long nanoTime) throws InputSystemException {
        if (eventQueue == null) {
            throw new InputSystemException("EventQueue must not be null here!");
        }
        boolean acceptEvents = this.isEnabled() && this.getSourceWindow().receivesInputEvents();
        this.collectOrFireEvents(is, eventQueue, nanoTime, acceptEvents);
    }

    public void update(InputSystem is, EventQueue eventQueue, long nanoTime) throws InputSystemException {
        this.collectOrFireEvents(is, null, nanoTime, true);
        this.getEventQueue().dequeueAndFire(is, InputEvent.Type.KEYBOARD_EVENT);
    }

    public void onDeviceRegistered(InputSystem inputSystem) throws InputSystemException {
        this.consumePendingEvents(inputSystem, null, -1L);
    }

    public void destroyImpl() throws InputSystemException {
        try {
            if (Keyboard.isCreated()) {
                Keyboard.destroy();
            }
        }
        catch (Throwable t) {
            throw new InputSystemException(t);
        }
    }

    protected LWJGLKeyboard(KeyboardFactory factory, InputSourceWindow sourceWindow, EventQueue eventQueue) throws InputSystemException {
        super(factory, sourceWindow, eventQueue, "Primary Keyboard");
        try {
            if (!Keyboard.isCreated()) {
                Keyboard.create();
            }
        }
        catch (LWJGLException e) {
            throw new InputSystemException(e);
        }
    }
}

