/*
 * Decompiled with CFR 0.152.
 */
package org.jagatoo.input.impl.swt;

import java.util.Arrays;
import java.util.HashMap;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.widgets.Control;
import org.jagatoo.input.InputSystem;
import org.jagatoo.input.InputSystemException;
import org.jagatoo.input.devices.Keyboard;
import org.jagatoo.input.devices.KeyboardFactory;
import org.jagatoo.input.devices.components.Key;
import org.jagatoo.input.devices.components.Keys;
import org.jagatoo.input.events.EventQueue;
import org.jagatoo.input.events.InputEvent;
import org.jagatoo.input.events.KeyPressedEvent;
import org.jagatoo.input.events.KeyReleasedEvent;
import org.jagatoo.input.events.KeyTypedEvent;
import org.jagatoo.input.events.KeyboardEvent;
import org.jagatoo.input.render.InputSourceWindow;

public class SWTKeyboard
extends Keyboard {
    private long lastGameTimeDelta = System.nanoTime();
    private final long[] lastPressedTimes = new long[Keys.getNumKeys()];
    private final long[] lastReleasedTimes;
    protected static final HashMap<Integer, Key> KEYCODE_CONVERSION;
    protected static final HashMap<Character, Key> CHAR_CONVERSION;

    static {
        CHAR_CONVERSION = new HashMap();
        CHAR_CONVERSION.put(Character.valueOf('0'), Keys._0);
        CHAR_CONVERSION.put(Character.valueOf('1'), Keys._1);
        CHAR_CONVERSION.put(Character.valueOf('2'), Keys._2);
        CHAR_CONVERSION.put(Character.valueOf('3'), Keys._3);
        CHAR_CONVERSION.put(Character.valueOf('4'), Keys._4);
        CHAR_CONVERSION.put(Character.valueOf('5'), Keys._5);
        CHAR_CONVERSION.put(Character.valueOf('6'), Keys._6);
        CHAR_CONVERSION.put(Character.valueOf('7'), Keys._7);
        CHAR_CONVERSION.put(Character.valueOf('8'), Keys._8);
        CHAR_CONVERSION.put(Character.valueOf('9'), Keys._9);
        CHAR_CONVERSION.put(Character.valueOf('a'), Keys.A);
        CHAR_CONVERSION.put(Character.valueOf('b'), Keys.B);
        CHAR_CONVERSION.put(Character.valueOf('c'), Keys.C);
        CHAR_CONVERSION.put(Character.valueOf('d'), Keys.D);
        CHAR_CONVERSION.put(Character.valueOf('e'), Keys.E);
        CHAR_CONVERSION.put(Character.valueOf('f'), Keys.F);
        CHAR_CONVERSION.put(Character.valueOf('g'), Keys.G);
        CHAR_CONVERSION.put(Character.valueOf('h'), Keys.H);
        CHAR_CONVERSION.put(Character.valueOf('i'), Keys.I);
        CHAR_CONVERSION.put(Character.valueOf('j'), Keys.J);
        CHAR_CONVERSION.put(Character.valueOf('k'), Keys.K);
        CHAR_CONVERSION.put(Character.valueOf('l'), Keys.L);
        CHAR_CONVERSION.put(Character.valueOf('m'), Keys.M);
        CHAR_CONVERSION.put(Character.valueOf('n'), Keys.N);
        CHAR_CONVERSION.put(Character.valueOf('o'), Keys.O);
        CHAR_CONVERSION.put(Character.valueOf('p'), Keys.P);
        CHAR_CONVERSION.put(Character.valueOf('q'), Keys.Q);
        CHAR_CONVERSION.put(Character.valueOf('r'), Keys.R);
        CHAR_CONVERSION.put(Character.valueOf('s'), Keys.S);
        CHAR_CONVERSION.put(Character.valueOf('t'), Keys.T);
        CHAR_CONVERSION.put(Character.valueOf('u'), Keys.U);
        CHAR_CONVERSION.put(Character.valueOf('v'), Keys.V);
        CHAR_CONVERSION.put(Character.valueOf('w'), Keys.W);
        CHAR_CONVERSION.put(Character.valueOf('x'), Keys.X);
        CHAR_CONVERSION.put(Character.valueOf('y'), Keys.Y);
        CHAR_CONVERSION.put(Character.valueOf('z'), Keys.Z);
        CHAR_CONVERSION.put(Character.valueOf('\b'), Keys.BACK_SPACE);
        CHAR_CONVERSION.put(Character.valueOf(' '), Keys.SPACE);
        CHAR_CONVERSION.put(Character.valueOf('\r'), Keys.ENTER);
        CHAR_CONVERSION.put(Character.valueOf('\u001b'), Keys.ESCAPE);
        CHAR_CONVERSION.put(Character.valueOf('\u007f'), Keys.DELETE);
        CHAR_CONVERSION.put(Character.valueOf('\t'), Keys.TAB);
        KEYCODE_CONVERSION = new HashMap();
        KEYCODE_CONVERSION.put(48, Keys._0);
        KEYCODE_CONVERSION.put(49, Keys._1);
        KEYCODE_CONVERSION.put(50, Keys._2);
        KEYCODE_CONVERSION.put(51, Keys._3);
        KEYCODE_CONVERSION.put(52, Keys._4);
        KEYCODE_CONVERSION.put(53, Keys._5);
        KEYCODE_CONVERSION.put(54, Keys._6);
        KEYCODE_CONVERSION.put(55, Keys._7);
        KEYCODE_CONVERSION.put(56, Keys._8);
        KEYCODE_CONVERSION.put(57, Keys._9);
        KEYCODE_CONVERSION.put(97, Keys.A);
        KEYCODE_CONVERSION.put(98, Keys.B);
        KEYCODE_CONVERSION.put(99, Keys.C);
        KEYCODE_CONVERSION.put(100, Keys.D);
        KEYCODE_CONVERSION.put(101, Keys.E);
        KEYCODE_CONVERSION.put(102, Keys.F);
        KEYCODE_CONVERSION.put(103, Keys.G);
        KEYCODE_CONVERSION.put(104, Keys.H);
        KEYCODE_CONVERSION.put(105, Keys.I);
        KEYCODE_CONVERSION.put(106, Keys.J);
        KEYCODE_CONVERSION.put(107, Keys.K);
        KEYCODE_CONVERSION.put(108, Keys.L);
        KEYCODE_CONVERSION.put(109, Keys.M);
        KEYCODE_CONVERSION.put(110, Keys.N);
        KEYCODE_CONVERSION.put(111, Keys.O);
        KEYCODE_CONVERSION.put(112, Keys.P);
        KEYCODE_CONVERSION.put(113, Keys.Q);
        KEYCODE_CONVERSION.put(114, Keys.R);
        KEYCODE_CONVERSION.put(115, Keys.S);
        KEYCODE_CONVERSION.put(116, Keys.T);
        KEYCODE_CONVERSION.put(117, Keys.U);
        KEYCODE_CONVERSION.put(118, Keys.V);
        KEYCODE_CONVERSION.put(119, Keys.W);
        KEYCODE_CONVERSION.put(120, Keys.X);
        KEYCODE_CONVERSION.put(121, Keys.Y);
        KEYCODE_CONVERSION.put(122, Keys.Z);
        KEYCODE_CONVERSION.put(8, Keys.BACK_SPACE);
        KEYCODE_CONVERSION.put(32, Keys.SPACE);
        KEYCODE_CONVERSION.put(13, Keys.ENTER);
        KEYCODE_CONVERSION.put(16777303, Keys.PRINTSCREEN);
        KEYCODE_CONVERSION.put(0x1000055, Keys.PAUSE);
        KEYCODE_CONVERSION.put(16777300, Keys.SCROLL_LOCK);
        KEYCODE_CONVERSION.put(131072, Keys.LEFT_SHIFT);
        KEYCODE_CONVERSION.put(262144, Keys.LEFT_CONTROL);
        KEYCODE_CONVERSION.put(65536, Keys.ALT);
        KEYCODE_CONVERSION.put(16777298, Keys.CAPS_LOCK);
        KEYCODE_CONVERSION.put(0x1000009, Keys.INSERT);
        KEYCODE_CONVERSION.put(0x1000008, Keys.END);
        KEYCODE_CONVERSION.put(0x1000007, Keys.HOME);
        KEYCODE_CONVERSION.put(0x1000005, Keys.PAGE_UP);
        KEYCODE_CONVERSION.put(0x1000006, Keys.PAGE_DOWN);
        KEYCODE_CONVERSION.put(0x1000004, Keys.RIGHT);
        KEYCODE_CONVERSION.put(0x1000003, Keys.LEFT);
        KEYCODE_CONVERSION.put(0x1000001, Keys.UP);
        KEYCODE_CONVERSION.put(0x1000002, Keys.DOWN);
        KEYCODE_CONVERSION.put(16777299, Keys.NUM_LOCK);
        KEYCODE_CONVERSION.put(16777263, Keys.NUMPAD_DIVIDE);
        KEYCODE_CONVERSION.put(16777258, Keys.NUMPAD_MULTIPLY);
        KEYCODE_CONVERSION.put(16777261, Keys.NUMPAD_SUBTRACT);
        KEYCODE_CONVERSION.put(16777259, Keys.NUMPAD_ADD);
        KEYCODE_CONVERSION.put(0x1000050, Keys.NUMPAD_ENTER);
        KEYCODE_CONVERSION.put(16777262, Keys.NUMPAD_DECIMAL);
        KEYCODE_CONVERSION.put(0x1000030, Keys.NUMPAD0);
        KEYCODE_CONVERSION.put(0x1000031, Keys.NUMPAD1);
        KEYCODE_CONVERSION.put(16777266, Keys.NUMPAD2);
        KEYCODE_CONVERSION.put(0x1000033, Keys.NUMPAD3);
        KEYCODE_CONVERSION.put(16777268, Keys.NUMPAD4);
        KEYCODE_CONVERSION.put(16777269, Keys.NUMPAD5);
        KEYCODE_CONVERSION.put(16777270, Keys.NUMPAD6);
        KEYCODE_CONVERSION.put(16777271, Keys.NUMPAD7);
        KEYCODE_CONVERSION.put(16777272, Keys.NUMPAD8);
        KEYCODE_CONVERSION.put(16777273, Keys.NUMPAD9);
    }

    public static Key convertKey(KeyEvent ev) {
        Key result = KEYCODE_CONVERSION.get(ev.keyCode);
        if (result == null) {
            result = CHAR_CONVERSION.get(Character.valueOf(Character.toLowerCase(ev.character)));
        }
        return result;
    }

    protected boolean hasKeyStateChanged(Key key, boolean keyState) {
        return true;
    }

    public void consumePendingEvents(InputSystem is, EventQueue eventQueue, long nanoTime) throws InputSystemException {
    }

    public void collectEvents(InputSystem is, EventQueue eventQueue, long nanoTime) throws InputSystemException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void notifyStatesManagersFromQueue(InputSystem is, EventQueue eventQueue, long nanoTime) {
        if (eventQueue.getNumEvents() == 0) {
            return;
        }
        Object object = EventQueue.LOCK;
        synchronized (object) {
            int i = 0;
            while (i < eventQueue.getNumEvents()) {
                InputEvent event = eventQueue.getEvent(i);
                if (event.getType() == InputEvent.Type.KEYBOARD_EVENT) {
                    KeyboardEvent kbEvent = (KeyboardEvent)event;
                    switch (kbEvent.getSubType()) {
                        case PRESSED: {
                            is.notifyInputStatesManagers(this, kbEvent.getComponent(), 1, 1, nanoTime);
                            break;
                        }
                        case RELEASED: {
                            is.notifyInputStatesManagers(this, kbEvent.getComponent(), 0, -1, nanoTime);
                        }
                    }
                }
                ++i;
            }
        }
    }

    public void update(InputSystem is, EventQueue eventQueue, long nanoTime) throws InputSystemException {
        try {
            this.notifyStatesManagersFromQueue(is, eventQueue, nanoTime);
            this.getEventQueue().dequeueAndFire(is, InputEvent.Type.KEYBOARD_EVENT);
        }
        catch (Throwable t) {
            if (t instanceof InputSystemException) {
                throw (InputSystemException)t;
            }
            if (t instanceof Error) {
                throw (Error)t;
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new InputSystemException(t);
        }
        this.lastGameTimeDelta = System.nanoTime() - nanoTime;
    }

    public void destroyImpl() throws InputSystemException {
    }

    protected SWTKeyboard(KeyboardFactory factory, InputSourceWindow sourceWindow, EventQueue eventQueue) throws InputSystemException {
        super(factory, sourceWindow, eventQueue, "Primary Keyboard");
        Arrays.fill(this.lastPressedTimes, -1L);
        this.lastReleasedTimes = new long[Keys.getNumKeys()];
        System.arraycopy(this.lastPressedTimes, 0, this.lastReleasedTimes, 0, this.lastPressedTimes.length);
        try {
            Control control = (Control)sourceWindow.getDrawable();
            control.addKeyListener(new KeyListener(){

                public void keyPressed(KeyEvent _e) {
                    Key key = SWTKeyboard.convertKey(_e);
                    int keyIndex = key.getKeyCode() - 1;
                    long when = System.nanoTime() - SWTKeyboard.this.lastGameTimeDelta;
                    if (key != null) {
                        int modifierMask = SWTKeyboard.this.applyModifier(key, true);
                        long lastWhen = SWTKeyboard.this.lastPressedTimes[keyIndex];
                        ((SWTKeyboard)SWTKeyboard.this).lastPressedTimes[keyIndex] = when;
                        KeyPressedEvent e = SWTKeyboard.this.prepareKeyPressedEvent(key, modifierMask, when, lastWhen);
                        if (e != null) {
                            SWTKeyboard.this.getEventQueue().enqueue(e);
                        }
                        if (_e.character != '\u0000') {
                            KeyTypedEvent kte = SWTKeyboard.this.prepareKeyTypedEvent(_e.character, modifierMask, when, lastWhen);
                            if (e != null) {
                                SWTKeyboard.this.getEventQueue().enqueue(kte);
                            }
                        }
                    }
                }

                public void keyReleased(KeyEvent _e) {
                    Key key = SWTKeyboard.convertKey(_e);
                    int keyIndex = key.getKeyCode() - 1;
                    long when = System.nanoTime() - SWTKeyboard.this.lastGameTimeDelta;
                    if (key != null) {
                        int modifierMask = SWTKeyboard.this.applyModifier(key, false);
                        long lastWhen = SWTKeyboard.this.lastReleasedTimes[keyIndex];
                        ((SWTKeyboard)SWTKeyboard.this).lastReleasedTimes[keyIndex] = when;
                        KeyReleasedEvent e = SWTKeyboard.this.prepareKeyReleasedEvent(key, modifierMask, when, lastWhen);
                        if (e != null) {
                            SWTKeyboard.this.getEventQueue().enqueue(e);
                        }
                    }
                }
            });
        }
        catch (Throwable e) {
            throw new InputSystemException(e);
        }
    }
}

