/*
 * Decompiled with CFR 0.152.
 */
package org.jagatoo.input.managers;

import java.util.ArrayList;
import org.jagatoo.input.devices.Mouse;
import org.jagatoo.input.events.MouseEventPool;
import org.jagatoo.input.events.MouseStoppedEvent;
import org.jagatoo.input.listeners.MouseStopListener;

public class MouseStopManager {
    private static final long LAST_MOVED_RESET_TIME = 9223371936854775807L;
    private final ArrayList<MouseStopListener> listeners = new ArrayList();
    private long[] stopDelays = null;
    private long[] lastMovedTimes = null;
    private int numListeners = 0;
    private long lastWhen_stopped = -1L;

    public void addMouseStopListener(MouseStopListener l) {
        if (!this.listeners.contains(l)) {
            this.listeners.add(l);
            if (this.stopDelays == null || this.stopDelays.length == 0) {
                this.stopDelays = new long[]{l.getMouseStopDelay()};
                this.lastMovedTimes = new long[]{9223371936854775807L};
            } else {
                long[] tmp = new long[this.listeners.size()];
                System.arraycopy(this.stopDelays, 0, tmp, 0, this.stopDelays.length);
                tmp[tmp.length - 1] = l.getMouseStopDelay();
                this.stopDelays = tmp;
                tmp = new long[this.listeners.size()];
                System.arraycopy(this.lastMovedTimes, 0, tmp, 0, this.lastMovedTimes.length);
                tmp[tmp.length - 1] = 9223371936854775807L;
                this.lastMovedTimes = tmp;
            }
        }
        this.numListeners = this.listeners.size();
    }

    public void removeMouseStopListener(MouseStopListener l) {
        int index = this.listeners.indexOf(l);
        if (index >= 0) {
            this.listeners.remove(index);
            if (this.listeners.size() == 0) {
                this.stopDelays = null;
                this.lastMovedTimes = null;
            } else {
                long[] tmp = new long[this.listeners.size()];
                System.arraycopy(this.stopDelays, 0, tmp, 0, index);
                System.arraycopy(this.stopDelays, index + 1, tmp, index, this.stopDelays.length - index - 1);
                tmp[tmp.length - 1] = l.getMouseStopDelay();
                this.stopDelays = tmp;
                tmp = new long[this.listeners.size()];
                System.arraycopy(this.lastMovedTimes, 0, tmp, 0, index);
                System.arraycopy(this.lastMovedTimes, index + 1, tmp, index, this.lastMovedTimes.length - index - 1);
                tmp[tmp.length - 1] = 9223371936854775807L;
                this.lastMovedTimes = tmp;
            }
        }
        this.numListeners = this.listeners.size();
    }

    public final boolean hasMouseListener() {
        return this.numListeners > 0;
    }

    private final MouseStoppedEvent prepareMouseStoppedEvent(Mouse mouse, long when) {
        if (!mouse.isEnabled() || this.numListeners == 0) {
            return null;
        }
        MouseStoppedEvent e = MouseEventPool.allocStopped(mouse, mouse.getCurrentX(), mouse.getCurrentY(), when, this.lastWhen_stopped);
        this.lastWhen_stopped = when;
        return e;
    }

    public final void fireOnMouseStopped(MouseStoppedEvent e, MouseStopListener listener, boolean consumeEvent) {
        listener.onMouseStopped(e, e.getX(), e.getY());
        if (consumeEvent) {
            MouseEventPool.freeStopped(e);
        }
    }

    public final void fireOnMouseStopped(Mouse mouse, MouseStoppedEvent e, boolean consumeEvent) {
        if (!mouse.isEnabled() || this.numListeners == 0) {
            if (consumeEvent) {
                MouseEventPool.freeStopped(e);
            }
            return;
        }
        int i = 0;
        while (i < this.listeners.size()) {
            this.listeners.get(i).onMouseStopped(e, e.getX(), e.getY());
            ++i;
        }
        if (consumeEvent) {
            MouseEventPool.freeStopped(e);
        }
    }

    public final void notifyMouseMoved(Mouse mouse, long nanoTime) {
        int i = 0;
        while (i < this.numListeners) {
            this.lastMovedTimes[i] = nanoTime;
            ++i;
        }
    }

    public final void update(Mouse mouse, long nanoTime) {
        long t = nanoTime;
        MouseStoppedEvent e = null;
        int i = 0;
        while (i < this.numListeners) {
            if (t >= this.lastMovedTimes[i] + this.stopDelays[i]) {
                this.lastMovedTimes[i] = 9223371936854775807L;
                if (e == null) {
                    e = this.prepareMouseStoppedEvent(mouse, nanoTime);
                }
                this.fireOnMouseStopped(e, this.listeners.get(i), false);
            }
            ++i;
        }
        if (e != null) {
            MouseEventPool.freeStopped(e);
        }
    }
}

