/*
 * Decompiled with CFR 0.152.
 */
package org.jagatoo.input.managers;

import java.util.ArrayList;
import java.util.HashMap;
import org.jagatoo.input.InputSystem;
import org.jagatoo.input.devices.components.DeviceComponent;
import org.jagatoo.input.devices.components.MouseWheel;
import org.jagatoo.input.events.InputEvent;
import org.jagatoo.input.listeners.InputStateListener;
import org.jagatoo.input.managers.SimpleInputActionListener;

public class SimpleInputActionManager
implements InputStateListener {
    private static SimpleInputActionManager instance = null;
    private final HashMap<DeviceComponent, Object> actionMap = new HashMap();
    private final ArrayList<SimpleInputActionListener> listeners = new ArrayList();

    public static final SimpleInputActionManager getInstance() {
        if (instance == null) {
            instance = new SimpleInputActionManager();
        }
        return instance;
    }

    public void addActionListener(SimpleInputActionListener l) {
        if (this.listeners.contains(l)) {
            return;
        }
        this.listeners.add(l);
    }

    public void removeActionListener(SimpleInputActionListener l) {
        this.listeners.remove(l);
    }

    public final int getNumBoundActions() {
        return this.actionMap.size();
    }

    public void bindAction(DeviceComponent comp, Object action) {
        if (comp == null) {
            throw new IllegalArgumentException("comp must not be null");
        }
        if (action == null) {
            throw new IllegalArgumentException("action must not be null");
        }
        this.actionMap.put(comp, action);
        if (this == instance && this.getNumBoundActions() == 1) {
            InputSystem.getInstance().addInputStateListener(this);
        }
    }

    public void unbindAction(DeviceComponent comp) {
        if (comp == null) {
            throw new IllegalArgumentException("comp must not be null");
        }
        this.actionMap.remove(comp);
        if (this == instance && this.getNumBoundActions() == 0) {
            InputSystem.getInstance().removeInputStateListener(this);
        }
    }

    public void unbindAction(Object action) {
        if (action == null) {
            throw new IllegalArgumentException("action must not be null");
        }
        DeviceComponent mappedComp = null;
        for (DeviceComponent comp : this.actionMap.keySet()) {
            Object mappedAction = this.actionMap.get(comp);
            if (mappedAction == null) continue;
            mappedComp = comp;
            break;
        }
        if (mappedComp != null) {
            this.unbindAction(mappedComp);
        }
    }

    public final Object getBoundAction(DeviceComponent comp) {
        return this.actionMap.get(comp);
    }

    protected void notifyListeners(Object action, int delta, int state) {
        if (action == null) {
            return;
        }
        int i = 0;
        while (i < this.listeners.size()) {
            this.listeners.get(i).onActionInvoked(action, delta, state);
            ++i;
        }
    }

    private final boolean checkMouseWheel(DeviceComponent comp, int delta, int state) {
        MouseWheel wheel = (MouseWheel)comp;
        Object action = this.getBoundAction(MouseWheel.GLOBAL_WHEEL);
        if (action != null) {
            this.notifyListeners(action, delta, state);
            return true;
        }
        if (delta > 0) {
            action = this.getBoundAction(MouseWheel.GLOBAL_WHEEL.getUp());
            if (action == null) {
                action = this.getBoundAction(wheel.getUp());
            }
            if (action != null) {
                this.notifyListeners(action, 1, 1);
                return true;
            }
        } else {
            action = this.getBoundAction(MouseWheel.GLOBAL_WHEEL.getDown());
            if (action == null) {
                action = this.getBoundAction(wheel.getDown());
            }
            if (action != null) {
                this.notifyListeners(action, 1, 1);
                return true;
            }
        }
        return false;
    }

    public void onInputStateChanged(InputEvent e, DeviceComponent comp, int delta, int state) {
        if (comp == null) {
            return;
        }
        Object action = this.getBoundAction(comp);
        if (action == null && comp != null && comp.getType() == DeviceComponent.Type.MOUSE_WHEEL && this.checkMouseWheel(comp, delta, state)) {
            return;
        }
        if (action != null) {
            this.notifyListeners(action, delta, state);
        }
    }
}

