/*
 * Decompiled with CFR 0.152.
 */
package org.jagatoo.loaders.models.ase;

import java.util.HashMap;
import java.util.Map;
import org.jagatoo.loaders.models.ase.AseFileLine;
import org.jagatoo.loaders.models.ase.AseGeom;
import org.jagatoo.loaders.models.ase.AseHelper;
import org.jagatoo.loaders.models.ase.AseReader;
import org.jagatoo.logging.JAGTLog;

public class AseGroup
extends AseGeom {
    public AseHelper helper = null;
    public Map<String, AseGeom> objects = new HashMap<String, AseGeom>();

    public void parse(AseReader in) {
        AseFileLine line;
        JAGTLog.debug("  parsing " + this.getClass().getName());
        boolean inBlock = in.blockStart;
        while ((line = in.readAseLine()) != null) {
            if (line.getType() == AseFileLine.Type.GEOMETRY_OBJECT) {
                JAGTLog.debug("Geom Object Starting");
                AseGeom a = new AseGeom();
                a.parse(in);
                this.objects.put(a.name, a);
                JAGTLog.debug("Geom Object " + a.name + " parsed");
            } else if (line.getType() == AseFileLine.Type.GROUP) {
                AseGroup g = new AseGroup();
                g.parse(in);
                this.objects.put(g.name, g);
                JAGTLog.debug("Geom Object " + g.name + " parsed");
            } else if (line.getType() == AseFileLine.Type.HELPER_OBJECT) {
                JAGTLog.debug("Group Helper Object Starting");
                AseHelper h = new AseHelper();
                h.parse(in);
                this.helper = h;
                JAGTLog.debug("Helper Object " + h.name + " parsed");
                this.name = h.name;
                this.transform = h.transform;
            } else if (in.blockStart) {
                this.trashBlock(in);
            }
            if (inBlock && in.blockEnd) break;
        }
        if (inBlock) {
            in.blockEnd = false;
        }
    }
}

