/*
 * Decompiled with CFR 0.152.
 */
package org.jagatoo.loaders.models.ase;

import org.jagatoo.loaders.models.ase.AseFileLine;
import org.jagatoo.loaders.models.ase.AseNode;
import org.jagatoo.loaders.models.ase.AseReader;
import org.jagatoo.logging.JAGTLog;

public class AseMesh
extends AseNode {
    private static final int MAX_MATERIALS = 100;
    public int numVertices = 0;
    public int numFaces = 0;
    public int numTexVertices = 0;
    public int numTexFaces = 0;
    public float[] vertices = null;
    public int[] faces = null;
    public float[] texVertices = null;
    public int[] texFaces = null;
    public float[] normals = null;
    public int[] normalsIndices = null;
    public float[] faceNormals = null;
    public int[] faceNormalsIndices = null;
    public int[] faceMat = null;
    public int[] totals = null;
    public boolean convertMeshCoordinates = true;

    public void parseVertexList(AseReader in) {
        AseFileLine line;
        this.vertices = new float[this.numVertices * 3];
        int n = 0;
        while ((line = in.readAseLine()) != null) {
            if (in.blockEnd) break;
            if (line.getType() != AseFileLine.Type.MESH_VERTEX) {
                throw new Error("Expecting *MESH_VERTEX at line " + line.getNumber() + " instead of " + line.getKey());
            }
            this.vertices[n++] = Float.parseFloat(line.getParameter(1));
            this.vertices[n++] = Float.parseFloat(line.getParameter(2));
            this.vertices[n++] = Float.parseFloat(line.getParameter(3));
        }
        if (n / 3 != this.numVertices) {
            throw new Error("Vertex list does not match declared amount : " + in.getLastLineNumber());
        }
        in.blockEnd = false;
    }

    public void parseFaceList(AseReader in) {
        AseFileLine line;
        this.faces = new int[this.numFaces * 3];
        this.faceMat = new int[this.numFaces];
        this.totals = new int[100];
        int n = 0;
        int f = 0;
        while ((line = in.readAseLine()) != null) {
            if (in.blockEnd) break;
            if (line.getType() != AseFileLine.Type.MESH_FACE) {
                throw new Error("Expecting *MESH_FACE at line " + line.getNumber());
            }
            this.faces[n++] = Integer.parseInt(line.getParameter(2));
            this.faces[n++] = Integer.parseInt(line.getParameter(4));
            this.faces[n++] = Integer.parseInt(line.getParameter(6));
            int matID = 0;
            int i = 0;
            while (i < line.getParametersCount()) {
                if (line.getParameter(i).equalsIgnoreCase("*MESH_MTLID")) {
                    matID = Integer.parseInt(line.getParameter(i + 1));
                    break;
                }
                ++i;
            }
            this.faceMat[f++] = matID;
            if (matID >= 100) {
                throw new Error("Invalid MatID " + matID + " on line " + line.getNumber());
            }
            int n2 = matID;
            this.totals[n2] = this.totals[n2] + 1;
        }
        if (n / 3 != this.numFaces) {
            throw new Error("Face list does not match declared amount : " + in.getLastLineNumber());
        }
        in.blockEnd = false;
        int i = 0;
        while (i < 10) {
            if (this.totals[i] != 0) {
                JAGTLog.debug(String.valueOf(this.totals[i]) + " faces use material " + i);
            }
            ++i;
        }
    }

    public void parseTexVertexList(AseReader in) {
        AseFileLine line;
        this.texVertices = new float[this.numTexVertices * 2];
        int n = 0;
        while ((line = in.readAseLine()) != null) {
            if (in.blockEnd) break;
            if (line.getType() != AseFileLine.Type.MESH_TEX_VERT) {
                throw new Error("Expecting *MESH_FACE at line " + line.getNumber());
            }
            this.texVertices[n++] = Float.parseFloat(line.getParameter(1));
            this.texVertices[n++] = Float.parseFloat(line.getParameter(2));
        }
        if (n / 2 != this.numTexVertices) {
            throw new Error("Texture vertex list does not match declared amount : " + in.getLastLineNumber());
        }
        in.blockEnd = false;
    }

    public void parseTexFaceList(AseReader in) {
        AseFileLine line;
        if (this.numTexFaces != this.numFaces) {
            throw new Error("Number of tex faces does not equal number of faces " + in.getLastLineNumber());
        }
        this.texFaces = new int[this.numTexFaces * 3];
        int n = 0;
        while ((line = in.readAseLine()) != null) {
            if (in.blockEnd) break;
            if (line.getType() != AseFileLine.Type.MESH_TEX_FACE) {
                throw new Error("Expecting *MESH_TFACE at line " + line.getNumber());
            }
            this.texFaces[n++] = Integer.parseInt(line.getParameter(1));
            this.texFaces[n++] = Integer.parseInt(line.getParameter(2));
            this.texFaces[n++] = Integer.parseInt(line.getParameter(3));
        }
        if (n / 3 != this.numTexFaces) {
            throw new Error("tex face list does not match declared amount : " + in.getLastLineNumber());
        }
        in.blockEnd = false;
    }

    public void parseNormal(AseReader in, int n) {
        AseFileLine line = in.readAseLine();
        if (line.getType() != AseFileLine.Type.MESH_VERTEXNORMAL) {
            throw new Error("Expecting *MESH_VERTEXNORMAL at line " + line.getNumber());
        }
        this.normalsIndices[n / 3] = Integer.parseInt(line.getParameter(0));
        this.normals[n++] = Float.parseFloat(line.getParameter(1));
        this.normals[n++] = Float.parseFloat(line.getParameter(2));
        this.normals[n++] = Float.parseFloat(line.getParameter(3));
    }

    public void parseNormalsList(AseReader in) {
        AseFileLine line;
        this.normals = new float[this.numFaces * 9];
        this.normalsIndices = new int[this.numFaces * 3];
        this.faceNormals = new float[this.numFaces * 3];
        this.faceNormalsIndices = new int[this.numFaces];
        int n = 0;
        while ((line = in.readAseLine()) != null) {
            if (in.blockEnd) break;
            if (line.getType() != AseFileLine.Type.MESH_FACENORMAL) {
                throw new Error("Expecting *MESH_FACENORMAL at line " + line.getNumber());
            }
            this.faceNormalsIndices[n / 9] = Integer.parseInt(line.getParameter(0));
            this.faceNormals[n / 3] = Float.parseFloat(line.getParameter(1));
            this.faceNormals[n / 3 + 1] = Float.parseFloat(line.getParameter(2));
            this.faceNormals[n / 3 + 2] = Float.parseFloat(line.getParameter(3));
            this.parseNormal(in, n);
            this.parseNormal(in, n += 3);
            this.parseNormal(in, n += 3);
            n += 3;
        }
        if (n / 9 != this.numFaces) {
            throw new Error("normal list does not match declared amount : " + in.getLastLineNumber());
        }
        in.blockEnd = false;
    }

    public void parse(AseReader in) {
        AseFileLine line;
        this.convertMeshCoordinates = in.convertMeshCoordinates;
        while ((line = in.readAseLine()) != null) {
            if (!this.parseProperty(in, line)) {
                if (line.getType() == AseFileLine.Type.MESH_VERTEX_LIST) {
                    this.parseVertexList(in);
                }
                if (line.getType() == AseFileLine.Type.MESH_FACE_LIST) {
                    this.parseFaceList(in);
                }
                if (line.getType() == AseFileLine.Type.MESH_TEX_VERT_LIST) {
                    this.parseTexVertexList(in);
                }
                if (line.getType() == AseFileLine.Type.MESH_TEX_FACE_LIST) {
                    this.parseTexFaceList(in);
                }
                if (line.getType() == AseFileLine.Type.MESH_NORMALS) {
                    this.parseNormalsList(in);
                }
                if (in.blockStart) {
                    this.trashBlock(in);
                }
            }
            if (in.blockEnd) break;
        }
        in.blockEnd = false;
    }

    public AseMesh() {
        this.properties.put("*MESH_NUMVERTEX", "numVertices");
        this.properties.put("*MESH_NUMFACES", "numFaces");
        this.properties.put("*MESH_NUMTVFACES", "numTexFaces");
        this.properties.put("*MESH_NUMTVERTEX", "numTexVertices");
    }
}

