/*
 * Decompiled with CFR 0.152.
 */
package org.jagatoo.loaders.models.ase;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import org.jagatoo.loaders.models.ase.AseFileLine;
import org.jagatoo.loaders.models.ase.AseReader;
import org.jagatoo.logging.JAGTLog;
import org.openmali.vecmath2.Colorf;
import org.openmali.vecmath2.Vector3f;

public class AseNode {
    protected static final Boolean debug = null;
    protected Map<String, String> properties = new HashMap<String, String>();

    public boolean parseProperty(AseReader in, AseFileLine line) {
        String property = this.properties.get(line.getKey());
        if (property != null) {
            try {
                Field f = this.getClass().getDeclaredField(property);
                String type = f.getType().getName();
                if (type.equals("float")) {
                    f.setFloat(this, Float.parseFloat(line.getParameter(0)));
                    JAGTLog.debug("  Setting " + line.getKey() + "/" + f.getName() + " to " + line.getParameter(0));
                }
                if (type.equals("int")) {
                    f.setInt(this, Integer.parseInt(line.getParameter(0)));
                    JAGTLog.debug("  Setting " + line.getKey() + "/" + f.getName() + " to " + line.getParameter(0));
                }
                if (type.equals("boolean")) {
                    f.setBoolean(this, Integer.parseInt(line.getParameter(0)) == 1);
                    JAGTLog.debug("  Setting " + line.getKey() + "/" + f.getName() + " to " + f.getBoolean(this));
                }
                if (type.equals("org.openmali.vecmath2.Colorf")) {
                    Colorf c = (Colorf)f.get(this);
                    c.setRed(Float.parseFloat(line.getParameter(0)));
                    c.setGreen(Float.parseFloat(line.getParameter(1)));
                    c.setBlue(Float.parseFloat(line.getParameter(2)));
                    JAGTLog.debug("  Setting " + line.getKey() + "/" + f.getName() + " to " + c);
                }
                if (type.equals("org.openmali.vecmath2.Vector3f")) {
                    Vector3f v = (Vector3f)f.get(this);
                    v.setX(Float.parseFloat(line.getParameter(0)));
                    v.setY(Float.parseFloat(line.getParameter(1)));
                    v.setZ(Float.parseFloat(line.getParameter(2)));
                    JAGTLog.debug("  Setting " + line.getKey() + "/" + f.getName() + " to " + v);
                }
                if (type.equals("java.lang.String")) {
                    f.set(this, line.getParameter(0));
                    JAGTLog.debug("  Setting " + line.getKey() + "/" + f.getName() + " to " + line.getParameter(0));
                }
                if (AseNode.class.isAssignableFrom(f.getType())) {
                    JAGTLog.debug("  AseNode detected");
                    AseNode node = (AseNode)f.get(this);
                    node.parse(in);
                }
                JAGTLog.debug("  Can't determine type of matched " + line.getKey() + ", field " + property);
                return false;
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException ee) {
                ee.printStackTrace();
            }
        } else {
            return false;
        }
        return true;
    }

    public void trashBlock(AseReader in) {
        if (in.blockStart) {
            JAGTLog.debug("  Trashing block ");
            int numOpen = 1;
            while (in.readAseLine() != null) {
                if (in.blockStart) {
                    ++numOpen;
                } else if (in.blockEnd) {
                    --numOpen;
                }
                if (numOpen <= 0) break;
            }
            in.blockEnd = false;
        }
    }

    public void parse(AseReader in) {
        AseFileLine line;
        JAGTLog.debug("  parsing " + this.getClass().getName());
        boolean inBlock = in.blockStart;
        while ((line = in.readAseLine()) != null) {
            if (!this.parseProperty(in, line) && in.blockStart) {
                this.trashBlock(in);
            }
            if (inBlock && in.blockEnd) break;
        }
        if (inBlock) {
            in.blockEnd = false;
        }
    }
}

