/*
 * Decompiled with CFR 0.152.
 */
package org.jagatoo.loaders.models.ase;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.Reader;
import java.net.URL;
import org.jagatoo.datatypes.NamedObject;
import org.jagatoo.loaders.models._util.AnimationFactory;
import org.jagatoo.loaders.models._util.AppearanceFactory;
import org.jagatoo.loaders.models._util.GeometryFactory;
import org.jagatoo.loaders.models._util.NodeFactory;
import org.jagatoo.loaders.models._util.SpecialItemsHandler;
import org.jagatoo.loaders.models.ase.AseConverter;
import org.jagatoo.loaders.models.ase.AseFile;
import org.jagatoo.loaders.models.ase.AseFileLine;
import org.jagatoo.util.errorhandling.IncorrectFormatException;
import org.jagatoo.util.errorhandling.ParsingException;

public class AseReader {
    private LineNumberReader lnReader;
    private int charPos;
    private AseFileLine afLine = new AseFileLine();
    boolean blockEnd;
    boolean blockStart;
    private StringBuffer wordBuff;
    private int lineNo = 0;
    boolean convertMeshCoordinates = true;

    public AseReader(Reader in) {
        this(in, true);
    }

    public AseReader(Reader in, boolean convertMeshCoordinates) {
        this.lnReader = new LineNumberReader(in instanceof BufferedReader ? in : new BufferedReader(in));
        this.wordBuff = new StringBuffer(100);
        this.convertMeshCoordinates = convertMeshCoordinates;
    }

    public int getLastLineNumber() {
        return this.lineNo;
    }

    private String parseWord(String line) {
        this.wordBuff.setLength(0);
        int n = line.length();
        boolean inString = false;
        while (this.charPos < n) {
            char c;
            if ((c = line.charAt(this.charPos++)) == ' ' || c == '\t') {
                if (inString) {
                    this.wordBuff.append(c);
                    continue;
                }
                if (this.wordBuff.length() <= 0) continue;
                return this.wordBuff.toString();
            }
            if (c == '\"') {
                if (this.wordBuff.length() > 0 || inString) {
                    return this.wordBuff.toString();
                }
                inString = true;
                continue;
            }
            this.wordBuff.append(c);
        }
        if (this.wordBuff.length() == 0) {
            return null;
        }
        return this.wordBuff.toString();
    }

    private AseFileLine parseLine(String line) {
        String word;
        this.afLine.reset();
        this.afLine.setNumber(this.lineNo);
        this.charPos = 0;
        this.blockStart = false;
        this.blockEnd = false;
        line = line.trim();
        while ((word = this.parseWord(line)) != null) {
            if (this.afLine.getKey().length() == 0) {
                this.afLine.setKey(word);
            } else {
                this.afLine.addParameter(word);
            }
            this.blockStart = word.indexOf("{") >= 0;
            boolean bl = this.blockEnd = word.indexOf("}") >= 0;
        }
        return this.afLine;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public AseFileLine readAseLine() {
        try {
            String line;
            do {
                line = this.lnReader.readLine();
                ++this.lineNo;
                if (line != null) continue;
                return null;
            } while (line.length() <= 0);
            return this.parseLine(line);
        }
        catch (IOException e) {
            return null;
        }
    }

    public void close() throws IOException {
        this.lnReader.close();
    }

    public static final void load(InputStream in, URL baseURL, AppearanceFactory appFactory, GeometryFactory geomFactory, boolean convertZup2Yup, float scale, NodeFactory nodeFactory, AnimationFactory animFactory, SpecialItemsHandler siHandler, NamedObject rootGroup) throws IOException, IncorrectFormatException, ParsingException {
        AseReader aseReader = new AseReader(new BufferedReader(new InputStreamReader(in)));
        AseFile aseFile = new AseFile();
        aseFile.parse(aseReader);
        AseConverter.getTransformGroupTree(aseFile, appFactory, baseURL, geomFactory, convertZup2Yup, scale, nodeFactory, siHandler, rootGroup);
    }
}

