/*
 * Decompiled with CFR 0.152.
 */
package org.jagatoo.loaders.models.bsp;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.BitSet;
import java.util.HashMap;
import org.jagatoo.datatypes.NamedObject;
import org.jagatoo.loaders.models._util.AppearanceFactory;
import org.jagatoo.loaders.models._util.GroupType;
import org.jagatoo.loaders.models._util.NodeFactory;
import org.jagatoo.loaders.models._util.SpecialItemsHandler;
import org.jagatoo.loaders.models.bsp.BSPClusterManager;
import org.jagatoo.loaders.models.bsp.BSPEntitiesParser;
import org.jagatoo.loaders.models.bsp.BSPScenePrototype;
import org.jagatoo.loaders.models.bsp.BSPTextureAnimator;
import org.jagatoo.loaders.models.bsp.lumps.BSPFace;
import org.jagatoo.loaders.models.bsp.lumps.BSPModel;
import org.jagatoo.loaders.textures.AbstractTexture;
import org.jagatoo.opengl.enums.BlendFunction;
import org.jagatoo.opengl.enums.BlendMode;
import org.jagatoo.opengl.enums.DrawMode;
import org.jagatoo.opengl.enums.FaceCullMode;
import org.jagatoo.opengl.enums.ShadeModel;
import org.jagatoo.opengl.enums.TextureCombineFunction;
import org.jagatoo.opengl.enums.TextureCombineMode;
import org.jagatoo.opengl.enums.TextureCombineSource;
import org.jagatoo.opengl.enums.TextureMode;
import org.openmali.FastMath;
import org.openmali.spatial.PlaneIndicator;
import org.openmali.spatial.bounds.BoundingBox;
import org.openmali.spatial.bounds.BoundsType;
import org.openmali.vecmath2.Matrix4f;
import org.openmali.vecmath2.util.MatrixUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BSPConverter {
    private static NamedObject texAttrRepl = null;
    private static NamedObject texAttrModu = null;
    private static NamedObject texAttrComb = null;
    private static NamedObject transAttrSimple = null;
    private static NamedObject transAttrFlames = null;
    private static NamedObject mainMat = null;
    private static NamedObject mainPA = null;
    private static NamedObject mainCA = null;

    private static void initAppearanceComponents(AppearanceFactory appFactory) {
        if (texAttrRepl != null) {
            return;
        }
        texAttrRepl = appFactory.createTextureAttributes("");
        appFactory.setTextureAttribsTextureMode(texAttrRepl, TextureMode.REPLACE);
        texAttrModu = appFactory.createTextureAttributes("");
        appFactory.setTextureAttribsTextureMode(texAttrModu, TextureMode.MODULATE);
        texAttrComb = appFactory.createTextureAttributes("");
        appFactory.setTextureAttribsTextureMode(texAttrComb, TextureMode.COMBINE);
        appFactory.setTextureAttribsCombineRGBMode(texAttrComb, TextureCombineMode.MODULATE);
        appFactory.setTextureAttribsCombineRGBSource(texAttrComb, 0, TextureCombineSource.PREVIOUS_TEXTURE_UNIT);
        appFactory.setTextureAttribsCombineRGBFunction(texAttrComb, 0, TextureCombineFunction.SRC_COLOR);
        appFactory.setTextureAttribsCombineRGBSource(texAttrComb, 1, TextureCombineSource.TEXTURE_COLOR);
        appFactory.setTextureAttribsCombineRGBFunction(texAttrComb, 1, TextureCombineFunction.SRC_COLOR);
        appFactory.setTextureAttribsCombineRGBScale(texAttrComb, 2);
        transAttrSimple = appFactory.createTransparencyAttributes("");
        appFactory.setTransparencyAttribsBlendMode(transAttrSimple, BlendMode.BLENDED);
        appFactory.setTransparencyAttribsTransparency(transAttrSimple, 0.0f);
        transAttrFlames = appFactory.createTransparencyAttributes("");
        appFactory.setTransparencyAttribsBlendMode(transAttrFlames, BlendMode.BLENDED);
        appFactory.setTransparencyAttribsTransparency(transAttrFlames, 0.0f);
        appFactory.setTransparencyAttribsSourceBlendFunc(transAttrFlames, BlendFunction.SRC_ALPHA);
        appFactory.setTransparencyAttribsDestBlendFunc(transAttrFlames, BlendFunction.ONE_MINUS_SRC_ALPHA);
        appFactory.setTransparencyAttribsSortingEnabled(transAttrFlames, true);
        mainMat = appFactory.createMaterial("");
        appFactory.setMaterialLightingEnabled(mainMat, false);
        mainPA = appFactory.createPolygonAttributes("");
        appFactory.setPolygonAttribsDrawMode(mainPA, DrawMode.FILL);
        appFactory.setPolygonAttribsFaceCullMode(mainPA, FaceCullMode.FRONT);
        mainCA = appFactory.createColoringAttributes("");
        appFactory.setColoringAttribsColor(mainCA, new float[]{1.0f, 1.0f, 1.0f}, 0, 3);
        appFactory.setColoringAttribsShadeModel(mainCA, ShadeModel.GOURAUD);
    }

    private static NamedObject convertFaceToShape(int sourceBSPVersion, int faceIndex, BSPFace face, NamedObject geometry, AbstractTexture[][] baseTextures, AbstractTexture[] lightMaps, NodeFactory nodeFactory, BoundsType boundsType, AppearanceFactory appFactory, HashMap<String, NamedObject> appCache) {
        boolean isTranslucentTex;
        if (geometry == null) {
            return null;
        }
        String baseTexName = baseTextures[face.textureID][0].getName();
        boolean bl = isTranslucentTex = face.textureID >= 0 && (baseTextures[face.textureID][0].getFormat().hasAlpha() || baseTexName.indexOf("flame") >= 0);
        if (baseTexName.startsWith("{")) {
            isTranslucentTex = true;
        }
        String appKey = face.lightmapID < 0 ? (isTranslucentTex ? "appB-" + face.textureID : "appA-" + face.textureID) : "appC-" + face.textureID + "-" + face.lightmapID;
        NamedObject app = appCache.get(appKey);
        if (app == null) {
            app = appFactory.createAppearance(appKey, 1);
            if (face.textureID >= 0) {
                appFactory.applyTexture(baseTextures[face.textureID][0], 0, app);
            } else {
                appFactory.applyTexture(appFactory.getFallbackTexture(), 0, app);
            }
            if (face.lightmapID < 0) {
                if (isTranslucentTex) {
                    appFactory.applyTextureAttributes(texAttrModu, 0, app);
                    if (sourceBSPVersion == 30) {
                        appFactory.applyTransparancyAttributes(transAttrFlames, app);
                    } else {
                        appFactory.applyTransparancyAttributes(transAttrFlames, app);
                    }
                } else {
                    appFactory.applyTextureAttributes(texAttrRepl, 0, app);
                }
            } else {
                appFactory.applyTexture(lightMaps[face.lightmapID], 1, app);
                appFactory.applyTextureAttributes(texAttrComb, 1, app);
            }
            appFactory.applyPolygonAttributes(mainPA, app);
            appFactory.applyColoringAttributes(mainCA, app);
            appCache.put(appKey, app);
        }
        return nodeFactory.createShape("Shape" + faceIndex, geometry, app, boundsType);
    }

    private static Object[] convertFacesToShapes(int sourceBSPVersion, BSPModel[] models, BSPFace[] faces, NamedObject[][] geometries, AbstractTexture[][] baseTextures, AbstractTexture[] lightMaps, AppearanceFactory appFactory, NodeFactory nodeFactory, NamedObject sceneGroup, GroupType mainGroupType, float worldScale, SpecialItemsHandler siHandler) {
        BoundsType nodeBoundsType;
        NamedObject bspTreeGroup;
        BSPConverter.initAppearanceComponents(appFactory);
        HashMap<String, NamedObject> appCache = new HashMap<String, NamedObject>();
        BitSet faceBitset = new BitSet(models[0].numOfFaces);
        faceBitset.set(0, models[0].numOfFaces - 1);
        BSPModel model0 = models[0];
        BoundingBox m0Bounds = new BoundingBox(model0.min[0] * worldScale, model0.min[2] * worldScale, model0.min[1] * worldScale, model0.max[0] * worldScale, model0.max[2] * worldScale, model0.max[1] * worldScale);
        switch (mainGroupType) {
            case SIMPLE: {
                bspTreeGroup = nodeFactory.createSimpleGroup("BSPMainGroup", BoundsType.SPHERE);
                nodeBoundsType = BoundsType.SPHERE;
                break;
            }
            case BSP_TREE: {
                bspTreeGroup = nodeFactory.createBSPTreeGroup("BSPMainGroup", null, BoundsType.SPHERE);
                nodeBoundsType = BoundsType.SPHERE;
                break;
            }
            case OC_TREE: {
                bspTreeGroup = nodeFactory.createOcTreeGroup("BSPMainGroup", m0Bounds.getCenterX(), m0Bounds.getCenterY(), m0Bounds.getCenterZ(), m0Bounds.getSize().getX(), m0Bounds.getSize().getY(), m0Bounds.getSize().getZ());
                nodeBoundsType = BoundsType.AABB;
                break;
            }
            case QUAD_TREE: {
                bspTreeGroup = nodeFactory.createQuadTreeGroup("BSPMainGroup", m0Bounds.getCenterX(), m0Bounds.getCenterY(), m0Bounds.getCenterZ(), PlaneIndicator.X_Z_PLANE, m0Bounds.getSize().getX(), m0Bounds.getSize().getZ(), m0Bounds.getSize().getY());
                nodeBoundsType = BoundsType.AABB;
                break;
            }
            default: {
                throw new Error("Unsupported main GroupType " + (Object)((Object)mainGroupType));
            }
        }
        siHandler.addSpecialItem(SpecialItemsHandler.SpecialItemType.MAIN_GROUP, bspTreeGroup.getName(), bspTreeGroup);
        boolean skyboxPublished = false;
        int m = 0;
        while (m < models.length) {
            BSPModel model = models[m];
            NamedObject modelGroup = m == 0 ? bspTreeGroup : nodeFactory.createSimpleGroup("BSPModel" + m, nodeBoundsType);
            if (model != null && geometries.length > m && geometries[m] != null) {
                int f = 0;
                while (f < model.numOfFaces) {
                    NamedObject shape;
                    BSPFace face = faces[model.faceIndex + f];
                    String baseTexName = baseTextures[face.textureID][0].getName();
                    if (baseTexName.startsWith("sky")) {
                        shape = nodeFactory.createDummyNode();
                        if (!skyboxPublished) {
                            AbstractTexture[] skyTextures = baseTextures[face.textureID];
                            Object skybox = nodeFactory.createSkyBox(skyTextures[1], skyTextures[2], skyTextures[3], skyTextures[4], skyTextures[5], skyTextures[6]);
                            siHandler.addSpecialItem(SpecialItemsHandler.SpecialItemType.SKYBOX, null, skybox);
                            skyboxPublished = true;
                        }
                    } else if (baseTexName.startsWith("aaatrigger")) {
                        shape = nodeFactory.createDummyNode();
                    } else {
                        shape = BSPConverter.convertFaceToShape(sourceBSPVersion, f, face, geometries[m][f], baseTextures, lightMaps, nodeFactory, nodeBoundsType, appFactory, appCache);
                        if (shape == null) {
                            shape = nodeFactory.createDummyNode();
                        } else {
                            siHandler.addSpecialItem(SpecialItemsHandler.SpecialItemType.SHAPE, shape.getName(), shape);
                            if (baseTexName.startsWith("+")) {
                                NamedObject appearance = nodeFactory.getAppearanceFromShape(shape);
                                BSPTextureAnimator animator = new BSPTextureAnimator(baseTextures[face.textureID], appearance, 0, appFactory, 10.0f);
                                shape = siHandler.createTextureAnimator(animator, shape);
                            }
                        }
                    }
                    nodeFactory.addNodeToGroup(shape, modelGroup);
                    ++f;
                }
                if (m == 0 || model.numOfFaces > 0) {
                    nodeFactory.addNodeToGroup(modelGroup, sceneGroup);
                }
            }
            ++m;
        }
        return new Object[]{bspTreeGroup, faceBitset};
    }

    private static final Matrix4f getTransformFromEntity(BSPEntitiesParser.BSPEntity_Location entLoc, float worldScale) {
        float angleX = FastMath.toRad((float)entLoc.angles.getX());
        float angleY = FastMath.toRad((float)(entLoc.angles.getY() - 90.0f));
        float angleZ = FastMath.toRad((float)entLoc.angles.getZ());
        Matrix4f trans = new Matrix4f();
        trans.setIdentity();
        MatrixUtils.eulerToMatrix4f((float)angleX, (float)angleY, (float)angleZ, (Matrix4f)trans);
        trans.m03(entLoc.origin.getX() * worldScale);
        trans.m13(entLoc.origin.getZ() * worldScale);
        trans.m23(-entLoc.origin.getY() * worldScale);
        return trans;
    }

    private static void convertEntities(BSPEntitiesParser.BSPEntity[] entities, float worldScale, URL baseURL, SpecialItemsHandler siHandler, NodeFactory nodeFactory, NamedObject sceneGroup) {
        if (entities == null) {
            return;
        }
        int i = 0;
        while (i < entities.length) {
            BSPEntitiesParser.BSPEntity_Location entLoc;
            BSPEntitiesParser.BSPEntity entity = entities[i];
            String className2 = entity.className2;
            if (className2.startsWith("info_player_start") || className2.startsWith("info_player_deathmatch")) {
                entLoc = (BSPEntitiesParser.BSPEntity_Location)entity;
                Matrix4f spawnTrans = BSPConverter.getTransformFromEntity(entLoc, worldScale);
                siHandler.addSpecialItem(SpecialItemsHandler.SpecialItemType.SPAWN_TRANSFORM, className2, spawnTrans);
            } else if (className2.startsWith("item_") || className2.startsWith("weapon_") || className2.startsWith("ammo_")) {
                entLoc = (BSPEntitiesParser.BSPEntity_Location)entity;
                Matrix4f itemTrans = BSPConverter.getTransformFromEntity(entLoc, worldScale);
                siHandler.addSpecialItem(SpecialItemsHandler.SpecialItemType.ITEM, className2, itemTrans);
            } else if (className2.startsWith("misc_model")) {
                entLoc = (BSPEntitiesParser.BSPEntity_misc_model)entity;
                try {
                    URL modelURL = new URL(baseURL, ((BSPEntitiesParser.BSPEntity_misc_model)entLoc).model);
                    Matrix4f modelTrans = BSPConverter.getTransformFromEntity(entLoc, worldScale);
                    siHandler.addSpecialItem(SpecialItemsHandler.SpecialItemType.SUB_MODEL, modelURL.toExternalForm(), modelTrans);
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                }
            } else if (className2.startsWith("light")) {
                BSPEntitiesParser.BSPEntity_light entLight = (BSPEntitiesParser.BSPEntity_light)entity;
                NamedObject light = nodeFactory.createPointLightNode("");
                nodeFactory.setPointLightLocation(light, entLight.origin.getX(), entLight.origin.getY(), entLight.origin.getZ());
                nodeFactory.setPointLightColor(light, entLight.lightColor.getRed(), entLight.lightColor.getGreen(), entLight.lightColor.getBlue());
                nodeFactory.setLightRadius(light, entLight._light * worldScale);
                siHandler.addSpecialItem(SpecialItemsHandler.SpecialItemType.LIGHT, entLight.className2, light);
                nodeFactory.addNodeToGroup(light, sceneGroup);
            }
            ++i;
        }
    }

    public static void convert(BSPScenePrototype prototype, AppearanceFactory appFactory, NodeFactory nodeFactory, NamedObject sceneGroup, GroupType mainGroupType, float worldScale, URL baseURL, SpecialItemsHandler siHandler) {
        Object[] result = BSPConverter.convertFacesToShapes(prototype.sourceBSPVersion, prototype.models, prototype.faces, prototype.geometries, prototype.baseTextures, prototype.lightMaps, appFactory, nodeFactory, sceneGroup, mainGroupType, worldScale, siHandler);
        NamedObject bspTreeGroup = (NamedObject)result[0];
        BitSet faceBitset = (BitSet)result[1];
        if (mainGroupType == GroupType.BSP_TREE) {
            nodeFactory.setBSPGroupVisibilityUpdater(bspTreeGroup, BSPClusterManager.create(prototype, faceBitset));
        }
        BSPConverter.convertEntities(prototype.entities, worldScale, baseURL, siHandler, nodeFactory, sceneGroup);
    }
}

