/*
 * Decompiled with CFR 0.152.
 */
package org.jagatoo.loaders.models.bsp;

import org.jagatoo.datatypes.NamedObject;
import org.jagatoo.loaders.models._util.AppearanceFactory;
import org.jagatoo.loaders.textures.AbstractTexture;

public final class BSPTextureAnimator {
    private final AbstractTexture[] animFrames;
    private final int numFrames;
    private final NamedObject appearance;
    private final int textureUnit;
    private final AppearanceFactory appFactory;
    private final long frameTime;
    private long initialGameNanos = -1L;
    private int lastFrame = 0;

    private final void setFrame(int frame) {
        this.appFactory.applyTexture(this.animFrames[frame], this.textureUnit, this.appearance);
        this.lastFrame = frame;
    }

    public final void update(long gameNanos) {
        if (this.initialGameNanos < 0L) {
            this.initialGameNanos = gameNanos;
            return;
        }
        int frame = (int)((gameNanos - this.initialGameNanos) / this.frameTime % (long)this.numFrames);
        if (frame != this.lastFrame) {
            this.setFrame(frame);
        }
    }

    public BSPTextureAnimator(AbstractTexture[] animFrames, NamedObject appearance, int textureUnit, AppearanceFactory appFactory, float fps) {
        this.animFrames = animFrames;
        this.numFrames = animFrames.length - 1;
        this.appearance = appearance;
        this.textureUnit = textureUnit;
        this.appFactory = appFactory;
        this.frameTime = (long)(1.0f / fps * 1.0E9f);
    }
}

