/*
 * Decompiled with CFR 0.152.
 */
package org.jagatoo.loaders.models.cal3d.buffer;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;

public class IndexBuffer {
    IntBuffer intBuffer;
    ShortBuffer shortBuffer;
    ByteBuffer byteBuffer;
    int length;

    public IndexBuffer(int length) {
        this.length = length;
        this.intBuffer = ByteBuffer.allocateDirect(length * 4).order(ByteOrder.nativeOrder()).asIntBuffer();
    }

    public void put(int n, int x) {
        this.intBuffer.put(n, x);
    }

    public int get(int n) {
        return this.intBuffer.get(n);
    }

    public void put(int[] x) {
        this.intBuffer.put(x);
    }

    public void put(int n, int[] x) {
        this.intBuffer.put(x, n, x.length);
    }

    public void putTri(int n, int a, int b, int c) {
        this.intBuffer.put(3 * n + 0, a);
        this.intBuffer.put(3 * n + 1, b);
        this.intBuffer.put(3 * n + 2, c);
    }

    public void putQuad(int n, int a, int b, int c, int d) {
        this.intBuffer.put(4 * n + 0, a);
        this.intBuffer.put(4 * n + 1, b);
        this.intBuffer.put(4 * n + 2, c);
        this.intBuffer.put(4 * n + 3, d);
    }

    public int size() {
        return this.length;
    }

    public IntBuffer getBuffer() {
        return this.intBuffer;
    }
}

