/*
 * Decompiled with CFR 0.152.
 */
package org.jagatoo.loaders.models.cal3d.core;

import java.net.URL;
import java.util.Iterator;
import java.util.Vector;
import org.jagatoo.loaders.models.cal3d.core.CalCoreSubMorphTarget;
import org.jagatoo.loaders.models.cal3d.core.CalCoreSubmesh;
import org.openmali.vecmath2.Vector3f;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CalCoreMesh {
    protected String name;
    public String skin;
    public URL material;
    protected Vector<CalCoreSubmesh> vectorCoreSubmesh = new Vector();

    public int addCoreSubmesh(CalCoreSubmesh coreSubmesh) {
        int submeshId = this.vectorCoreSubmesh.size();
        this.vectorCoreSubmesh.add(coreSubmesh);
        return submeshId;
    }

    public int addAsMorphTarget(CalCoreMesh coreMesh) {
        Vector<CalCoreSubmesh> otherVectorCoreSubmesh = coreMesh.getVectorCoreSubmesh();
        if (this.vectorCoreSubmesh.size() != otherVectorCoreSubmesh.size()) {
            throw new IllegalArgumentException("Morph target must have same number of submeshes");
        }
        if (this.vectorCoreSubmesh.size() == 0) {
            throw new IllegalArgumentException("Morph target must have at least one submesh");
        }
        Iterator<CalCoreSubmesh> iteratorCoreSubmesh = this.vectorCoreSubmesh.iterator();
        Iterator<CalCoreSubmesh> otherIteratorCoreSubmesh = otherVectorCoreSubmesh.iterator();
        int subMorphTargetID = this.vectorCoreSubmesh.firstElement().getCoreSubMorphTargetCount();
        while (iteratorCoreSubmesh.hasNext()) {
            if (iteratorCoreSubmesh.next().getVertexCount() == otherIteratorCoreSubmesh.next().getVertexCount()) continue;
            throw new IllegalArgumentException("Submesh in morph target must have same number of vertices");
        }
        iteratorCoreSubmesh = this.vectorCoreSubmesh.iterator();
        otherIteratorCoreSubmesh = otherVectorCoreSubmesh.iterator();
        while (iteratorCoreSubmesh.hasNext()) {
            CalCoreSubmesh thisSubmesh = iteratorCoreSubmesh.next();
            CalCoreSubmesh otherSubmesh = otherIteratorCoreSubmesh.next();
            int vertexCount = otherSubmesh.getVertexCount();
            CalCoreSubMorphTarget calCoreSubMorphTarget = new CalCoreSubMorphTarget(vertexCount);
            Vector3f blendVertexPosition = new Vector3f();
            Vector3f blendVertexNormal = new Vector3f();
            int i = 0;
            while (i < vertexCount) {
                otherSubmesh.getVertexPosition(i, blendVertexPosition);
                otherSubmesh.getVertexNormal(i, blendVertexNormal);
                calCoreSubMorphTarget.setBlendVertex(i, blendVertexPosition, blendVertexNormal);
                ++i;
            }
            thisSubmesh.addCoreSubMorphTarget(calCoreSubMorphTarget);
        }
        return subMorphTargetID;
    }

    public CalCoreSubmesh getCoreSubmesh(int id) {
        return this.vectorCoreSubmesh.elementAt(id);
    }

    public int getCoreSubmeshCount() {
        return this.vectorCoreSubmesh.size();
    }

    public Vector<CalCoreSubmesh> getVectorCoreSubmesh() {
        return this.vectorCoreSubmesh;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }
}

