/*
 * Decompiled with CFR 0.152.
 */
package org.jagatoo.loaders.models.cal3d.core;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.DataInput;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.List;
import java.util.StringTokenizer;
import org.jagatoo.loaders.models.cal3d.core.CalCoreAnimation;
import org.jagatoo.loaders.models.cal3d.core.CalCoreBone;
import org.jagatoo.loaders.models.cal3d.core.CalCoreKeyframe;
import org.jagatoo.loaders.models.cal3d.core.CalCoreMaterial;
import org.jagatoo.loaders.models.cal3d.core.CalCoreMesh;
import org.jagatoo.loaders.models.cal3d.core.CalCoreSkeleton;
import org.jagatoo.loaders.models.cal3d.core.CalCoreSubmesh;
import org.jagatoo.loaders.models.cal3d.core.CalCoreTrack;
import org.jagatoo.loaders.models.cal3d.core.CalPlatform;
import org.jagatoo.util.streams.LittleEndianDataInputStream;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import org.openmali.vecmath2.Colorf;
import org.openmali.vecmath2.Quaternion4f;
import org.openmali.vecmath2.Vector2f;
import org.openmali.vecmath2.Vector3f;

public class CalLoader {
    public static final byte[] SKELETON_FILE_MAGIC;
    private static final String SKELETON_XMLFILE_EXTENSION = ".xsf";
    private static final String SKELETON_XMLFILE_MAGIC = "XSF";
    public static final byte[] ANIMATION_FILE_MAGIC;
    private static final String ANIMATION_XMLFILE_EXTENSION = ".xaf";
    private static final String ANIMATION_XMLFILE_MAGIC = "XAF";
    public static final byte[] MESH_FILE_MAGIC;
    private static final String MESH_XMLFILE_EXTENSION = ".xmf";
    private static final String MESH_XMLFILE_MAGIC = "XMF";
    public static final byte[] MATERIAL_FILE_MAGIC;
    private static final String MATERIAL_XMLFILE_EXTENSION = ".xrf";
    private static final String MATERIAL_XMLFILE_MAGIC = "XRF";
    public static final int LIBRARY_VERSION = 1000;
    public static final int CURRENT_FILE_VERSION = 1000;
    public static final int EARLIEST_COMPATIBLE_FILE_VERSION = 699;
    public static final int LOADER_ROTATE_X_AXIS = 1;
    protected static int loadingMode;

    static {
        byte[] byArray = new byte[4];
        byArray[0] = 67;
        byArray[1] = 83;
        byArray[2] = 70;
        SKELETON_FILE_MAGIC = byArray;
        byte[] byArray2 = new byte[4];
        byArray2[0] = 67;
        byArray2[1] = 65;
        byArray2[2] = 70;
        ANIMATION_FILE_MAGIC = byArray2;
        byte[] byArray3 = new byte[4];
        byArray3[0] = 67;
        byArray3[1] = 77;
        byArray3[2] = 70;
        MESH_FILE_MAGIC = byArray3;
        byte[] byArray4 = new byte[4];
        byArray4[0] = 67;
        byArray4[1] = 82;
        byArray4[2] = 70;
        MATERIAL_FILE_MAGIC = byArray4;
    }

    public static void setLoadingMode(int flags) {
        loadingMode = flags;
    }

    public static CalCoreAnimation loadCoreAnimation(URL resource, String name) throws IOException {
        InputStream in = resource.openStream();
        if (resource.toExternalForm().toLowerCase().endsWith(ANIMATION_XMLFILE_EXTENSION)) {
            return CalLoader.loadXmlCoreAnimation(in);
        }
        try {
            CalCoreAnimation calCoreAnimation = CalLoader.loadCoreAnimation(in, name);
            return calCoreAnimation;
        }
        finally {
            in.close();
        }
    }

    private static CalCoreAnimation loadXmlCoreAnimation(InputStream in) {
        throw new UnsupportedOperationException("The XML file format isn't supported yet by Cal3Dj.\nPlease use the binary format (.CMF, .CAF, .CSF, .CRF) instead, or implement XML\nXML support yourself.");
    }

    public static CalCoreAnimation loadCoreAnimation(InputStream in, String name) throws IOException {
        LittleEndianDataInputStream file = new LittleEndianDataInputStream(in);
        byte[] magic = new byte[4];
        file.readFully(magic);
        if (!new String(magic).equals(new String(ANIMATION_FILE_MAGIC))) {
            throw new IllegalArgumentException("File not a cal3d animation file (CAF)");
        }
        int version = file.readInt();
        if (version < 699 || version > 1000) {
            throw new IllegalArgumentException("Incompatible cal3d file version");
        }
        CalCoreAnimation coreAnimation = new CalCoreAnimation();
        float duration = file.readFloat();
        if (duration <= 0.0f) {
            throw new IOException("Invalid animation duration in cal3d animation file");
        }
        coreAnimation.setDuration(duration);
        int trackCount = file.readInt();
        if (trackCount <= 0) {
            throw new IOException("Invalid track count in cal3d animation file");
        }
        int trackId = 0;
        while (trackId < trackCount) {
            CalCoreTrack coreTrack = CalLoader.loadCoreTrack(file);
            coreAnimation.addCoreTrack(coreTrack);
            ++trackId;
        }
        coreAnimation.setName(name);
        return coreAnimation;
    }

    /*
     * Unable to fully structure code
     */
    protected static CalCoreBone loadCoreBones(DataInput file) throws IOException {
        strName = CalPlatform.readString(file).trim();
        tx = file.readFloat();
        ty = file.readFloat();
        tz = file.readFloat();
        rx = file.readFloat();
        ry = file.readFloat();
        rz = file.readFloat();
        rw = file.readFloat();
        txBoneSpace = file.readFloat();
        tyBoneSpace = file.readFloat();
        tzBoneSpace = file.readFloat();
        rxBoneSpace = file.readFloat();
        ryBoneSpace = file.readFloat();
        rzBoneSpace = file.readFloat();
        rwBoneSpace = file.readFloat();
        parentId = file.readInt();
        coreBone = new CalCoreBone(strName);
        coreBone.setParentId(parentId);
        coreBone.setTranslation(new Vector3f(tx, ty, tz));
        coreBone.setRotation(new Quaternion4f(rx, ry, rz, rw));
        coreBone.setTranslationBoneSpace(new Vector3f(txBoneSpace, tyBoneSpace, tzBoneSpace));
        coreBone.setRotationBoneSpace(new Quaternion4f(rxBoneSpace, ryBoneSpace, rzBoneSpace, rwBoneSpace));
        childCount = file.readInt();
        if (childCount >= 0) ** GOTO lbl31
        throw new IOException("Invalid child count in cal3d skeleton file");
lbl-1000:
        // 1 sources

        {
            childId = file.readInt();
            if (childId < 0) {
                throw new IOException("Invalid child id in cal3d skeleton file");
            }
            coreBone.addChildId(childId);
            --childCount;
lbl31:
            // 2 sources

            ** while (childCount > 0)
        }
lbl32:
        // 1 sources

        return coreBone;
    }

    protected static CalCoreKeyframe loadCoreKeyframe(DataInput file) throws IOException {
        float time = file.readFloat();
        float tx = file.readFloat();
        float ty = file.readFloat();
        float tz = file.readFloat();
        float rx = file.readFloat();
        float ry = file.readFloat();
        float rz = file.readFloat();
        float rw = file.readFloat();
        CalCoreKeyframe coreKeyframe = new CalCoreKeyframe();
        coreKeyframe.setTime(time);
        coreKeyframe.setTranslation(new Vector3f(tx, ty, tz));
        coreKeyframe.setRotation(new Quaternion4f(rx, ry, rz, rw));
        return coreKeyframe;
    }

    public static CalCoreMaterial loadCoreMaterial(URL resource) throws IOException {
        InputStream in = resource.openStream();
        if (resource.toExternalForm().toLowerCase().endsWith(MATERIAL_XMLFILE_EXTENSION)) {
            return CalLoader.loadXmlCoreMaterial(in);
        }
        try {
            CalCoreMaterial calCoreMaterial = CalLoader.loadCoreMaterial(in);
            return calCoreMaterial;
        }
        finally {
            in.close();
        }
    }

    private static CalCoreMaterial loadXmlCoreMaterial(InputStream in) {
        throw new UnsupportedOperationException("The XML file format isn't supported yet by Cal3Dj.\nPlease use the binary format (.CMF, .CAF, .CSF, .CRF) instead, or implement XML\nXML support yourself.");
    }

    public static CalCoreMaterial loadCoreMaterial(InputStream in) throws IOException {
        LittleEndianDataInputStream file = new LittleEndianDataInputStream(in);
        byte[] magic = new byte[4];
        file.readFully(magic);
        if (!new String(magic).equals(new String(MATERIAL_FILE_MAGIC))) {
            throw new IllegalArgumentException("File not a cal3d material file (CRF)");
        }
        int version = file.readInt();
        if (version < 699 || version > 1000) {
            throw new IllegalArgumentException("Incompatible cal3d file version");
        }
        CalCoreMaterial coreMaterial = new CalCoreMaterial();
        Colorf ambientColor = CalPlatform.readColour(file);
        Colorf diffuseColor = CalPlatform.readColour(file);
        Colorf specularColor = CalPlatform.readColour(file);
        float shininess = file.readFloat();
        coreMaterial.setAmbientColor(ambientColor);
        coreMaterial.setDiffuseColor(diffuseColor);
        coreMaterial.setSpecularColor(specularColor);
        coreMaterial.setShininess(shininess);
        int mapCount = file.readInt();
        if (mapCount < 0) {
            throw new IOException("Invalid map count in cal3d material file");
        }
        coreMaterial.reserve(mapCount);
        int mapId = 0;
        while (mapId < mapCount) {
            CalCoreMaterial.Map map = new CalCoreMaterial.Map();
            map.filename = CalPlatform.readString(file);
            map.userData = null;
            coreMaterial.setMap(mapId, map);
            ++mapId;
        }
        return coreMaterial;
    }

    public static CalCoreMesh loadCoreMesh(URL resource) throws IOException {
        InputStream in = resource.openStream();
        if (resource.toExternalForm().toLowerCase().endsWith(MESH_XMLFILE_EXTENSION)) {
            return CalLoader.loadXmlCoreMesh(in);
        }
        try {
            CalCoreMesh calCoreMesh = CalLoader.loadCoreMesh(in);
            return calCoreMesh;
        }
        finally {
            in.close();
        }
    }

    public static CalCoreMesh loadCoreMesh(InputStream in) throws IOException {
        if (!(in instanceof BufferedInputStream)) {
            in = new BufferedInputStream(in);
        }
        LittleEndianDataInputStream file = new LittleEndianDataInputStream(in);
        byte[] magic = new byte[4];
        file.readFully(magic);
        if (!new String(magic).equals(new String(MESH_FILE_MAGIC))) {
            throw new IllegalArgumentException("File not a cal3d mesh file (CMF)");
        }
        int version = file.readInt();
        if (version < 699 || version > 1000) {
            throw new IllegalArgumentException("Incompatible cal3d file version");
        }
        int submeshCount = file.readInt();
        CalCoreMesh coreMesh = new CalCoreMesh();
        int submeshId = 0;
        while (submeshId < submeshCount) {
            CalCoreSubmesh coreSubmesh = CalLoader.loadCoreSubmesh(file);
            coreMesh.addCoreSubmesh(coreSubmesh);
            ++submeshId;
        }
        return coreMesh;
    }

    public static CalCoreSkeleton loadCoreSkeleton(URL resource) throws IOException {
        InputStream in = resource.openStream();
        if (resource.toExternalForm().toLowerCase().endsWith(SKELETON_XMLFILE_EXTENSION)) {
            return CalLoader.loadXmlCoreSkeleton(in);
        }
        try {
            CalCoreSkeleton calCoreSkeleton = CalLoader.loadCoreSkeleton(in);
            return calCoreSkeleton;
        }
        finally {
            in.close();
        }
    }

    private static CalCoreSkeleton loadXmlCoreSkeleton(InputStream in) {
        throw new UnsupportedOperationException("The XML file format isn't supported yet by Cal3Dj.\nPlease use the binary format (.CMF, .CAF, .CSF, .CRF) instead, or implement XML\nXML support yourself.");
    }

    private static CalCoreMesh loadXmlCoreMesh(InputStream in) {
        Document doc;
        SAXBuilder sb = new SAXBuilder();
        try {
            BufferedReader bR = CalLoader.getCleanXML(in, MESH_XMLFILE_MAGIC);
            doc = sb.build((Reader)bR);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        Element mesh = doc.getRootElement();
        int submeshCount = CalLoader.toInt(mesh.getAttributeValue("NUMSUBMESH"));
        CalCoreMesh pCoreMesh = new CalCoreMesh();
        List subMeshes = mesh.getChildren("SUBMESH");
        for (Object o : subMeshes) {
            Element subMesh = (Element)o;
            int coreMaterialThreadId = CalLoader.toInt(subMesh.getAttribute("MATERIAL").getValue());
            int vertexCount = CalLoader.toInt(subMesh.getAttribute("NUMVERTICES").getValue());
            int faceCount = CalLoader.toInt(subMesh.getAttribute("NUMFACES").getValue());
            int lodCount = CalLoader.toInt(subMesh.getAttribute("NUMLODSTEPS").getValue());
            int springCount = CalLoader.toInt(subMesh.getAttribute("NUMSPRINGS").getValue());
            int textureCoordinateCount = CalLoader.toInt(subMesh.getAttribute("NUMTEXCOORDS").getValue());
            CalCoreSubmesh pCoreSubmesh = new CalCoreSubmesh();
            pCoreSubmesh.setLodCount(lodCount);
            pCoreSubmesh.setCoreMaterialThreadId(coreMaterialThreadId);
            pCoreSubmesh.reserve(vertexCount, textureCoordinateCount, faceCount, springCount);
            List vertices = subMesh.getChildren("VERTEX");
            int vertexId = 0;
            for (Object o2 : vertices) {
                Element physique;
                Element vertex = (Element)o2;
                Vector3f position = new Vector3f();
                CalLoader.read(vertex.getChild("POS"), position);
                Vector3f normal = new Vector3f();
                CalLoader.read(vertex.getChild("NORM"), normal);
                CalCoreSubmesh.VertexInfo vertexInfo = new CalCoreSubmesh.VertexInfo();
                Element collapseId = vertex.getChild("COLLAPSEID");
                vertexInfo.collapseId = collapseId != null ? CalLoader.toInt(collapseId.getText()) : -1;
                Element collapseCount = vertex.getChild("COLLAPSECOUNT");
                vertexInfo.faceCollapseCount = collapseCount != null ? CalLoader.toInt(collapseCount.getText()) : 0;
                pCoreSubmesh.setVertex(vertexId, vertexInfo, position, normal);
                List texCoords = vertex.getChildren("TEXCOORD");
                int texCoordId = 0;
                for (Object o3 : texCoords) {
                    Element texCoord = (Element)o3;
                    Vector2f texCoord2f = new Vector2f();
                    StringTokenizer token = new StringTokenizer(texCoord.getValue(), " ");
                    texCoord2f.setX(CalLoader.toFloat(token.nextToken()));
                    texCoord2f.setY(1.0f - CalLoader.toFloat(token.nextToken()));
                    pCoreSubmesh.setTextureCoordinate(vertexId, texCoordId++, texCoord2f);
                }
                int influenceCount = CalLoader.toInt(vertex.getAttribute("NUMINFLUENCES").getValue());
                vertexInfo.influenceBoneIds = new int[influenceCount];
                vertexInfo.influenceWeights = new float[influenceCount];
                List influences = vertex.getChildren("INFLUENCE");
                int influenceId = 0;
                for (Object o3 : influences) {
                    Element influence = (Element)o3;
                    vertexInfo.influenceBoneIds[influenceId] = CalLoader.toInt(influence.getAttribute("ID").getValue());
                    vertexInfo.influenceWeights[influenceId] = CalLoader.toFloat(influence.getValue());
                    ++influenceId;
                }
                if (springCount > 0 && (physique = vertex.getChild("PHYSIQUE")) != null) {
                    float physicalProperty = CalLoader.toFloat(physique.getValue());
                    pCoreSubmesh.setPhysicalProperty(vertexId, physicalProperty);
                }
                ++vertexId;
            }
            List springs = mesh.getChildren("SPRING");
            int springId = 0;
            for (Object o2 : springs) {
                Element springElem = (Element)o2;
                String vertexIdD = springElem.getChildText("VERTEXID");
                String coefD = springElem.getChildText("COEF");
                String length = springElem.getChildText("LENGTH");
                CalCoreSubmesh.Spring spring = new CalCoreSubmesh.Spring();
                StringTokenizer token = new StringTokenizer(vertexIdD, " ");
                spring.vertexId0 = CalLoader.toInt(token.nextToken());
                spring.vertexId1 = CalLoader.toInt(token.nextToken());
                spring.springCoefficient = CalLoader.toFloat(coefD);
                spring.idleLength = CalLoader.toFloat(length);
                pCoreSubmesh.setSpring(springId, spring);
                ++springId;
            }
        }
        throw new UnsupportedOperationException("The XML file format isn't supported yet by Cal3Dj.\nPlease use the binary format (.CMF, .CAF, .CSF, .CRF) instead, or implement XML\nXML support yourself.");
    }

    private static void read(Element child, Vector3f posInfo) {
        StringTokenizer pos = new StringTokenizer(child.getValue(), " ");
        posInfo.setX(CalLoader.toFloat(pos.nextToken()));
        posInfo.setY(CalLoader.toFloat(pos.nextToken()));
        posInfo.setZ(CalLoader.toFloat(pos.nextToken()));
    }

    private static float toFloat(String string) {
        return Float.parseFloat(string);
    }

    private static BufferedReader getCleanXML(InputStream in, String magicNeeded) throws Exception {
        BufferedReader bR = new BufferedReader(new InputStreamReader(in));
        try {
            String line = bR.readLine();
            if (line.startsWith("<?xml version=")) {
                line = bR.readLine();
                if (line.startsWith("<HEADER")) {
                    StringTokenizer token = new StringTokenizer(line, "=\"");
                    token.nextToken();
                    String magicGot = token.nextToken();
                    if (!magicGot.equals(magicNeeded)) {
                        throw new IOException("Wrong MAGIC, should be " + magicNeeded + " instead is : " + magicGot);
                    }
                    token.nextToken();
                    int version = CalLoader.toInt(token.nextToken());
                    if (version < 699) {
                        throw new Exception("Incompatible version. Earliest compatible file version is : 699 and current file version is : " + version);
                    }
                } else {
                    Thread.dumpStack();
                }
            } else {
                Thread.dumpStack();
            }
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        return bR;
    }

    private static int toInt(String string) {
        return Integer.parseInt(string);
    }

    public static CalCoreSkeleton loadCoreSkeleton(InputStream in) throws IOException {
        LittleEndianDataInputStream file = new LittleEndianDataInputStream(in);
        byte[] magic = new byte[4];
        file.readFully(magic);
        if (!new String(magic).equals(new String(SKELETON_FILE_MAGIC))) {
            throw new IllegalArgumentException("File not a cal3d skeleton file (CSF)");
        }
        int version = file.readInt();
        if (version < 699 || version > 1000) {
            throw new IllegalArgumentException("Incompatible cal3d file version");
        }
        int boneCount = file.readInt();
        if (boneCount <= 0) {
            throw new IllegalArgumentException("Incompatible file format for cal3d skeleton file : boneCount = " + boneCount);
        }
        CalCoreSkeleton coreSkeleton = new CalCoreSkeleton();
        int boneId = 0;
        while (boneId < boneCount) {
            CalCoreBone coreBone = CalLoader.loadCoreBones(file);
            coreSkeleton.addCoreBone(coreBone);
            ++boneId;
        }
        coreSkeleton.calculateState();
        return coreSkeleton;
    }

    protected static CalCoreSubmesh loadCoreSubmesh(DataInput file) throws IOException {
        int coreMaterialThreadId = file.readInt();
        int vertexCount = file.readInt();
        int faceCount = file.readInt();
        int lodCount = file.readInt();
        int springCount = file.readInt();
        int textureCoordinateCount = file.readInt();
        CalCoreSubmesh coreSubmesh = new CalCoreSubmesh();
        coreSubmesh.setLodCount(lodCount);
        coreSubmesh.setCoreMaterialThreadId(coreMaterialThreadId);
        coreSubmesh.reserve(vertexCount, textureCoordinateCount, faceCount, springCount);
        Vector3f vertexPosition = new Vector3f();
        Vector3f vertexNormal = new Vector3f();
        int vertexId = 0;
        while (vertexId < vertexCount) {
            CalCoreSubmesh.VertexInfo vertex = new CalCoreSubmesh.VertexInfo();
            vertexPosition.setX(file.readFloat());
            vertexPosition.setY(file.readFloat());
            vertexPosition.setZ(file.readFloat());
            vertexNormal.setX(file.readFloat());
            vertexNormal.setY(file.readFloat());
            vertexNormal.setZ(file.readFloat());
            vertex.collapseId = file.readInt();
            vertex.faceCollapseCount = file.readInt();
            int textureCoordinateId = 0;
            while (textureCoordinateId < textureCoordinateCount) {
                Vector2f textureCoordinate = new Vector2f();
                textureCoordinate.setX(file.readFloat());
                textureCoordinate.setY(1.0f - file.readFloat());
                coreSubmesh.setTextureCoordinate(vertexId, textureCoordinateId, textureCoordinate);
                ++textureCoordinateId;
            }
            int influenceCount = file.readInt();
            if (influenceCount < 0) {
                throw new IOException("Invalid count in cal3d mesh file");
            }
            vertex.influenceBoneIds = new int[influenceCount];
            vertex.influenceWeights = new float[influenceCount];
            int influenceId = 0;
            while (influenceId < influenceCount) {
                vertex.influenceBoneIds[influenceId] = file.readInt();
                vertex.influenceWeights[influenceId] = file.readFloat();
                ++influenceId;
            }
            coreSubmesh.setVertex(vertexId, vertex, vertexPosition, vertexNormal);
            if (springCount > 0) {
                float physicalProperty = file.readFloat();
                coreSubmesh.setPhysicalProperty(vertexId, physicalProperty);
            }
            ++vertexId;
        }
        int springId = 0;
        while (springId < springCount) {
            CalCoreSubmesh.Spring spring = new CalCoreSubmesh.Spring();
            spring.vertexId0 = file.readInt();
            spring.vertexId1 = file.readInt();
            spring.springCoefficient = file.readFloat();
            spring.idleLength = file.readFloat();
            coreSubmesh.setSpring(springId, spring);
            ++springId;
        }
        int faceId = 0;
        while (faceId < faceCount) {
            CalCoreSubmesh.Face face = new CalCoreSubmesh.Face();
            face.vertexId[0] = file.readInt();
            face.vertexId[1] = file.readInt();
            face.vertexId[2] = file.readInt();
            coreSubmesh.setFace(faceId, face);
            ++faceId;
        }
        return coreSubmesh;
    }

    protected static CalCoreTrack loadCoreTrack(DataInput file) throws IOException {
        int coreBoneId = file.readInt();
        if (coreBoneId < 0) {
            throw new IOException("Invalid count in cal3d animation track");
        }
        CalCoreTrack coreTrack = new CalCoreTrack();
        coreTrack.setCoreBoneId(coreBoneId);
        int keyframeCount = file.readInt();
        if (keyframeCount <= 0) {
            new IOException("Invalid count in cal3d animation track");
        }
        int keyframeId = 0;
        while (keyframeId < keyframeCount) {
            CalCoreKeyframe coreKeyframe = CalLoader.loadCoreKeyframe(file);
            coreTrack.addCoreKeyframe(coreKeyframe);
            ++keyframeId;
        }
        return coreTrack;
    }
}

