/*
 * Decompiled with CFR 0.152.
 */
package org.jagatoo.loaders.models.cal3d.core;

import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.jagatoo.loaders.models.cal3d.core.CalCoreMaterial;
import org.jagatoo.loaders.models.cal3d.core.CalCoreMesh;
import org.jagatoo.loaders.models.cal3d.core.CalCoreModel;
import org.jagatoo.loaders.models.cal3d.core.CalCoreSkeleton;
import org.jagatoo.loaders.models.cal3d.core.CalMesh;
import org.jagatoo.loaders.models.cal3d.core.CalMixer;
import org.jagatoo.loaders.models.cal3d.core.CalPhysique;
import org.jagatoo.loaders.models.cal3d.core.CalSkeleton;
import org.jagatoo.loaders.models.cal3d.core.CalSpringSystem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CalModel {
    protected CalCoreModel coreModel;
    protected CalSkeleton skeleton;
    protected CalMixer mixer;
    protected CalPhysique physique;
    protected CalSpringSystem springSystem;
    protected Object userData;
    protected List<CalMesh> meshes = new Vector<CalMesh>();
    protected String currentMaterialSet;

    public CalModel(CalCoreModel coreModel) {
        if (coreModel == null) {
            throw new IllegalArgumentException();
        }
        this.coreModel = coreModel;
        this.skeleton = new CalSkeleton(coreModel.getCoreSkeleton());
        this.mixer = new CalMixer(this);
        this.physique = new CalPhysique(this);
        this.springSystem = new CalSpringSystem(this);
        this.userData = null;
    }

    public CalModel(CalModel other) {
        if (other == null) {
            throw new IllegalArgumentException();
        }
        this.coreModel = other.getCoreModel();
        this.skeleton = new CalSkeleton(this.coreModel.getCoreSkeleton());
        this.mixer = new CalMixer(this);
        this.physique = new CalPhysique(this);
        this.springSystem = new CalSpringSystem(this);
        this.userData = null;
        for (CalMesh activeMesh : other.meshes) {
            this.attachMesh(activeMesh.getCoreMesh().getName());
        }
        this.setMaterialSet(other.currentMaterialSet);
    }

    public void finalize() {
        assert (this.meshes.isEmpty());
    }

    public synchronized void attachMesh(String coreMeshId) {
        CalCoreMesh coreMesh = this.coreModel.getCoreMesh(coreMeshId);
        int meshId = 0;
        while (meshId < this.meshes.size()) {
            if (this.meshes.get(meshId).getCoreMesh() == coreMesh) {
                return;
            }
            ++meshId;
        }
        CalMesh mesh = new CalMesh(coreMesh);
        mesh.setModel(this);
        this.meshes.add(mesh);
    }

    public synchronized boolean detachMesh(String coreMeshId) {
        CalCoreMesh coreMesh = this.coreModel.getCoreMesh(coreMeshId);
        Iterator<CalMesh> iteratorMesh = this.meshes.iterator();
        while (iteratorMesh.hasNext()) {
            CalMesh mesh = iteratorMesh.next();
            if (mesh.getCoreMesh() != coreMesh) continue;
            iteratorMesh.remove();
            return true;
        }
        return false;
    }

    public synchronized void detachAllMeshes() {
        this.meshes.clear();
    }

    public CalCoreModel getCoreModel() {
        return this.coreModel;
    }

    public CalMesh getMesh(String coreMeshId) {
        CalCoreMesh coreMesh = this.coreModel.getCoreMesh(coreMeshId);
        int meshId = 0;
        while (meshId < this.meshes.size()) {
            CalMesh mesh = this.meshes.get(meshId);
            if (mesh.getCoreMesh() == coreMesh) {
                return mesh;
            }
            ++meshId;
        }
        return null;
    }

    public CalMixer getMixer() {
        return this.mixer;
    }

    public CalPhysique getPhysique() {
        return this.physique;
    }

    public CalSkeleton getSkeleton() {
        return this.skeleton;
    }

    public synchronized void setCoreSkeleton(CalCoreSkeleton coreSkeleton) {
        this.skeleton = new CalSkeleton(this.coreModel.getCoreSkeleton());
    }

    public CalSpringSystem getSpringSystem() {
        return this.springSystem;
    }

    public Object getUserData() {
        return this.userData;
    }

    public List<CalMesh> getMeshes() {
        return this.meshes;
    }

    public synchronized void setLodLevel(float lodLevel) {
        for (CalMesh mesh : this.meshes) {
            mesh.setLodLevel(lodLevel);
        }
    }

    public synchronized void setMaterialSet(String setId) {
        this.currentMaterialSet = setId;
        for (CalMesh mesh : this.meshes) {
            mesh.setMaterialSet(setId);
        }
    }

    public synchronized void setMaterialSet(List<CalCoreMaterial> materials) {
        this.currentMaterialSet = null;
        for (CalMesh mesh : this.meshes) {
            mesh.setMaterialSet(materials);
        }
    }

    public String getMaterialSet() {
        return this.currentMaterialSet;
    }

    public void setUserData(Object userData) {
        this.userData = userData;
    }

    public synchronized void update(float deltaTime) {
        this.mixer.updateAnimation(deltaTime);
        this.mixer.updateSkeleton();
        this.physique.update();
        this.springSystem.update(deltaTime);
    }
}

