/*
 * Decompiled with CFR 0.152.
 */
package org.jagatoo.loaders.models.cal3d.core;

import java.util.Vector;
import org.jagatoo.loaders.models.cal3d.core.CalBone;
import org.jagatoo.loaders.models.cal3d.core.CalCoreBone;
import org.jagatoo.loaders.models.cal3d.core.CalCoreSkeleton;
import org.openmali.vecmath2.Quaternion4f;
import org.openmali.vecmath2.Vector3f;

public class CalSkeleton {
    protected CalCoreSkeleton coreSkeleton;
    protected CalBone[] vectorBone;

    public CalSkeleton(CalCoreSkeleton coreSkeleton) {
        this.coreSkeleton = coreSkeleton;
        Vector<CalCoreBone> vectorCoreBone = coreSkeleton.getCoreBones();
        int boneCount = vectorCoreBone.size();
        this.vectorBone = new CalBone[boneCount];
        int boneId = 0;
        while (boneId < boneCount) {
            CalBone bone = new CalBone(vectorCoreBone.elementAt(boneId));
            bone.setSkeleton(this);
            this.vectorBone[boneId] = bone;
            ++boneId;
        }
    }

    public void calculateState() {
        for (int rootBoneId : this.coreSkeleton.getListRootCoreBoneId()) {
            this.vectorBone[rootBoneId].calculateState();
        }
    }

    public void clearState() {
        int n = 0;
        while (n < this.vectorBone.length) {
            this.vectorBone[n].clearState();
            ++n;
        }
    }

    public CalBone getBone(int boneId) {
        return this.vectorBone[boneId];
    }

    public Vector3f getBoneTranslation(CalCoreBone coreBone) {
        return this.vectorBone[coreBone.id].getTranslationAbsolute();
    }

    public Quaternion4f getBoneRotation(CalCoreBone coreBone) {
        return this.vectorBone[coreBone.id].getRotationAbsolute();
    }

    public CalCoreSkeleton getCoreSkeleton() {
        return this.coreSkeleton;
    }

    public CalBone[] getBones() {
        return this.vectorBone;
    }

    public void lockState() {
        int n = 0;
        while (n < this.vectorBone.length) {
            this.vectorBone[n].lockState();
            ++n;
        }
    }
}

