/*
 * Decompiled with CFR 0.152.
 */
package org.jagatoo.loaders.models.collada;

import java.util.ArrayList;
import java.util.HashMap;
import org.jagatoo.loaders.models.collada.datastructs.AssetFolder;
import org.jagatoo.loaders.models.collada.datastructs.effects.Effect;
import org.jagatoo.loaders.models.collada.datastructs.effects.LibraryEffects;
import org.jagatoo.loaders.models.collada.datastructs.effects.Profile;
import org.jagatoo.loaders.models.collada.datastructs.effects.ProfileCommon;
import org.jagatoo.loaders.models.collada.datastructs.images.Surface;
import org.jagatoo.loaders.models.collada.stax.XMLEffect;
import org.jagatoo.loaders.models.collada.stax.XMLLibraryEffects;
import org.jagatoo.loaders.models.collada.stax.XMLProfileCOMMON;
import org.jagatoo.loaders.models.collada.stax.XMLProfileCOMMON_NewParam;
import org.jagatoo.loaders.models.collada.stax.XMLSampler2D;
import org.jagatoo.loaders.models.collada.stax.XMLSurface;
import org.jagatoo.logging.JAGTLog;

public class LibraryEffectsLoader {
    static void loadLibraryEffects(AssetFolder colladaFile, XMLLibraryEffects libEffects) {
        LibraryEffects colLibEffects = colladaFile.getLibraryEffects();
        ArrayList<XMLEffect> effects = libEffects.effects;
        for (XMLEffect effect : effects) {
            JAGTLog.debug("TT] Effect \"", effect.id, "\"");
            JAGTLog.increaseIndentation();
            Effect colladaEffect = new Effect(effect.id);
            colLibEffects.getEffects().put(colladaEffect.getId(), colladaEffect);
            colladaEffect.profiles = new ArrayList();
            if (effect.profileCOMMON != null) {
                JAGTLog.debug("TT] Profile COMMON : loading...");
                JAGTLog.increaseIndentation();
                colladaEffect.profiles.add(LibraryEffectsLoader.loadCommonProfile(effect, effect.profileCOMMON));
                JAGTLog.decreaseIndentation();
            }
            if (effect.profileCG != null) {
                JAGTLog.debug("EE] CG shaders profile isn't implemented yet !");
            }
            if (effect.profileGLSL != null) {
                JAGTLog.debug("EE] GLSL shaders profile isn't implemented yet !");
            }
            JAGTLog.decreaseIndentation();
        }
    }

    static Profile loadCommonProfile(XMLEffect effect, XMLProfileCOMMON profile) {
        ProfileCommon colladaProfile = new ProfileCommon();
        colladaProfile.setSurfaces(new HashMap<String, Surface>());
        ArrayList<XMLProfileCOMMON_NewParam> newParams = profile.newParams;
        if (newParams != null) {
            for (XMLProfileCOMMON_NewParam newParam : newParams) {
                if (newParam.surface != null) {
                    XMLSurface surface = newParam.surface;
                    Surface colladaSurface = new Surface(newParam.sid);
                    colladaSurface.imageIds = new ArrayList();
                    JAGTLog.debug("TT] Found surface ! (id = ", newParam.sid, ")");
                    JAGTLog.increaseIndentation();
                    String imageId = surface.initFrom;
                    JAGTLog.debug("TT] Image id : ", imageId);
                    colladaSurface.imageIds.add(imageId);
                    colladaProfile.getSurfaces().put(colladaSurface.getId(), colladaSurface);
                    JAGTLog.decreaseIndentation();
                    continue;
                }
                if (newParam.sampler2D == null) continue;
                JAGTLog.debug("TT] Found sampler ! (id = ", newParam.sid, ")");
                JAGTLog.increaseIndentation();
                XMLSampler2D sampler2D = newParam.sampler2D;
                JAGTLog.debug("TT] Sampler using source : ", sampler2D.source);
                JAGTLog.decreaseIndentation();
            }
        }
        return colladaProfile;
    }
}

