/*
 * Decompiled with CFR 0.152.
 */
package org.jagatoo.loaders.models.collada;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.jagatoo.loaders.models.collada.datastructs.AssetFolder;
import org.jagatoo.loaders.models.collada.datastructs.geometries.Geometry;
import org.jagatoo.loaders.models.collada.datastructs.geometries.LibraryGeometries;
import org.jagatoo.loaders.models.collada.datastructs.geometries.Mesh;
import org.jagatoo.loaders.models.collada.datastructs.geometries.MeshDataInfo;
import org.jagatoo.loaders.models.collada.datastructs.geometries.MeshSources;
import org.jagatoo.loaders.models.collada.datastructs.geometries.TrianglesGeometry;
import org.jagatoo.loaders.models.collada.stax.XMLGeometry;
import org.jagatoo.loaders.models.collada.stax.XMLInput;
import org.jagatoo.loaders.models.collada.stax.XMLLibraryGeometries;
import org.jagatoo.loaders.models.collada.stax.XMLMesh;
import org.jagatoo.loaders.models.collada.stax.XMLSource;
import org.jagatoo.loaders.models.collada.stax.XMLTriangles;
import org.jagatoo.logging.JAGTLog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LibraryGeometriesLoader {
    static LibraryGeometries loadLibraryGeometries(AssetFolder colladaFile, XMLLibraryGeometries libGeoms) {
        LibraryGeometries colladaLibGeoms = colladaFile.getLibraryGeometries();
        Collection<XMLGeometry> geoms = libGeoms.geometries.values();
        JAGTLog.debug("There ", geoms.size() > 1 ? "are" : "is", " ", geoms.size(), " geometr", geoms.size() > 1 ? "ies" : "y", " in this file.");
        int i = 0;
        for (XMLGeometry geom : geoms) {
            JAGTLog.debug("Handling geometry ", i++);
            Geometry loadedGeom = LibraryGeometriesLoader.loadGeom(geom);
            if (loadedGeom == null) continue;
            colladaLibGeoms.getGeometries().put(loadedGeom.getId(), loadedGeom);
        }
        return colladaLibGeoms;
    }

    static Geometry loadGeom(XMLGeometry geom) {
        TrianglesGeometry colGeom = null;
        XMLMesh mesh = geom.mesh;
        String verticesSource = mesh.vertices.inputs.get((int)0).source;
        ArrayList<XMLSource> sources = mesh.sources;
        HashMap<String, XMLSource> sourcesMap = LibraryGeometriesLoader.getSourcesMap(mesh, verticesSource, sources);
        XMLTriangles tris = mesh.triangles;
        if (tris != null) {
            JAGTLog.debug("TT] Primitives of type triangles");
            JAGTLog.debug("TT] Polygon count = ", tris.count);
            colGeom = LibraryGeometriesLoader.loadTriangles(geom, tris, sourcesMap);
        } else {
            JAGTLog.debug("EE] Can't load object : ", geom.name, " because couldn't find a supported element type...", "\n (note that the only well supported type is triangles, so e.g.", "\n in Blender, activate the appropriate option in the export script");
        }
        return colGeom;
    }

    static HashMap<String, XMLSource> getSourcesMap(XMLMesh mesh, String verticesSource, List<XMLSource> sources) {
        HashMap<String, XMLSource> sourcesMap = new HashMap<String, XMLSource>();
        int i = 0;
        while (i < sources.size()) {
            XMLSource source = sources.get(i);
            if (verticesSource.equals(source.id)) {
                sourcesMap.put(mesh.vertices.id, source);
                JAGTLog.debug("TT] Source ", i, " ID = ", mesh.vertices.id);
            } else {
                sourcesMap.put(source.id, source);
                JAGTLog.debug("TT] Source ", i, " ID = ", source.id);
            }
            ++i;
        }
        return sourcesMap;
    }

    static TrianglesGeometry loadTriangles(XMLGeometry geom, XMLTriangles tris, HashMap<String, XMLSource> sourcesMap) {
        int i;
        TrianglesGeometry trianglesGeometry = new TrianglesGeometry(null, geom.id, geom.name, geom);
        MeshSources sources = new MeshSources();
        MeshDataInfo meshDataInfo = LibraryGeometriesLoader.getMeshDataInfo(tris.inputs, sourcesMap, sources);
        Mesh mesh = new Mesh(sources);
        trianglesGeometry.setMesh(mesh);
        int[] indices = tris.p;
        int count = 0;
        int indexCount = indices.length / meshDataInfo.maxOffset;
        if (meshDataInfo.vertexOffset != -1) {
            mesh.setVertexIndices(new int[indexCount]);
        }
        if (meshDataInfo.normalOffset != -1) {
            mesh.setNormalIndices(new int[indexCount]);
        }
        if (meshDataInfo.colorOffset != -1) {
            mesh.setColorIndices(new int[indexCount]);
        }
        if (meshDataInfo.uvOffsets != null) {
            int[][] uvIndices = new int[meshDataInfo.uvOffsets.length][];
            i = 0;
            while (i < meshDataInfo.uvOffsets.length) {
                uvIndices[i] = new int[indexCount];
                ++i;
            }
            mesh.setUVIndices(uvIndices);
        }
        int k = 0;
        while (k < indices.length) {
            if (meshDataInfo.vertexOffset != -1) {
                mesh.getVertexIndices()[count] = indices[k + meshDataInfo.vertexOffset];
            }
            if (meshDataInfo.normalOffset != -1) {
                mesh.getNormalIndices()[count] = indices[k + meshDataInfo.normalOffset];
            }
            if (meshDataInfo.colorOffset != -1) {
                mesh.getColorIndices()[count] = indices[k + meshDataInfo.colorOffset];
            }
            if (meshDataInfo.uvOffsets != null) {
                i = 0;
                while (i < meshDataInfo.uvOffsets.length) {
                    mesh.getUVIndices()[i][count] = indices[k + meshDataInfo.uvOffsets[i]];
                    ++i;
                }
            }
            ++count;
            k += meshDataInfo.maxOffset;
        }
        return trianglesGeometry;
    }

    static MeshDataInfo getMeshDataInfo(List<XMLInput> inputs, HashMap<String, XMLSource> sourcesMap, MeshSources sources) {
        MeshDataInfo meshDataInfo = new MeshDataInfo();
        sources.setUVs(null);
        int[] uvOffsets = new int[inputs.size()];
        int numUVOffsets = 0;
        JAGTLog.debug("TT] Parsing semantics....");
        int j = 0;
        while (j < inputs.size()) {
            XMLSource source;
            XMLInput input = inputs.get(j);
            JAGTLog.debug("TT] Input semantic ", input.semantic, ", offset ", input.offset, ", from source = ", input.source);
            if (input.offset > meshDataInfo.maxOffset) {
                meshDataInfo.maxOffset = input.offset;
            }
            if (input.semantic.equals("VERTEX")) {
                meshDataInfo.vertexOffset = input.offset;
                source = sourcesMap.get(input.source);
                sources.setVertices(source.floatArray.floats);
            } else if (input.semantic.equals("NORMAL")) {
                meshDataInfo.normalOffset = input.offset;
                source = sourcesMap.get(input.source);
                sources.setNormals(source.floatArray.floats);
            } else if (input.semantic.equals("TEXCOORD")) {
                uvOffsets[numUVOffsets++] = input.offset;
                source = sourcesMap.get(input.source);
                sources.addUV(source.floatArray.floats);
            } else if (input.semantic.equals("COLOR")) {
                meshDataInfo.colorOffset = input.offset;
                source = sourcesMap.get(input.source);
                sources.setColors(source.floatArray.floats);
            } else {
                JAGTLog.debug("EE] We don't know that semantic :", input.semantic, " ! Ignoring..");
            }
            ++j;
        }
        if (numUVOffsets > 0) {
            meshDataInfo.uvOffsets = new int[numUVOffsets];
            System.arraycopy(uvOffsets, 0, meshDataInfo.uvOffsets, 0, numUVOffsets);
        } else {
            meshDataInfo.uvOffsets = null;
        }
        ++meshDataInfo.maxOffset;
        return meshDataInfo;
    }
}

