/*
 * Decompiled with CFR 0.152.
 */
package org.jagatoo.loaders.models.collada;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import org.jagatoo.loaders.models.collada.SkeletonLoader;
import org.jagatoo.loaders.models.collada.datastructs.AssetFolder;
import org.jagatoo.loaders.models.collada.datastructs.animation.Skeleton;
import org.jagatoo.loaders.models.collada.datastructs.controllers.Controller;
import org.jagatoo.loaders.models.collada.datastructs.controllers.SkeletalController;
import org.jagatoo.loaders.models.collada.datastructs.visualscenes.ControllerInstance;
import org.jagatoo.loaders.models.collada.datastructs.visualscenes.GeometryInstance;
import org.jagatoo.loaders.models.collada.datastructs.visualscenes.LibraryVisualScenes;
import org.jagatoo.loaders.models.collada.datastructs.visualscenes.MatrixTransform;
import org.jagatoo.loaders.models.collada.datastructs.visualscenes.Node;
import org.jagatoo.loaders.models.collada.datastructs.visualscenes.Scene;
import org.jagatoo.loaders.models.collada.stax.XMLBindMaterial;
import org.jagatoo.loaders.models.collada.stax.XMLInstanceController;
import org.jagatoo.loaders.models.collada.stax.XMLInstanceGeometry;
import org.jagatoo.loaders.models.collada.stax.XMLInstanceMaterial;
import org.jagatoo.loaders.models.collada.stax.XMLLibraryVisualScenes;
import org.jagatoo.loaders.models.collada.stax.XMLNode;
import org.jagatoo.loaders.models.collada.stax.XMLVisualScene;
import org.jagatoo.logging.JAGTLog;
import org.openmali.vecmath2.Vector3f;

public class LibraryVisualScenesLoader {
    static void loadLibraryVisualScenes(AssetFolder colladaFile, XMLLibraryVisualScenes libScenes, Vector3f upVector) {
        LibraryVisualScenes colLibVisualScenes = colladaFile.getLibraryVisualsScenes();
        HashMap<String, Scene> scenes = colLibVisualScenes.getScenes();
        Collection<XMLVisualScene> visualScenes = libScenes.scenes.values();
        JAGTLog.increaseIndentation();
        for (XMLVisualScene visualScene : visualScenes) {
            Scene colScene = new Scene(visualScene.id, visualScene.name);
            scenes.put(colScene.getId(), colScene);
            JAGTLog.debug("TT] Found scene [", colScene.getId(), ":", colScene.getName(), "]");
            JAGTLog.increaseIndentation();
            for (XMLNode node : visualScene.nodes.values()) {
                Node colNode = LibraryVisualScenesLoader.processNode(node, colLibVisualScenes, colladaFile, upVector);
                if (colNode == null || node.type == XMLNode.Type.JOINT) continue;
                JAGTLog.debug("TT] Successfully adding colNode ", colNode.getId());
                colScene.getNodes().put(colNode.getId(), colNode);
            }
            JAGTLog.decreaseIndentation();
        }
        JAGTLog.decreaseIndentation();
    }

    static Node processNode(XMLNode node, LibraryVisualScenes colLibVisualScenes, AssetFolder colladaFile, Vector3f upVector) {
        JAGTLog.debug("TT] Found node [", node.id, ":", node.name, "]");
        JAGTLog.increaseIndentation();
        Node colNode = new Node(colladaFile, node.id, node.name, new MatrixTransform(node.matrix.matrix4f));
        if (node.type == XMLNode.Type.NODE) {
            for (XMLNode child : node.childrenList) {
                colNode.addChild(LibraryVisualScenesLoader.processNode(child, colLibVisualScenes, colladaFile, upVector));
            }
            JAGTLog.debug("TT] Alright, it's a basic node");
            if (node.instanceGeometries != null && !node.instanceGeometries.isEmpty()) {
                JAGTLog.debug("TT] A geometry node!");
                for (XMLInstanceGeometry instanceGeometry : node.instanceGeometries) {
                    colNode.addGeometryInstance(LibraryVisualScenesLoader.newCOLLADAGeometryInstanceNode(colladaFile, node, instanceGeometry.url, instanceGeometry.bindMaterial));
                }
            } else if (node.instanceControllers != null && !node.instanceControllers.isEmpty()) {
                JAGTLog.debug("TT] A controller node!");
                for (XMLInstanceController instanceController : node.instanceControllers) {
                    colNode.addControllerInstance(LibraryVisualScenesLoader.newCOLLADAControllerInstanceNode(colladaFile, node, instanceController.url, instanceController.bindMaterial));
                    Controller controller = colladaFile.getLibraryControllers().getControllers().get(instanceController.url);
                    if (!(controller instanceof SkeletalController)) continue;
                    SkeletalController skelController = (SkeletalController)controller;
                    JAGTLog.debug("Wow! It's a Skeletal Controller Node!");
                    skelController.setSkeleton(colLibVisualScenes.getSkeletons().get(instanceController.skeleton));
                    skelController.setDestinationMesh(colladaFile.getLibraryGeometries().getGeometries().get(skelController.getSourceMeshId()));
                }
            }
        } else if (node.type == XMLNode.Type.JOINT) {
            JAGTLog.debug("TT] Alright, it's a skeleton node");
            Skeleton skeleton = SkeletonLoader.loadSkeleton(node, upVector);
            colLibVisualScenes.getSkeletons().put(node.id, skeleton);
            Collection<Controller> controllers = colladaFile.getLibraryControllers().getControllers().values();
            for (Controller controller : controllers) {
                if (!(controller instanceof SkeletalController)) continue;
                SkeletalController skelController = (SkeletalController)controller;
                if (!node.id.equals(skelController.getController().skin.source)) continue;
                skelController.setSkeleton(skeleton);
            }
        } else {
            JAGTLog.debug(new Object[]{"TT] Node is of type : ", node.type, " we don't support specific nodes yet..."});
        }
        JAGTLog.decreaseIndentation();
        return colNode;
    }

    static GeometryInstance newCOLLADAGeometryInstanceNode(AssetFolder colladaFile, XMLNode node, String geometryUrl, XMLBindMaterial bindMaterial) {
        String materialUrl = null;
        XMLBindMaterial.TechniqueCommon techniqueCommon = bindMaterial.techniqueCommon;
        ArrayList<XMLInstanceMaterial> instanceMaterialList = techniqueCommon.instanceMaterials;
        for (XMLInstanceMaterial instanceMaterial : instanceMaterialList) {
            if (materialUrl == null) {
                materialUrl = instanceMaterial.target;
                continue;
            }
            JAGTLog.debug("TT] Several materials for the same geometry instance ! Skipping....");
        }
        GeometryInstance colNode = new GeometryInstance(colladaFile, node.id, node.name, geometryUrl, materialUrl);
        return colNode;
    }

    static ControllerInstance newCOLLADAControllerInstanceNode(AssetFolder colladaFile, XMLNode node, String controllerUrl, XMLBindMaterial bindMaterial) {
        String materialUrl = null;
        XMLBindMaterial.TechniqueCommon techniqueCommon = bindMaterial.techniqueCommon;
        ArrayList<XMLInstanceMaterial> instanceMaterialList = techniqueCommon.instanceMaterials;
        for (XMLInstanceMaterial instanceMaterial : instanceMaterialList) {
            if (materialUrl == null) {
                materialUrl = instanceMaterial.target;
                continue;
            }
            JAGTLog.debug("TT] Several materials for the same controller instance ! Skipping....");
        }
        ControllerInstance colNode = new ControllerInstance(colladaFile, node.id, node.name, controllerUrl, materialUrl);
        return colNode;
    }
}

