/*
 * Decompiled with CFR 0.152.
 */
package org.jagatoo.loaders.models.collada.datastructs.geometries;

public class MeshSources {
    private float[] vertices = null;
    private float[] normals = null;
    private float[] colors = null;
    private float[][] uvs = null;

    public void setVertices(float[] vertices) {
        this.vertices = vertices;
    }

    public final float[] getVertices() {
        return this.vertices;
    }

    public void setNormals(float[] normals) {
        this.normals = normals;
    }

    public final float[] getNormals() {
        return this.normals;
    }

    public void setColors(float[] colors) {
        this.colors = colors;
    }

    public final float[] getColors() {
        return this.colors;
    }

    public void setUVs(float[][] uvs) {
        this.uvs = uvs;
    }

    public void addUV(float[] uv) {
        if (this.uvs == null) {
            this.uvs = new float[][]{uv};
        } else {
            float[][] newUVs = new float[this.uvs.length + 1][];
            System.arraycopy(this.uvs, 0, newUVs, 0, this.uvs.length);
            this.uvs = newUVs;
            this.uvs[this.uvs.length - 1] = uv;
        }
    }

    public final float[][] getUVs() {
        return this.uvs;
    }

    public MeshSources copy() {
        MeshSources newMS = new MeshSources();
        newMS.vertices = new float[this.vertices.length];
        System.arraycopy(this.vertices, 0, newMS.vertices, 0, this.vertices.length);
        if (this.normals != null) {
            newMS.normals = new float[this.normals.length];
            System.arraycopy(this.normals, 0, newMS.normals, 0, this.normals.length);
        }
        if (this.colors != null) {
            newMS.colors = new float[this.colors.length];
            System.arraycopy(this.colors, 0, newMS.colors, 0, this.colors.length);
        }
        if (this.uvs != null) {
            newMS.uvs = new float[this.uvs.length][];
            int i = 0;
            while (i < this.uvs.length) {
                float[] uv = this.uvs[i];
                float[] newUV = new float[uv.length];
                System.arraycopy(uv, 0, newUV, 0, uv.length);
                newMS.uvs[i] = newUV;
                ++i;
            }
            System.arraycopy(this.uvs, 0, newMS.uvs, 0, this.uvs.length);
        }
        return newMS;
    }
}

