/*
 * Decompiled with CFR 0.152.
 */
package org.jagatoo.loaders.models.collada.stax;

import java.util.ArrayList;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jagatoo.loaders.models.collada.datastructs.animation.KeyFrame;
import org.jagatoo.loaders.models.collada.stax.XMLAsset;
import org.jagatoo.loaders.models.collada.stax.XMLChannel;
import org.jagatoo.loaders.models.collada.stax.XMLSampler;
import org.jagatoo.loaders.models.collada.stax.XMLSource;
import org.jagatoo.logging.JAGTLog;
import org.jagatoo.util.errorhandling.IncorrectFormatException;

public class XMLAnimation {
    public String id = null;
    public String name = null;
    public XMLAsset asset = null;
    public ArrayList<XMLSource> sources = new ArrayList();
    public ArrayList<XMLSampler> samplers = new ArrayList();
    public ArrayList<XMLChannel> channels = new ArrayList();

    public XMLSource getSource(String id) {
        for (XMLSource source : this.sources) {
            if (!source.id.equals(id)) continue;
            return source;
        }
        throw new IncorrectFormatException("Could not find source with id " + id);
    }

    public String getTargetBone() {
        return this.channels.get(0).getTargetBone();
    }

    public float[] getInput() {
        return this.getSource((String)this.samplers.get((int)0).getInput((String)"INPUT").source).floatArray.floats;
    }

    public float[] getOutput() {
        return this.getSource((String)this.samplers.get((int)0).getInput((String)"OUTPUT").source).floatArray.floats;
    }

    public XMLChannel.ChannelType getType() {
        return this.channels.get((int)0).type;
    }

    public KeyFrame.Axis getRotationAxis() {
        return this.channels.get(0).getRotationAxis();
    }

    public void parse(XMLStreamReader parser) throws XMLStreamException {
        int i = 0;
        while (i < parser.getAttributeCount()) {
            QName attr = parser.getAttributeName(i);
            if (attr.getLocalPart().equals("id")) {
                this.id = parser.getAttributeValue(i);
            } else if (attr.getLocalPart().equals("name")) {
                this.name = parser.getAttributeValue(i);
            } else {
                JAGTLog.exception("Unsupported ", this.getClass().getSimpleName(), " Attr tag: ", attr.getLocalPart());
            }
            ++i;
        }
        int event = parser.next();
        while (event != 8) {
            switch (event) {
                case 1: {
                    String localName = parser.getLocalName();
                    if (localName.equals("asset")) {
                        if (this.asset != null) {
                            JAGTLog.exception("Unsupported ", this.getClass().getSimpleName(), " too many: ", parser.getLocalName(), " tags.");
                        }
                        this.asset = new XMLAsset();
                        this.asset.parse(parser);
                        break;
                    }
                    if (localName.equals("sampler")) {
                        XMLSampler sampler = new XMLSampler();
                        sampler.parse(parser);
                        this.samplers.add(sampler);
                        break;
                    }
                    if (localName.equals("source")) {
                        XMLSource src = new XMLSource();
                        src.parse(parser);
                        this.sources.add(src);
                        break;
                    }
                    if (localName.equals("channel")) {
                        XMLChannel channel = new XMLChannel();
                        channel.parse(parser);
                        this.channels.add(channel);
                        break;
                    }
                    JAGTLog.exception("Unsupported ", this.getClass().getSimpleName(), " Start tag: ", parser.getLocalName());
                    break;
                }
                case 2: {
                    if (!parser.getLocalName().equals("animation")) break;
                    return;
                }
            }
            event = parser.next();
        }
    }
}

