/*
 * Decompiled with CFR 0.152.
 */
package org.jagatoo.loaders.models.collada.stax;

import java.util.StringTokenizer;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jagatoo.loaders.models.collada.datastructs.animation.KeyFrame;
import org.jagatoo.loaders.models.collada.stax.XMLIDREFUtils;
import org.jagatoo.logging.JAGTLog;
import org.jagatoo.util.errorhandling.IncorrectFormatException;

public class XMLChannel {
    public ChannelType type;
    public static final String TRANSLATE_TARGET = "translate";
    public static final String ROTATE_TARGET = "rotate";
    public static final String SCALE_TARGET = "scale";
    public String source = null;
    public String target = null;
    private String targetBone = null;
    private KeyFrame.Axis targetAxis;

    public String getTargetBone() {
        this.checkIsParsed();
        return this.targetBone;
    }

    public KeyFrame.Axis getRotationAxis() {
        this.checkIsParsed();
        if (this.type != ChannelType.ROTATE) {
            throw new IncorrectFormatException("It is not a rotation key frame, it's a " + (Object)((Object)this.type));
        }
        return this.targetAxis;
    }

    private void checkIsParsed() {
        if (this.targetBone == null) {
            StringTokenizer tok = new StringTokenizer(this.target);
            this.targetBone = tok.nextToken("/");
            String trans = tok.nextToken();
            if (trans.startsWith(TRANSLATE_TARGET)) {
                this.type = ChannelType.TRANSLATE;
            } else if (trans.startsWith(ROTATE_TARGET)) {
                this.type = ChannelType.ROTATE;
                this.targetAxis = trans.contains("rotateX") ? KeyFrame.Axis.X : (trans.contains("rotateY") ? KeyFrame.Axis.Y : KeyFrame.Axis.Z);
            } else {
                trans.startsWith(SCALE_TARGET);
            }
        }
    }

    public void parse(XMLStreamReader parser) throws XMLStreamException {
        int i = 0;
        while (i < parser.getAttributeCount()) {
            QName attr = parser.getAttributeName(i);
            if (attr.getLocalPart().equals("source")) {
                this.source = XMLIDREFUtils.parse(parser.getAttributeValue(i));
            } else if (attr.getLocalPart().equals("target")) {
                this.target = XMLIDREFUtils.parse(parser.getAttributeValue(i));
            } else {
                JAGTLog.exception("Unsupported ", this.getClass().getSimpleName(), " Attr tag: ", attr.getLocalPart());
            }
            ++i;
        }
        int event = parser.next();
        while (event != 8) {
            switch (event) {
                case 2: {
                    if (!parser.getLocalName().equals("channel")) break;
                    return;
                }
            }
            event = parser.next();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ChannelType {
        TRANSLATE,
        ROTATE,
        SCALE;

    }
}

