/*
 * Decompiled with CFR 0.152.
 */
package org.jagatoo.loaders.models.collada.stax;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jagatoo.loaders.models.collada.stax.XMLAsset;
import org.jagatoo.loaders.models.collada.stax.XMLMesh;
import org.jagatoo.logging.JAGTLog;

public class XMLGeometry {
    public XMLAsset asset = null;
    public String id = null;
    public String name = null;
    public XMLMesh mesh = null;
    public Object convexMesh = null;

    public void parseAttributes(XMLStreamReader parser) {
        int i = 0;
        while (i < parser.getAttributeCount()) {
            QName attr = parser.getAttributeName(i);
            if (attr.getLocalPart().equals("id")) {
                this.id = parser.getAttributeValue(i);
            } else if (attr.getLocalPart().equals("name")) {
                this.name = parser.getAttributeValue(i);
            }
            ++i;
        }
    }

    public void parse(XMLStreamReader parser) throws XMLStreamException {
        int i = 0;
        while (i < parser.getAttributeCount()) {
            QName attr = parser.getAttributeName(i);
            if (attr.getLocalPart().equals("id")) {
                this.id = parser.getAttributeValue(i);
            } else if (attr.getLocalPart().equals("name")) {
                this.name = parser.getAttributeValue(i);
            } else {
                JAGTLog.exception("Unsupported ", this.getClass().getSimpleName(), " Attr tag: ", parser.getLocalName());
            }
            ++i;
        }
        int event = parser.next();
        while (event != 8) {
            switch (event) {
                case 1: {
                    String localName = parser.getLocalName();
                    if (localName.equals("geometry")) {
                        this.parseAttributes(parser);
                        break;
                    }
                    if (localName.equals("asset")) {
                        this.asset = new XMLAsset();
                        this.asset.parse(parser);
                        break;
                    }
                    if (localName.equals("mesh")) {
                        this.mesh = new XMLMesh();
                        this.mesh.parse(parser);
                        break;
                    }
                    JAGTLog.exception("Unsupported ", this.getClass().getSimpleName(), " Start tag: ", parser.getLocalName());
                    break;
                }
                case 2: {
                    if (!parser.getLocalName().equals("geometry")) break;
                    return;
                }
            }
            event = parser.next();
        }
    }
}

