/*
 * Decompiled with CFR 0.152.
 */
package org.jagatoo.loaders.models.collada.stax;

import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jagatoo.loaders.models.collada.stax.XMLIDREFUtils;
import org.jagatoo.logging.JAGTLog;

public class XMLInstanceEffect {
    public String sid = null;
    public String name = null;
    public String url = null;

    public void parse(XMLStreamReader parser) throws XMLStreamException {
        this.doParsing(parser);
        Location loc = parser.getLocation();
        if (this.url == null) {
            JAGTLog.exception(loc.getLineNumber(), ":", loc.getColumnNumber(), " ", this.getClass().getSimpleName(), ": missing url.");
        }
    }

    private void doParsing(XMLStreamReader parser) throws XMLStreamException {
        int i = 0;
        while (i < parser.getAttributeCount()) {
            QName attr = parser.getAttributeName(i);
            if (attr.getLocalPart().equals("sid")) {
                this.sid = parser.getAttributeValue(i);
            } else if (attr.getLocalPart().equals("name")) {
                this.name = parser.getAttributeValue(i);
            } else if (attr.getLocalPart().equals("url")) {
                this.url = XMLIDREFUtils.parse(parser.getAttributeValue(i));
            } else {
                JAGTLog.exception("Unsupported ", this.getClass().getSimpleName(), " Attr tag: ", attr.getLocalPart());
            }
            ++i;
        }
        int event = parser.next();
        while (event != 8) {
            switch (event) {
                case 1: {
                    JAGTLog.exception("Unsupported ", this.getClass().getSimpleName(), " Start tag: ", parser.getLocalName());
                    break;
                }
                case 2: {
                    if (!parser.getLocalName().equals("instance_effect")) break;
                    return;
                }
            }
            event = parser.next();
        }
    }
}

