/*
 * Decompiled with CFR 0.152.
 */
package org.jagatoo.loaders.models.collada.stax;

import java.util.ArrayList;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jagatoo.loaders.models.collada.stax.XMLBindVertexInput;
import org.jagatoo.loaders.models.collada.stax.XMLIDREFUtils;
import org.jagatoo.logging.JAGTLog;

public class XMLInstanceMaterial {
    public String sid = null;
    public String name = null;
    public String symbol = null;
    public String target = null;
    public ArrayList<XMLBindVertexInput> bindVertexInputs = new ArrayList();

    public void parse(XMLStreamReader parser) throws XMLStreamException {
        this.doParsing(parser);
        Location loc = parser.getLocation();
        if (this.target == null) {
            JAGTLog.exception(loc.getLineNumber(), ":", loc.getColumnNumber(), " ", this.getClass().getSimpleName(), ": missing target.");
        }
        if (this.symbol == null) {
            JAGTLog.exception(loc.getLineNumber(), ":", loc.getColumnNumber(), " ", this.getClass().getSimpleName(), ": missing symbol.");
        }
    }

    private void doParsing(XMLStreamReader parser) throws XMLStreamException {
        int i = 0;
        while (i < parser.getAttributeCount()) {
            QName attr = parser.getAttributeName(i);
            if (attr.getLocalPart().equals("sid")) {
                this.sid = parser.getAttributeValue(i);
            } else if (attr.getLocalPart().equals("name")) {
                this.name = parser.getAttributeValue(i);
            } else if (attr.getLocalPart().equals("target")) {
                this.target = XMLIDREFUtils.parse(parser.getAttributeValue(i));
            } else if (attr.getLocalPart().equals("symbol")) {
                this.symbol = parser.getAttributeValue(i);
            } else {
                JAGTLog.exception("Unsupported ", this.getClass().getSimpleName(), " Attr tag: ", attr.getLocalPart());
            }
            ++i;
        }
        int event = parser.next();
        while (event != 8) {
            switch (event) {
                case 1: {
                    String localName = parser.getLocalName();
                    if (localName.equals("bind_vertex_input")) {
                        XMLBindVertexInput vertInput = new XMLBindVertexInput();
                        vertInput.parse(parser);
                        this.bindVertexInputs.add(vertInput);
                        break;
                    }
                    JAGTLog.exception("Unsupported ", this.getClass().getSimpleName(), " Start tag: ", parser.getLocalName());
                    break;
                }
                case 2: {
                    if (!parser.getLocalName().equals("instance_material")) break;
                    return;
                }
            }
            event = parser.next();
        }
    }
}

