/*
 * Decompiled with CFR 0.152.
 */
package org.jagatoo.loaders.models.collada.stax;

import java.util.StringTokenizer;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jagatoo.logging.JAGTLog;

public class XMLIntArray {
    public int count;
    public String id;
    public int[] ints;

    public static int[] toArray(String intValues) {
        StringTokenizer tknz = new StringTokenizer(intValues);
        int count = tknz.countTokens();
        int[] ints = new int[count];
        int i = 0;
        while (i < count) {
            ints[i] = Integer.parseInt(tknz.nextToken());
            ++i;
        }
        return ints;
    }

    public void parse(XMLStreamReader parser, String endTag) throws XMLStreamException {
        int i = 0;
        while (i < parser.getAttributeCount()) {
            QName attr = parser.getAttributeName(i);
            if (attr.getLocalPart().equals("id")) {
                this.id = parser.getAttributeValue(i);
            } else if (attr.getLocalPart().equals("count")) {
                this.count = Integer.parseInt(parser.getAttributeValue(i).trim());
            } else {
                JAGTLog.exception("Unsupported ", this.getClass().getSimpleName(), " Attr tag: ", attr.getLocalPart());
            }
            ++i;
        }
        int event = parser.next();
        while (event != 8) {
            switch (event) {
                case 1: {
                    JAGTLog.exception("Unsupported ", this.getClass().getSimpleName(), " Start tag: ", parser.getLocalName());
                    break;
                }
                case 4: {
                    this.ints = XMLIntArray.toArray(parser.getText());
                    break;
                }
                case 2: {
                    if (!parser.getLocalName().equals(endTag)) break;
                    return;
                }
            }
            event = parser.next();
        }
    }
}

