/*
 * Decompiled with CFR 0.152.
 */
package org.jagatoo.loaders.models.collada.stax;

import java.util.ArrayList;
import java.util.HashMap;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jagatoo.loaders.models.collada.stax.XMLImage;
import org.jagatoo.logging.JAGTLog;

public class XMLLibraryImages {
    private ArrayList<XMLImage> imagesList = new ArrayList();
    public HashMap<String, XMLImage> images = null;

    public void readImages() {
        this.images = new HashMap();
        for (XMLImage image : this.imagesList) {
            this.images.put(image.id, image);
        }
        this.imagesList = null;
    }

    public void parse(XMLStreamReader parser) throws XMLStreamException {
        this.doParsing(parser);
        Location loc = parser.getLocation();
        if (this.imagesList.isEmpty()) {
            JAGTLog.exception(loc.getLineNumber(), ":", loc.getColumnNumber(), " ", this.getClass().getSimpleName(), ": missing images.");
        }
        this.readImages();
    }

    private void doParsing(XMLStreamReader parser) throws XMLStreamException {
        int event = parser.next();
        while (event != 8) {
            switch (event) {
                case 1: {
                    String localName = parser.getLocalName();
                    if (localName.equals("image")) {
                        XMLImage img = new XMLImage();
                        img.parse(parser);
                        this.imagesList.add(img);
                        break;
                    }
                    JAGTLog.exception("Unsupported ", this.getClass().getSimpleName(), " Start tag: ", parser.getLocalName());
                    break;
                }
                case 2: {
                    if (!parser.getLocalName().equals("library_images")) break;
                    return;
                }
            }
            event = parser.next();
        }
    }
}

