/*
 * Decompiled with CFR 0.152.
 */
package org.jagatoo.loaders.models.collada.stax;

import java.util.ArrayList;
import java.util.HashMap;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jagatoo.loaders.models.collada.stax.XMLMaterial;
import org.jagatoo.logging.JAGTLog;

public class XMLLibraryMaterials {
    private ArrayList<XMLMaterial> materialsList = new ArrayList();
    public HashMap<String, XMLMaterial> materials;

    public void readMaterials() {
        this.materials = new HashMap();
        for (XMLMaterial material : this.materialsList) {
            this.materials.put(material.id, material);
        }
        this.materialsList = null;
    }

    public void parse(XMLStreamReader parser) throws XMLStreamException {
        this.doParsing(parser);
        Location loc = parser.getLocation();
        if (this.materialsList.isEmpty()) {
            JAGTLog.exception(loc.getLineNumber(), ":", loc.getColumnNumber(), " ", this.getClass().getSimpleName(), ": missing materials.");
        }
        this.readMaterials();
    }

    private void doParsing(XMLStreamReader parser) throws XMLStreamException {
        int event = parser.next();
        while (event != 8) {
            switch (event) {
                case 1: {
                    String localName = parser.getLocalName();
                    if (localName.equals("material")) {
                        XMLMaterial material = new XMLMaterial();
                        material.parse(parser);
                        this.materialsList.add(material);
                        break;
                    }
                    JAGTLog.exception("Unsupported ", this.getClass().getSimpleName(), " Start tag: ", parser.getLocalName());
                    break;
                }
                case 2: {
                    if (!parser.getLocalName().equals("library_materials")) break;
                    return;
                }
            }
            event = parser.next();
        }
    }
}

