/*
 * Decompiled with CFR 0.152.
 */
package org.jagatoo.loaders.models.collada.stax;

import java.util.ArrayList;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jagatoo.loaders.models.collada.stax.XMLSource;
import org.jagatoo.loaders.models.collada.stax.XMLTriangles;
import org.jagatoo.loaders.models.collada.stax.XMLVertices;
import org.jagatoo.logging.JAGTLog;

public class XMLMesh {
    public ArrayList<XMLSource> sources = new ArrayList();
    public XMLVertices vertices = null;
    public XMLTriangles triangles = null;

    public void parse(XMLStreamReader parser) throws XMLStreamException {
        this.doParsing(parser);
        Location loc = parser.getLocation();
        if (this.sources.isEmpty()) {
            JAGTLog.exception(loc.getLineNumber(), ":", loc.getColumnNumber(), " ", this.getClass().getSimpleName(), ": missing sources.");
        }
        if (this.vertices == null) {
            JAGTLog.exception(loc.getLineNumber(), ":", loc.getColumnNumber(), " ", this.getClass().getSimpleName(), ": missing vertices.");
        }
        if (this.triangles == null) {
            JAGTLog.exception(loc.getLineNumber(), ":", loc.getColumnNumber(), " ", this.getClass().getSimpleName(), ": missing triangles.");
        }
    }

    private void doParsing(XMLStreamReader parser) throws XMLStreamException {
        int event = parser.next();
        while (event != 8) {
            switch (event) {
                case 1: {
                    String localName = parser.getLocalName();
                    if (localName.equals("source")) {
                        XMLSource source = new XMLSource();
                        source.parse(parser);
                        this.sources.add(source);
                        break;
                    }
                    if (localName.equals("vertices")) {
                        this.vertices = new XMLVertices();
                        this.vertices.parse(parser);
                        break;
                    }
                    if (localName.equals("triangles")) {
                        this.triangles = new XMLTriangles();
                        this.triangles.parse(parser);
                        break;
                    }
                    JAGTLog.exception("Unsupported ", this.getClass().getSimpleName(), " Start tag: ", parser.getLocalName());
                    break;
                }
                case 2: {
                    if (!parser.getLocalName().equals("mesh")) break;
                    return;
                }
            }
            event = parser.next();
        }
    }
}

