/*
 * Decompiled with CFR 0.152.
 */
package org.jagatoo.loaders.models.collada.stax;

import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jagatoo.loaders.models.collada.stax.StAXHelper;
import org.jagatoo.loaders.models.collada.stax.XMLAsset;
import org.jagatoo.loaders.models.collada.stax.XMLInstanceController;
import org.jagatoo.loaders.models.collada.stax.XMLInstanceGeometry;
import org.jagatoo.loaders.models.collada.stax.XMLMatrix4x4;
import org.jagatoo.loaders.models.collada.stax.XMLMatrixUtils;
import org.jagatoo.logging.JAGTLog;
import org.jagatoo.util.errorhandling.ParsingException;
import org.openmali.FastMath;
import org.openmali.vecmath2.Matrix4f;
import org.openmali.vecmath2.Point3f;
import org.openmali.vecmath2.Tuple3f;
import org.openmali.vecmath2.util.MatrixUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLNode {
    public ArrayList<String> layers = null;
    public String sid = null;
    public XMLAsset asset = null;
    public Type type = Type.NODE;
    public String id = null;
    public String name = null;
    public XMLMatrix4x4 matrix = new XMLMatrix4x4();
    public ArrayList<XMLInstanceGeometry> instanceGeometries = new ArrayList();
    public ArrayList<XMLInstanceController> instanceControllers = new ArrayList();
    public ArrayList<XMLNode> childrenList = new ArrayList();

    public static ArrayList<String> parseLayerList(String str) {
        ArrayList<String> layers = new ArrayList<String>();
        StringTokenizer tknz = new StringTokenizer(str);
        while (tknz.hasMoreTokens()) {
            layers.add(tknz.nextToken());
        }
        return layers;
    }

    public void applyTranslate(String str) {
        StringTokenizer tknz = new StringTokenizer(str);
        Point3f translate = new Point3f(Float.parseFloat(tknz.nextToken()), Float.parseFloat(tknz.nextToken()), Float.parseFloat(tknz.nextToken()));
        Matrix4f mat = new Matrix4f();
        mat.setIdentity();
        mat.setTranslation((Tuple3f)translate);
        this.matrix.matrix4f.mul(mat);
    }

    public void applyRotate(String str) {
        StringTokenizer tknz = new StringTokenizer(str);
        Tuple3f rotate = new Tuple3f(Float.parseFloat(tknz.nextToken()), Float.parseFloat(tknz.nextToken()), Float.parseFloat(tknz.nextToken()));
        float angle = FastMath.toRad((float)Float.parseFloat(tknz.nextToken()));
        rotate.mul(angle);
        Matrix4f mat = MatrixUtils.eulerToMatrix4f((Tuple3f)rotate);
        this.matrix.matrix4f.mul(mat);
    }

    public void applyScale(String str) {
        StringTokenizer tknz = new StringTokenizer(str);
        Point3f scale = new Point3f(Float.parseFloat(tknz.nextToken()), Float.parseFloat(tknz.nextToken()), Float.parseFloat(tknz.nextToken()));
        this.matrix.matrix4f.mul(0, 0, scale.getX());
        this.matrix.matrix4f.mul(0, 1, scale.getX());
        this.matrix.matrix4f.mul(0, 2, scale.getX());
        this.matrix.matrix4f.mul(0, 3, scale.getX());
        this.matrix.matrix4f.mul(1, 0, scale.getY());
        this.matrix.matrix4f.mul(1, 1, scale.getY());
        this.matrix.matrix4f.mul(1, 2, scale.getY());
        this.matrix.matrix4f.mul(1, 3, scale.getY());
        this.matrix.matrix4f.mul(2, 0, scale.getZ());
        this.matrix.matrix4f.mul(2, 1, scale.getZ());
        this.matrix.matrix4f.mul(2, 2, scale.getZ());
        this.matrix.matrix4f.mul(2, 3, scale.getZ());
    }

    public void parse(XMLStreamReader parser) throws XMLStreamException {
        int i = 0;
        while (i < parser.getAttributeCount()) {
            QName attr = parser.getAttributeName(i);
            if (attr.getLocalPart().equals("id")) {
                this.id = parser.getAttributeValue(i);
            } else if (attr.getLocalPart().equals("name")) {
                this.name = parser.getAttributeValue(i);
            } else if (attr.getLocalPart().equals("sid")) {
                this.sid = parser.getAttributeValue(i);
            } else if (attr.getLocalPart().equals("type")) {
                this.type = Type.valueOf(parser.getAttributeValue(i).trim());
            } else if (attr.getLocalPart().equals("layer")) {
                this.layers = XMLNode.parseLayerList(parser.getAttributeValue(i));
            } else {
                JAGTLog.exception("Unsupported ", this.getClass().getSimpleName(), " Attr tag: ", attr.getLocalPart());
            }
            ++i;
        }
        int event = parser.next();
        while (event != 8) {
            switch (event) {
                case 1: {
                    String localName = parser.getLocalName();
                    if (localName.equals("asset")) {
                        if (this.asset != null) {
                            throw new ParsingException(String.valueOf(this.getClass().getSimpleName()) + " Too MANY: " + parser.getLocalName());
                        }
                        this.asset = new XMLAsset();
                        this.asset.parse(parser);
                        break;
                    }
                    if (localName.equals("node")) {
                        XMLNode n = new XMLNode();
                        n.parse(parser);
                        this.childrenList.add(n);
                        break;
                    }
                    if (localName.equals("matrix")) {
                        this.matrix = XMLMatrixUtils.readColumnMajor(StAXHelper.parseText(parser));
                        break;
                    }
                    if (localName.equals("rotate")) {
                        this.applyRotate(StAXHelper.parseText(parser));
                        break;
                    }
                    if (localName.equals("translate")) {
                        this.applyTranslate(StAXHelper.parseText(parser));
                        break;
                    }
                    if (localName.equals("scale")) {
                        this.applyScale(StAXHelper.parseText(parser));
                        break;
                    }
                    if (localName.equals("instance_geometry")) {
                        XMLInstanceGeometry instGeom = new XMLInstanceGeometry();
                        instGeom.parse(parser);
                        this.instanceGeometries.add(instGeom);
                        break;
                    }
                    if (localName.equals("instance_controller")) {
                        XMLInstanceController instCont = new XMLInstanceController();
                        instCont.parse(parser);
                        this.instanceControllers.add(instCont);
                        break;
                    }
                    JAGTLog.exception("Unsupported ", this.getClass().getSimpleName(), " Start tag: ", parser.getLocalName());
                    break;
                }
                case 2: {
                    if (!parser.getLocalName().equals("node")) break;
                    return;
                }
            }
            event = parser.next();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        NODE,
        JOINT;

    }
}

