/*
 * Decompiled with CFR 0.152.
 */
package org.jagatoo.loaders.models.collada.stax;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jagatoo.loaders.models.collada.stax.XMLShadingParameters;
import org.jagatoo.logging.JAGTLog;

public class XMLProfileCOMMON_Technique {
    public String id = null;
    public String sid = null;
    public XMLShadingParameters constant = null;
    public XMLShadingParameters lambert = null;
    public XMLShadingParameters phong = null;
    public XMLShadingParameters blinn = null;

    private void checkVars(String name) {
        if (this.constant != null || this.lambert != null || this.phong != null || this.blinn != null) {
            JAGTLog.exception(this.getClass().getSimpleName(), " too many ", name, " tags.");
        }
    }

    public void parse(XMLStreamReader parser) throws XMLStreamException {
        int i = 0;
        while (i < parser.getAttributeCount()) {
            QName attr = parser.getAttributeName(i);
            if (attr.getLocalPart().equals("sid")) {
                this.sid = parser.getAttributeValue(i);
            } else if (attr.getLocalPart().equals("id")) {
                this.id = parser.getAttributeValue(i);
            } else {
                JAGTLog.exception("Unsupported ", this.getClass().getSimpleName(), " Attr tag: ", attr.getLocalPart());
            }
            ++i;
        }
        int event = parser.next();
        while (event != 8) {
            switch (event) {
                case 1: {
                    String localName = parser.getLocalName();
                    if (localName.equals("constant")) {
                        this.checkVars("constant");
                        this.constant = new XMLShadingParameters();
                        this.constant.parse(parser, "constant");
                        break;
                    }
                    if (localName.equals("lambert")) {
                        this.checkVars("lambert");
                        this.lambert = new XMLShadingParameters();
                        this.lambert.parse(parser, "lambert");
                        break;
                    }
                    if (localName.equals("phong")) {
                        this.checkVars("phong");
                        this.phong = new XMLShadingParameters();
                        this.phong.parse(parser, "phong");
                        break;
                    }
                    if (localName.equals("blinn")) {
                        this.checkVars("blinn");
                        this.blinn = new XMLShadingParameters();
                        this.blinn.parse(parser, "blinn");
                        break;
                    }
                    JAGTLog.exception("Unsupported ", this.getClass().getSimpleName(), " Start tag: ", parser.getLocalName());
                    break;
                }
                case 2: {
                    if (!parser.getLocalName().equals("technique")) break;
                    return;
                }
            }
            event = parser.next();
        }
    }
}

