/*
 * Decompiled with CFR 0.152.
 */
package org.jagatoo.loaders.models.md2.pak;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jagatoo.loaders.models.md2.pak.PAKHeader;
import org.jagatoo.util.streams.LittleEndianDataInputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PAKListing {
    private List<String> filenames = new ArrayList<String>();
    private Map<String, FileIndex> map = new HashMap<String, FileIndex>();

    public List<String> getFilenames() {
        return this.filenames;
    }

    public int getFileOffset(String name) {
        FileIndex index = this.map.get(name);
        if (index == null) {
            return -1;
        }
        return index.offset;
    }

    public int getFileLength(String name) {
        FileIndex index = this.map.get(name);
        if (index == null) {
            return -1;
        }
        return index.length;
    }

    private void readFileIndex(LittleEndianDataInputStream in) throws IOException {
        byte[] name = new byte[56];
        in.read(name);
        int i = 0;
        while (i < 56) {
            if (name[i] == 0) break;
            ++i;
        }
        String filename = new String(name, 0, i);
        FileIndex index = new FileIndex(in.readInt(), in.readInt());
        this.filenames.add(filename);
        this.map.put(filename, index);
    }

    public PAKListing(PAKHeader header, byte[] totalData) throws IOException {
        ByteArrayInputStream fin = new ByteArrayInputStream(totalData);
        byte[] data = new byte[header.getListingLength()];
        fin.skip(header.getListingOffset());
        fin.read(data);
        fin.close();
        LittleEndianDataInputStream in = new LittleEndianDataInputStream(new DataInputStream(new ByteArrayInputStream(data)));
        int i = 0;
        while (i < header.getListingLength() / 64) {
            this.readFileIndex(in);
            ++i;
        }
        in.close();
    }

    private class FileIndex {
        public int offset;
        public int length;

        public FileIndex(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }
    }
}

