/*
 * Decompiled with CFR 0.152.
 */
package org.jagatoo.loaders.models.obj;

import java.net.URL;
import java.util.HashMap;
import java.util.List;
import org.jagatoo.datatypes.NamedObject;
import org.jagatoo.loaders.models._util.AppearanceFactory;
import org.jagatoo.loaders.models._util.GeometryFactory;
import org.jagatoo.loaders.models._util.NodeFactory;
import org.jagatoo.loaders.models._util.SpecialItemsHandler;
import org.jagatoo.loaders.models.obj.OBJFace;
import org.jagatoo.loaders.models.obj.OBJFaceList;
import org.jagatoo.loaders.models.obj.OBJGroup;
import org.jagatoo.loaders.models.obj.OBJMaterial;
import org.jagatoo.loaders.models.obj.OBJModelPrototype;
import org.jagatoo.loaders.textures.AbstractTexture;
import org.jagatoo.opengl.enums.BlendMode;
import org.jagatoo.opengl.enums.TextureMode;
import org.openmali.spatial.bounds.BoundsType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OBJConverter {
    private static final GeometryFactory.GeometryType GEOM_TYPE = GeometryFactory.GeometryType.TRIANGLE_ARRAY;
    private static NamedObject textureAttribs = null;
    private static NamedObject transpAttribs = null;

    private static void generateAppeances(HashMap<String, OBJMaterial> matMap, HashMap<String, NamedObject> appMap, AppearanceFactory appFactory, URL baseURL) {
        for (String name : matMap.keySet()) {
            OBJMaterial oMat = matMap.get(name);
            NamedObject app = appFactory.createAppearance(name, 0);
            if (oMat.getColor() != null) {
                NamedObject coloringAttribs = appFactory.createColoringAttributes("");
                appFactory.setColoringAttribsColor(coloringAttribs, oMat.getColor(), 0, 3);
                appFactory.applyColoringAttributes(coloringAttribs, app);
            }
            NamedObject xMat = appFactory.createMaterial(name);
            appFactory.setMaterialLightingEnabled(xMat, true);
            if (oMat.getAmbientColor() != null) {
                appFactory.setMaterialAmbientColor(xMat, oMat.getAmbientColor()[0], oMat.getAmbientColor()[1], oMat.getAmbientColor()[2]);
            }
            if (oMat.getDiffuseColor() != null) {
                appFactory.setMaterialDiffuseColor(xMat, oMat.getDiffuseColor()[0], oMat.getDiffuseColor()[1], oMat.getDiffuseColor()[2]);
            }
            if (oMat.getSpecularColor() != null) {
                appFactory.setMaterialSpecularColor(xMat, oMat.getSpecularColor()[0], oMat.getSpecularColor()[1], oMat.getSpecularColor()[2]);
            }
            appFactory.setMaterialShininess(xMat, oMat.getShininess());
            appFactory.applyMaterial(xMat, app);
            if (oMat.getTextureName() != null) {
                AbstractTexture texture = appFactory.loadOrGetTexture(oMat.getTextureName(), baseURL, true, true, true, true, true);
                appFactory.applyTexture(texture, 0, app);
                if (textureAttribs == null) {
                    textureAttribs = appFactory.createTextureAttributes("SIMPLE_MODULATE");
                    appFactory.setTextureAttribsTextureMode(textureAttribs, TextureMode.MODULATE);
                }
                appFactory.applyTextureAttributes(textureAttribs, 0, app);
                if (texture.getFormat().hasAlpha()) {
                    if (transpAttribs == null) {
                        transpAttribs = appFactory.createTransparencyAttributes("SIMPLE_BLENDED");
                        appFactory.setTransparencyAttribsBlendMode(transpAttribs, BlendMode.BLENDED);
                    }
                    appFactory.applyTransparancyAttributes(transpAttribs, app);
                }
            }
            appMap.put(name, app);
        }
    }

    private static NamedObject buildShape(OBJFaceList faceList, String name, GeometryFactory geomFactory, HashMap<String, NamedObject> appMap, NodeFactory nodeFactory) {
        int totalVerts = 0;
        int[] indexs = new int[faceList.getFaces().size()];
        int i = 0;
        while (i < faceList.getFaces().size()) {
            OBJFace face = faceList.getFaces().get(i);
            totalVerts += face.getCount();
            if (i < faceList.getFaces().size() - 1) {
                indexs[i + 1] = face.getCount();
            }
            ++i;
        }
        NamedObject geom = geomFactory.createGeometry(name, GEOM_TYPE, 3, totalVerts, 0, null);
        int currentVert = 0;
        float[][] dataVerts = new float[totalVerts][3];
        float[][] dataNormals = new float[totalVerts][3];
        float[][] dataTexs = new float[totalVerts][3];
        NamedObject app = null;
        int i2 = 0;
        while (i2 < faceList.getFaces().size()) {
            OBJFace face = faceList.getFaces().get(i2);
            if (face.getMaterial() != null) {
                app = appMap.get(face.getMaterial().getName());
            }
            face.configure(dataVerts, dataNormals, dataTexs, currentVert);
            currentVert += face.getCount();
            ++i2;
        }
        boolean useTex = faceList.texturesUsed() && dataTexs != null;
        int i3 = 0;
        while (i3 < totalVerts) {
            geomFactory.setCoordinates(geom, GEOM_TYPE, i3, dataVerts[i3], 0, 1);
            geomFactory.setNormals(geom, GEOM_TYPE, i3, dataNormals[i3], 0, 1);
            if (useTex) {
                geomFactory.setTexCoords(geom, GEOM_TYPE, 0, 2, i3, dataTexs[i3], 0, 1);
            }
            ++i3;
        }
        NamedObject shape = nodeFactory.createShape(name, geom, app, BoundsType.SPHERE);
        return shape;
    }

    private static void build(HashMap<String, NamedObject> appMap, OBJGroup objGroup, NamedObject parentGroup, GeometryFactory geomFactory, NodeFactory nodeFactory, SpecialItemsHandler siHandler) {
        List<OBJGroup> children = objGroup.getChildren();
        if (children.size() > 0 || objGroup.getFaces().size() == 0) {
            String name = "";
            if (objGroup.hasName()) {
                name = objGroup.getFaces().size() > 0 ? String.valueOf(objGroup.getName()) + "_children" : objGroup.getName();
            }
            NamedObject childrenGroup = nodeFactory.createSimpleGroup(name, BoundsType.SPHERE);
            if (objGroup.hasName() && !objGroup.isTopGroup()) {
                siHandler.addSpecialItem(SpecialItemsHandler.SpecialItemType.NAMED_OBJECT, childrenGroup.getName(), childrenGroup);
            }
            int i = 0;
            while (i < children.size()) {
                OBJConverter.build(appMap, children.get(i), childrenGroup, geomFactory, nodeFactory, siHandler);
                ++i;
            }
            nodeFactory.addNodeToGroup(childrenGroup, parentGroup);
        }
        if (objGroup.getFaces().size() > 0) {
            String shapeName = objGroup.hasName() && !objGroup.isTopGroup() ? objGroup.getName() : "";
            NamedObject shape = OBJConverter.buildShape(objGroup, shapeName, geomFactory, appMap, nodeFactory);
            siHandler.addSpecialItem(SpecialItemsHandler.SpecialItemType.SHAPE, shapeName, shape);
            nodeFactory.addNodeToGroup(shape, parentGroup);
        }
    }

    public static void convert(OBJModelPrototype prototype, URL baseURL, AppearanceFactory appFactory, String skin, GeometryFactory geomFactory, boolean convertZup2Yup, float scale, NodeFactory nodeFactory, SpecialItemsHandler siHandler, NamedObject rootGroup) {
        HashMap<String, NamedObject> appMap = new HashMap<String, NamedObject>();
        OBJConverter.generateAppeances(prototype.getMaterialMap(), appMap, appFactory, baseURL);
        OBJConverter.build(appMap, prototype.getTopGroup(), rootGroup, geomFactory, nodeFactory, siHandler);
    }
}

